/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.inspections;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.flutter.FlutterUtil;
import com.jetbrains.lang.dart.ide.actions.DartPubActionBase;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartOutdatedDependenciesInspection
extends LocalInspectionTool {
    private final Set<String> myIgnoredPubspecPaths = new THashSet();

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection", "checkFile"));
        }
        if (!isOnTheFly) {
            return null;
        }
        if (!(psiFile instanceof DartFile)) {
            return null;
        }
        if (DartPubActionBase.isInProgress()) {
            return null;
        }
        VirtualFile file = DartResolveUtil.getRealVirtualFile(psiFile);
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        Project project = psiFile.getProject();
        if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) {
            return null;
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || sdk == null || !DartSdkLibUtil.isDartSdkEnabled(module)) {
            return null;
        }
        if (FlutterUtil.isFlutterPluginInstalled() && FlutterUtil.isFlutterModule(module)) {
            return null;
        }
        VirtualFile pubspecFile = PubspecYamlUtil.findPubspecYamlFile(project, file);
        if (pubspecFile == null || this.myIgnoredPubspecPaths.contains(pubspecFile.getPath())) {
            return null;
        }
        String projectName = PubspecYamlUtil.getDartProjectName(pubspecFile);
        if (projectName == null || !StringUtil.isJavaIdentifier((String)projectName)) {
            return null;
        }
        VirtualFile dotPackagesFile = pubspecFile.getParent().findChild(".packages");
        if (dotPackagesFile == null) {
            return this.createProblemDescriptors(manager, psiFile, pubspecFile, DartBundle.message("pub.get.never.done", new Object[0]));
        }
        if (FileDocumentManager.getInstance().isFileModified(pubspecFile) || pubspecFile.getTimeStamp() > dotPackagesFile.getTimeStamp()) {
            return this.createProblemDescriptors(manager, psiFile, pubspecFile, DartBundle.message("pubspec.edited", new Object[0]));
        }
        return null;
    }

    @NotNull
    private ProblemDescriptor[] createProblemDescriptors(@NotNull InspectionManager manager, @NotNull PsiFile psiFile, @NotNull VirtualFile pubspecFile, @NotNull String errorMessage) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection", "createProblemDescriptors"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection", "createProblemDescriptors"));
        }
        if (pubspecFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubspecFile", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection", "createProblemDescriptors"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection", "createProblemDescriptors"));
        }
        LocalQuickFix[] fixes = new LocalQuickFix[]{new RunPubFix(DartBundle.message("get.dependencies", new Object[0]), "Dart.pub.get"), new RunPubFix(DartBundle.message("upgrade.dependencies", new Object[0]), "Dart.pub.upgrade"), new OpenPubspecFix(), new IgnoreWarningFix(this.myIgnoredPubspecPaths, pubspecFile.getPath())};
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiFile, errorMessage, true, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        if (problemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection", "createProblemDescriptors"));
        }
        return problemDescriptorArray;
    }

    private static class IgnoreWarningFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final Set<String> myIgnoredPubspecPaths;
        @NotNull
        private final String myPubspecPath;

        public IgnoreWarningFix(@NotNull Set<String> ignoredPubspecPaths, @NotNull String pubspecPath) {
            if (ignoredPubspecPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredPubspecPaths", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix", "<init>"));
            }
            if (pubspecPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubspecPath", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix", "<init>"));
            }
            this.myIgnoredPubspecPaths = ignoredPubspecPaths;
            this.myPubspecPath = pubspecPath;
        }

        @NotNull
        public String getName() {
            String string = DartBundle.message("ignore.warning", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix", "applyFix"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix", "applyFix"));
            }
            this.myIgnoredPubspecPaths.add(this.myPubspecPath);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }

    private static class OpenPubspecFix
    extends IntentionAndQuickFixAction {
        private OpenPubspecFix() {
        }

        @NotNull
        public String getName() {
            String string = DartBundle.message("open.pubspec", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$OpenPubspecFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$OpenPubspecFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$OpenPubspecFix", "applyFix"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$OpenPubspecFix", "applyFix"));
            }
            VirtualFile file = DartResolveUtil.getRealVirtualFile(psiFile);
            if (file == null || !file.isInLocalFileSystem()) {
                return;
            }
            VirtualFile pubspecFile = PubspecYamlUtil.findPubspecYamlFile(project, file);
            if (pubspecFile == null) {
                return;
            }
            new OpenFileDescriptor(project, pubspecFile).navigate(true);
        }
    }

    private static class RunPubFix
    extends IntentionAndQuickFixAction {
        private final String myFixName;
        private final String myActionId;

        private RunPubFix(@NotNull String fixName, @NotNull String actionId) {
            if (fixName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixName", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix", "<init>"));
            }
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix", "<init>"));
            }
            this.myFixName = fixName;
            this.myActionId = actionId;
        }

        @NotNull
        public String getName() {
            String string = this.myFixName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix", "applyFix"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix", "applyFix"));
            }
            VirtualFile file = DartResolveUtil.getRealVirtualFile(psiFile);
            if (file == null || !file.isInLocalFileSystem()) {
                return;
            }
            VirtualFile pubspecFile = PubspecYamlUtil.findPubspecYamlFile(project, file);
            if (pubspecFile == null) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null) {
                return;
            }
            AnAction pubGetAction = ActionManager.getInstance().getAction(this.myActionId);
            if (pubGetAction instanceof DartPubActionBase) {
                ((DartPubActionBase)pubGetAction).performPubAction(module, pubspecFile, false);
            }
        }
    }
}

