/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.PlatformUtils;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.ide.actions.DartPubGetAction;
import com.jetbrains.lang.dart.psi.PubspecYamlReferenceContributor;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class DartPathPackageReferenceInspection
extends LocalInspectionTool {
    private static final String GROUP_DISPLAY_ID = "pubspec.yaml inspection";

    @NotNull
    public String getGroupDisplayName() {
        String string = DartBundle.message("inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = DartBundle.message("path.package.reference.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "buildVisitor"));
        }
        if (!"pubspec.yaml".equals(holder.getFile().getName())) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        DartSdk sdk = DartSdk.getDartSdk(holder.getProject());
        if (module == null || sdk == null || !DartSdkLibUtil.isDartSdkEnabled(module)) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                ProgressIndicatorProvider.checkCanceled();
                if (!(element instanceof YAMLKeyValue) || !PubspecYamlReferenceContributor.isPathPackageDefinition((YAMLKeyValue)element) || ((YAMLKeyValue)element).getValue() == null) {
                    return;
                }
                VirtualFile packageDir = DartPathPackageReferenceInspection.checkReferences(holder, (YAMLKeyValue)element);
                if (packageDir == null) {
                    return;
                }
                if (packageDir.findChild("pubspec.yaml") == null) {
                    String message = DartBundle.message("pubspec.yaml.not.found.in", FileUtil.toSystemDependentName((String)packageDir.getPath()));
                    holder.registerProblem((PsiElement)((YAMLKeyValue)element).getValue(), message, new LocalQuickFix[0]);
                    return;
                }
                VirtualFile file = DartResolveUtil.getRealVirtualFile(element.getContainingFile());
                if (file != null && packageDir.equals(file.getParent())) {
                    holder.registerProblem((PsiElement)((YAMLKeyValue)element).getValue(), DartBundle.message("path.package.reference.to.itself", new Object[0]), new LocalQuickFix[0]);
                    return;
                }
                VirtualFile libDir = packageDir.findChild("lib");
                if (libDir != null && libDir.isDirectory() && !ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInContent(libDir)) {
                    String message = DartBundle.message("folder.0.not.in.project.content", FileUtil.toSystemDependentName((String)packageDir.getPath()));
                    holder.registerProblem((PsiElement)((YAMLKeyValue)element).getValue(), message, new LocalQuickFix[]{new AddContentRootFix(module, packageDir)});
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Nullable
    private static VirtualFile checkReferences(@NotNull ProblemsHolder holder, @NotNull YAMLKeyValue element) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "checkReferences"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection", "checkReferences"));
        }
        for (PsiReference reference : element.getReferences()) {
            VirtualFile dir;
            if (!(reference instanceof FileReference) || reference.isSoft()) continue;
            PsiFileSystemItem resolve = ((FileReference)reference).resolve();
            if (resolve == null) {
                holder.registerProblem(reference.getElement(), ((FileReference)reference).getUnresolvedMessagePattern(), ProblemHighlightType.GENERIC_ERROR, reference.getRangeInElement(), new LocalQuickFix[0]);
                return null;
            }
            if (!((FileReference)reference).isLast() || (dir = resolve.getVirtualFile()) == null || !dir.isDirectory()) continue;
            return dir;
        }
        return null;
    }

    private static void openProjectRootsConfigurable(Module module) {
        if (PlatformUtils.isWebStorm() || PlatformUtils.isPhpStorm() || PlatformUtils.isPyCharm() || PlatformUtils.isRubyMine()) {
            ShowSettingsUtil.getInstance().showSettingsDialog(module.getProject(), DartPathPackageReferenceInspection.getProjectRootsConfigurableName());
        } else {
            ProjectSettingsService.getInstance((Project)module.getProject()).openContentEntriesSettings(module);
        }
    }

    private static String getProjectRootsConfigurableName() {
        if (PlatformUtils.isWebStorm() || PlatformUtils.isPhpStorm()) {
            return "Directories";
        }
        if (PlatformUtils.isRubyMine()) {
            return "Project Structure";
        }
        if (PlatformUtils.isPyCharm()) {
            return "Project Structure";
        }
        return "Project Structure";
    }

    private static class AddContentRootFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final Module myModule;
        @NotNull
        private final VirtualFile myContentRoot;

        private AddContentRootFix(@NotNull Module module, @NotNull VirtualFile contentRoot) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "<init>"));
            }
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "<init>"));
            }
            this.myModule = module;
            this.myContentRoot = contentRoot;
        }

        @NotNull
        public String getName() {
            String string = DartBundle.message("configure.folder.0.as.content.root", FileUtil.toSystemDependentName((String)this.myContentRoot.getPath()));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = DartBundle.message("configure.folder.as.content.root", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "applyFix"));
            }
            try {
                AddContentRootFix.checkCanAddContentRoot(this.myModule, this.myContentRoot);
            }
            catch (Exception e) {
                AddContentRootFix.showErrorDialog(this.myModule, e);
                return;
            }
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            try {
                modifiableModel.addContentEntry(this.myContentRoot);
                ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
                VirtualFile otherPubspec = this.myContentRoot.findChild("pubspec.yaml");
                if (otherPubspec != null) {
                    DartProjectComponent.excludeBuildAndPackagesFolders(this.myModule, otherPubspec);
                    AnAction pubGetAction = ActionManager.getInstance().getAction("Dart.pub.get");
                    if (pubGetAction instanceof DartPubGetAction) {
                        ((DartPubGetAction)pubGetAction).performPubAction(this.myModule, otherPubspec, false);
                    }
                }
                AddContentRootFix.showSuccessNotification(this.myModule, this.myContentRoot);
            }
            catch (Exception e) {
                AddContentRootFix.showErrorDialog(this.myModule, e);
            }
            finally {
                if (!modifiableModel.isDisposed()) {
                    modifiableModel.dispose();
                }
            }
            VirtualFile yamlFile = DartResolveUtil.getRealVirtualFile(psiFile);
            if (yamlFile != null && "pubspec.yaml".equals(yamlFile.getName())) {
                DartProjectComponent.excludeBuildAndPackagesFolders(this.myModule, yamlFile);
            }
        }

        private static void showSuccessNotification(final @NotNull Module module, @NotNull VirtualFile root) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "showSuccessNotification"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "showSuccessNotification"));
            }
            String title = DartBundle.message("content.root.added.title", new Object[0]);
            String message = DartSdkLibUtil.isIdeWithMultipleModuleSupport() ? DartBundle.message("content.root.added.to.module", module.getName(), FileUtil.toSystemDependentName((String)root.getPath())) : DartBundle.message("content.root.added.to.project", FileUtil.toSystemDependentName((String)root.getPath()), CommonBundle.settingsTitle(), DartPathPackageReferenceInspection.getProjectRootsConfigurableName());
            Notifications.Bus.notify((Notification)new Notification(DartPathPackageReferenceInspection.GROUP_DISPLAY_ID, title, message, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix$1", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix$1", "hyperlinkActivated"));
                    }
                    DartPathPackageReferenceInspection.openProjectRootsConfigurable(module);
                }
            }));
        }

        private static void showErrorDialog(@NotNull Module module, @NotNull Exception e) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "showErrorDialog"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "showErrorDialog"));
            }
            String message = DartBundle.message("can.not.add.content.root", e.getMessage());
            String title = DartBundle.message("add.content.root.title", new Object[0]);
            String okText = DartBundle.message("configure.project.roots", new Object[0]);
            String cancelText = CommonBundle.getCancelButtonText();
            int choice = Messages.showOkCancelDialog((Project)module.getProject(), (String)message, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon());
            if (choice == 0) {
                DartPathPackageReferenceInspection.openProjectRootsConfigurable(module);
            }
        }

        private static void checkCanAddContentRoot(@NotNull Module module, @NotNull VirtualFile contentRoot) throws Exception {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "checkCanAddContentRoot"));
            }
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix", "checkCanAddContentRoot"));
            }
            for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (virtualFile.equals(contentRoot)) {
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.already.exists.error", (Object[])new Object[]{contentRoot.getPresentableUrl()}));
                }
                if (VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)contentRoot, (boolean)true)) {
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.intersect.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), virtualFile.getPresentableUrl()}));
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)virtualFile, (boolean)true)) continue;
                throw new Exception(ProjectBundle.message((String)"module.paths.add.content.dominate.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), virtualFile.getPresentableUrl()}));
            }
            for (VirtualFile virtualFile : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
                if (module.equals(virtualFile)) continue;
                for (VirtualFile moduleContentRoot : ModuleRootManager.getInstance((Module)virtualFile).getContentRoots()) {
                    if (!contentRoot.equals(moduleContentRoot)) continue;
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.duplicate.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), virtualFile.getName()}));
                }
            }
        }
    }
}

