/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.marker;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.actions.DartInheritorsSearcher;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerImplementationsMarkerProvider
implements LineMarkerProvider {
    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "getLineMarkerInfo"));
        }
        if (!(element instanceof DartComponentName)) {
            return null;
        }
        DartComponentName name = (DartComponentName)element;
        return DartServerImplementationsMarkerProvider.createMarker(name);
    }

    @Nullable
    private static LineMarkerInfo createMarker(@NotNull DartComponentName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "createMarker"));
        }
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(name.getProject());
        VirtualFile file = name.getContainingFile().getVirtualFile();
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        int nameOffset = name.getTextRange().getStartOffset();
        int nameLength = name.getTextLength();
        if ("Object".equals(name.getName())) {
            return null;
        }
        for (DartServerData.DartRegion implementedClassRegion : service.getImplementedClasses(file)) {
            if (implementedClassRegion.getOffset() != nameOffset || implementedClassRegion.getLength() != nameLength) continue;
            return DartServerImplementationsMarkerProvider.createMarkerClass(name);
        }
        for (DartServerData.DartRegion implementedMemberRegion : service.getImplementedMembers(file)) {
            if (implementedMemberRegion.getOffset() != nameOffset || implementedMemberRegion.getLength() != nameLength) continue;
            return DartServerImplementationsMarkerProvider.createMarkerMember(name);
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createMarkerClass(final @NotNull DartComponentName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "createMarkerClass"));
        }
        final VirtualFile file = name.getContainingFile().getVirtualFile();
        final int nameOffset = name.getTextRange().getStartOffset();
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo((PsiElement)name, name.getTextRange(), AllIcons.Gutter.OverridenMethod, 11, element -> DaemonBundle.message((String)"class.is.subclassed.too.many", (Object[])new Object[0]), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                List<TypeHierarchyItem> items = DartAnalysisServerService.getInstance(name.getProject()).search_getTypeHierarchy(file, nameOffset, false);
                if (items.isEmpty()) {
                    return;
                }
                List<DartComponent> components = DartInheritorsSearcher.getSubClasses(name.getProject(), (SearchScope)GlobalSearchScope.allScope((Project)name.getProject()), items);
                PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])DartResolveUtil.getComponentNameArray(components), (String)DaemonBundle.message((String)"navigation.title.subclass", (Object[])new Object[]{name.getName(), components.size(), ""}), (String)("Subclasses of " + name.getName()), (ListCellRenderer)new DefaultPsiElementCellRenderer());
            }
        }, GutterIconRenderer.Alignment.RIGHT);
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "createMarkerClass"));
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo createMarkerMember(final @NotNull DartComponentName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "createMarkerMember"));
        }
        final VirtualFile file = name.getContainingFile().getVirtualFile();
        final int nameOffset = name.getTextRange().getStartOffset();
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo((PsiElement)name, name.getTextRange(), AllIcons.Gutter.OverridenMethod, 11, element -> DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                List<TypeHierarchyItem> items = DartAnalysisServerService.getInstance(name.getProject()).search_getTypeHierarchy(file, nameOffset, false);
                if (items.isEmpty()) {
                    return;
                }
                List<DartComponent> components = DartInheritorsSearcher.getSubMembers(name.getProject(), (SearchScope)GlobalSearchScope.allScope((Project)name.getProject()), items);
                PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])DartResolveUtil.getComponentNameArray(components), (String)DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{name.getName(), components.size()}), (String)("Overriding methods of " + name.getName()), (ListCellRenderer)new DefaultPsiElementCellRenderer());
            }
        }, GutterIconRenderer.Alignment.RIGHT);
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider", "createMarkerMember"));
        }
        return lineMarkerInfo;
    }
}

