/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.marker;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.dartlang.analysis.server.protocol.OverriddenMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerOverrideMarkerProvider
implements LineMarkerProvider {
    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/marker/DartServerOverrideMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/lang/dart/ide/marker/DartServerOverrideMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/marker/DartServerOverrideMarkerProvider", "getLineMarkerInfo"));
        }
        if (!(element instanceof DartComponentName)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof DartComponent) {
            DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)element, DartClass.class);
            return dartClass == null ? null : DartServerOverrideMarkerProvider.createOverrideMarker((DartComponentName)element);
        }
        return null;
    }

    private static void addDartComponent(List<DartComponent> components, Project project, OverriddenMember member) {
        DartComponent component;
        DartComponent dartComponent = component = member == null ? null : DartHierarchyUtil.findDartComponent(project, member.getElement().getLocation());
        if (component != null) {
            components.add(component);
        }
    }

    @Nullable
    private static LineMarkerInfo createOverrideMarker(DartComponentName componentName) {
        VirtualFile virtualFile = componentName.getContainingFile().getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return null;
        }
        List<DartServerData.DartOverrideMember> overrideMembers = DartAnalysisServerService.getInstance(componentName.getProject()).getOverrideMembers(virtualFile);
        Project project = componentName.getProject();
        int nameOffset = componentName.getTextRange().getStartOffset();
        DartComponent superclassComponent = null;
        ArrayList interfaceComponents = Lists.newArrayList();
        for (DartServerData.DartOverrideMember overrideMember : overrideMembers) {
            if (overrideMember.getOffset() != nameOffset) continue;
            OverriddenMember member = overrideMember.getSuperclassMember();
            DartComponent dartComponent = superclassComponent = member == null ? null : DartHierarchyUtil.findDartComponent(project, member.getElement().getLocation());
            if (overrideMember.getInterfaceMembers() == null) continue;
            for (OverriddenMember overriddenMember : overrideMember.getInterfaceMembers()) {
                DartServerOverrideMarkerProvider.addDartComponent(interfaceComponents, project, overriddenMember);
            }
        }
        return DartServerOverrideMarkerProvider.tryCreateOverrideMarker(componentName, superclassComponent, interfaceComponents);
    }

    @Nullable
    private static LineMarkerInfo tryCreateOverrideMarker(@NotNull DartComponentName componentName, final @Nullable DartComponent superclassComponent, final @NotNull List<DartComponent> interfaceComponents) {
        DartComponent superComponent;
        boolean overrides;
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/jetbrains/lang/dart/ide/marker/DartServerOverrideMarkerProvider", "tryCreateOverrideMarker"));
        }
        if (interfaceComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceComponents", "com/jetbrains/lang/dart/ide/marker/DartServerOverrideMarkerProvider", "tryCreateOverrideMarker"));
        }
        if (superclassComponent == null && interfaceComponents.isEmpty()) {
            return null;
        }
        final String name = componentName.getName();
        if (superclassComponent != null) {
            overrides = true;
            superComponent = superclassComponent;
        } else {
            overrides = false;
            superComponent = interfaceComponents.iterator().next();
        }
        Icon icon = overrides ? AllIcons.Gutter.OverridingMethod : AllIcons.Gutter.ImplementingMethod;
        return new LineMarkerInfo((PsiElement)componentName, componentName.getTextRange(), icon, 11, element -> {
            DartClass superClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)superComponent, DartClass.class);
            if (superClass == null) {
                return "null";
            }
            if (overrides) {
                return superclassComponent.isOperator() ? DartBundle.message("overrides.operator.in", name, superClass.getName()) : DartBundle.message("overrides.method.in", name, superClass.getName());
            }
            return DartBundle.message("implements.method.in", name, superClass.getName());
        }, (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                ArrayList superComponents = Lists.newArrayList();
                if (superclassComponent != null) {
                    superComponents.add(superclassComponent);
                }
                superComponents.addAll(interfaceComponents);
                PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])DartResolveUtil.getComponentNameArray(superComponents), (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{name}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{name}), (ListCellRenderer)new DefaultPsiElementCellRenderer());
            }
        }, GutterIconRenderer.Alignment.LEFT);
    }
}

