/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.moveCode;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.psi.DartClassBody;
import com.jetbrains.lang.dart.psi.DartClassMembers;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartLibraryStatement;
import com.jetbrains.lang.dart.psi.DartUriBasedDirective;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartComponentMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover", "checkAvailable"));
        }
        if (!(file instanceof DartFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        CodeMover codeMover = new CodeMover(editor, file, info, down);
        codeMover.findSourceComponents();
        if (!codeMover.hasSourceComponents()) {
            return false;
        }
        codeMover.findSourceLineRange();
        if (!codeMover.hasSourceLineRange()) {
            return false;
        }
        codeMover.findTargetComponents();
        if (!codeMover.hasTargetComponents()) {
            return info.toMove2 == null;
        }
        codeMover.findTargetLineRange();
        if (!codeMover.hasTargetLineRange()) {
            return info.toMove2 == null;
        }
        if (codeMover.areTargetsAtSameLevel()) {
            info.indentTarget = false;
        }
        info.toMove = codeMover.sourceRange;
        info.toMove2 = codeMover.targetRange;
        return true;
    }

    @VisibleForTesting
    static Pair<PsiElement, PsiElement> findCommentRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover", "findCommentRange"));
        }
        return CodeMover.findCommentRange(element);
    }

    private static class CodeMover {
        @NotNull
        final Editor editor;
        @NotNull
        final PsiFile file;
        @NotNull
        final StatementUpDownMover.MoveInfo info;
        final boolean isMovingDown;
        Pair<PsiElement, PsiElement> sourceComponents;
        Pair<PsiElement, PsiElement> targetComponents;
        LineRange sourceRange;
        LineRange targetRange;

        CodeMover(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "<init>"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "<init>"));
            }
            this.editor = editor;
            this.file = file;
            this.info = info;
            this.isMovingDown = down;
        }

        @Nullable
        static Pair<PsiElement, PsiElement> findCommentRange(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findCommentRange"));
            }
            if (!CodeMover.isComment(element) && !(element instanceof PsiWhiteSpace)) {
                return null;
            }
            PsiElement first = CodeMover.findFinalComment(element, false);
            PsiElement last = CodeMover.findFinalComment(element, true);
            if (CodeMover.commentTypeOf(first) != CodeMover.commentTypeOf(last)) {
                last = element.getPrevSibling();
            }
            return Pair.create((Object)first, (Object)last);
        }

        boolean hasSourceComponents() {
            return this.sourceComponents != null && this.sourceComponents.first != null;
        }

        void findSourceComponents() {
            PsiElement next;
            PsiElement lastMember;
            Pair psiRange = DartComponentMover.getElementRange((Editor)this.editor, (PsiFile)this.file, (LineRange)this.info.toMove);
            if (psiRange == null) {
                return;
            }
            PsiElement firstMember = CodeMover.getDeclarationParent(CodeMover.firstMoveableComponent((PsiElement)psiRange.first));
            if (firstMember == null) {
                return;
            }
            if (CodeMover.isComment(firstMember)) {
                lastMember = CodeMover.findAttachedDeclaration(firstMember);
                if (lastMember == firstMember) {
                    lastMember = CodeMover.getDeclarationParent((PsiElement)psiRange.second);
                }
            } else {
                lastMember = firstMember;
                if ((firstMember = CodeMover.findAttachedComment(firstMember)) == lastMember && !this.isMovingDown && lastMember.getParent() instanceof DartClassMembers) {
                    DartClassMembers members = (DartClassMembers)lastMember.getParent();
                    next = CodeMover.nextSib((PsiElement)members, false);
                    if (next instanceof PsiWhiteSpace && !CodeMover.isCommentSeparator(next)) {
                        next = CodeMover.nextSib(next, false);
                    }
                    if (CodeMover.isComment(next)) {
                        firstMember = next;
                    }
                }
            }
            if (lastMember == null) {
                return;
            }
            PsiElement sibling = lastMember.getNextSibling();
            if (!CodeMover.isCommentSeparator(sibling)) {
                next = DartComponentMover.firstNonWhiteElement((PsiElement)lastMember.getNextSibling(), (boolean)true);
                if (CodeMover.isSemicolon(next)) {
                    lastMember = next;
                }
                if (this.isMovingDown) {
                    next = lastMember.getNextSibling();
                    if (next == null && lastMember.getParent() instanceof DartClassMembers) {
                        DartClassMembers members = (DartClassMembers)lastMember.getParent();
                        next = CodeMover.nextSib((PsiElement)members, true);
                    }
                    if (next instanceof PsiWhiteSpace && !StringUtil.containsLineBreak((CharSequence)next.getText())) {
                        next = next.getNextSibling();
                    }
                    if (next != null && CodeMover.isLineComment(next)) {
                        lastMember = next;
                    }
                }
            }
            this.sourceComponents = Pair.create((Object)firstMember, (Object)lastMember);
        }

        boolean hasSourceLineRange() {
            return this.sourceRange != null;
        }

        void findSourceLineRange() {
            LineRange range;
            if (this.sourceComponents.first == this.sourceComponents.second) {
                range = this.memberRange((PsiElement)this.sourceComponents.first);
                if (range == null) {
                    return;
                }
                range.firstElement = range.lastElement = (PsiElement)this.sourceComponents.first;
            } else {
                PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)this.sourceComponents.first), (PsiElement)((PsiElement)this.sourceComponents.second));
                if (parent == null) {
                    return;
                }
                if (parent instanceof DartClassBody) {
                    return;
                }
                Pair combinedRange = DartComponentMover.getElementRange((PsiElement)parent, (PsiElement)((PsiElement)this.sourceComponents.first), (PsiElement)((PsiElement)this.sourceComponents.second));
                if (combinedRange == null) {
                    return;
                }
                LineRange lineRange1 = this.memberRange((PsiElement)combinedRange.first);
                if (lineRange1 == null) {
                    return;
                }
                LineRange lineRange2 = this.memberRange((PsiElement)combinedRange.second);
                if (lineRange2 == null) {
                    return;
                }
                range = new LineRange(lineRange1.startLine, lineRange2.endLine);
                range.firstElement = (PsiElement)combinedRange.first;
                range.lastElement = (PsiElement)combinedRange.second;
            }
            this.sourceRange = range;
        }

        boolean hasTargetComponents() {
            return this.targetComponents != null && this.targetComponents.first != null;
        }

        void findTargetComponents() {
            PsiElement lastElement;
            PsiElement firstElement;
            PsiElement next;
            PsiElement ref = this.isMovingDown ? this.sourceRange.lastElement : this.sourceRange.firstElement;
            PsiElement sibling = CodeMover.nextSib(ref, this.isMovingDown);
            if (sibling instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)sibling.getText()) == 0 && CodeMover.isLineComment(next = sibling.getNextSibling())) {
                sibling = next.getNextSibling();
            }
            if (sibling == null && ref.getParent() instanceof DartClassMembers) {
                DartClassMembers members = (DartClassMembers)ref.getParent();
                sibling = CodeMover.nextSib((PsiElement)members, this.isMovingDown);
            }
            if ((firstElement = DartComponentMover.firstNonWhiteElement((PsiElement)sibling, (boolean)this.isMovingDown)) == null) {
                PsiElement psiElement = firstElement = sibling == null ? ref : sibling;
            }
            if (CodeMover.isComment(firstElement)) {
                lastElement = CodeMover.isCommentSeparator(sibling) ? firstElement : CodeMover.findAttachedDeclaration(firstElement);
            } else {
                PsiElement psiElement = lastElement = this.isMovingDown ? firstElement : CodeMover.findAttachedComment(firstElement);
            }
            if (firstElement instanceof PsiWhiteSpace || lastElement instanceof PsiWhiteSpace) {
                this.info.prohibitMove();
                return;
            }
            this.targetComponents = this.isMovingDown ? Pair.create((Object)firstElement, (Object)lastElement) : Pair.create((Object)lastElement, (Object)firstElement);
        }

        boolean hasTargetLineRange() {
            return this.targetRange != null;
        }

        void findTargetLineRange() {
            PsiElement target;
            PsiElement source = this.isMovingDown ? this.sourceRange.lastElement : this.sourceRange.firstElement;
            PsiElement psiElement = target = this.isMovingDown ? (PsiElement)this.targetComponents.first : (PsiElement)this.targetComponents.second;
            if (CodeMover.crossesHeaderBoundary(source, target)) {
                this.info.prohibitMove();
                return;
            }
            this.targetRange = new LineRange((PsiElement)this.targetComponents.first, (PsiElement)this.targetComponents.second, this.editor.getDocument());
        }

        boolean areTargetsAtSameLevel() {
            return ((PsiElement)this.sourceComponents.second).getParent() == ((PsiElement)this.targetComponents.second).getParent();
        }

        private LineRange memberRange(@NotNull PsiElement member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "memberRange"));
            }
            TextRange textRange = member.getTextRange();
            if (this.editor.getDocument().getTextLength() < textRange.getEndOffset()) {
                return null;
            }
            LogicalPosition startPosition = this.editor.offsetToLogicalPosition(textRange.getStartOffset());
            LogicalPosition endPosition = this.editor.offsetToLogicalPosition(textRange.getEndOffset());
            int endLine = endPosition.line + 1;
            return new LineRange(startPosition.line, endLine);
        }

        @NotNull
        private static PsiElement findAttachedDeclaration(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findAttachedDeclaration"));
            }
            PsiElement commentEnd = CodeMover.findFinalComment(element, true);
            if (CodeMover.isCommentSeparator(commentEnd.getNextSibling())) {
                PsiElement psiElement = commentEnd;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findAttachedDeclaration"));
                }
                return psiElement;
            }
            PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)commentEnd, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement = next == null ? element : (CodeMover.isComment(next) ? element : next);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findAttachedDeclaration"));
            }
            return psiElement;
        }

        @NotNull
        private static PsiElement findAttachedComment(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findAttachedComment"));
            }
            PsiElement sib = CodeMover.isComment(element) ? element : element.getPrevSibling();
            PsiElement commentStart = CodeMover.findFinalComment(sib == null ? element : sib, false);
            PsiElement psiElement = commentStart == sib && commentStart instanceof PsiWhiteSpace ? element : commentStart;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findAttachedComment"));
            }
            return psiElement;
        }

        private static PsiElement nextSib(@NotNull PsiElement element, boolean isForward) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "nextSib"));
            }
            return isForward ? element.getNextSibling() : element.getPrevSibling();
        }

        private static boolean isCommentSeparator(@Nullable PsiElement element) {
            return element instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)element.getText()) > 1;
        }

        @NotNull
        private static PsiElement findFinalComment(@NotNull PsiElement element, boolean isForward) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findFinalComment"));
            }
            PsiElement target = element;
            PsiElement sib = element;
            CommentType groupType = null;
            while (sib != null) {
                if (sib instanceof PsiWhiteSpace) {
                    if (CodeMover.isCommentSeparator(sib)) break;
                    sib = CodeMover.nextSib(sib, isForward);
                    continue;
                }
                CommentType type = CodeMover.commentTypeOf(sib);
                switch (type) {
                    case INVALID: {
                        PsiElement parent = sib.getParent();
                        if (parent instanceof DartFile) {
                            PsiElement psiElement = sib;
                            if (psiElement == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findFinalComment"));
                            }
                            return psiElement;
                        }
                        PsiElement psiElement = CodeMover.findFinalComment(parent, isForward);
                        if (psiElement == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findFinalComment"));
                        }
                        return psiElement;
                    }
                    case MULTI_LINE_DOC_COMMENT: {
                        PsiElement psiElement = sib;
                        if (psiElement == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findFinalComment"));
                        }
                        return psiElement;
                    }
                    case MULTI_LINE_COMMENT: 
                    case SINGLE_LINE_DOC_COMMENT: 
                    case SINGLE_LINE_COMMENT: {
                        if (groupType == null) {
                            groupType = type;
                        }
                        if (groupType == type) {
                            target = sib;
                            sib = CodeMover.nextSib(sib, isForward);
                            break;
                        }
                        sib = null;
                        break;
                    }
                    case NONE: {
                        sib = null;
                    }
                }
            }
            PsiElement psiElement = target;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "findFinalComment"));
            }
            return psiElement;
        }

        private static boolean isLineComment(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "isLineComment"));
            }
            switch (CodeMover.commentTypeOf(element)) {
                case SINGLE_LINE_DOC_COMMENT: 
                case SINGLE_LINE_COMMENT: {
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private static CommentType commentTypeOf(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "commentTypeOf"));
            }
            IElementType type = element.getNode().getElementType();
            if (type == DartTokenTypesSets.SINGLE_LINE_COMMENT) {
                CommentType commentType = CommentType.SINGLE_LINE_COMMENT;
                if (commentType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "commentTypeOf"));
                }
                return commentType;
            }
            if (type == DartTokenTypesSets.MULTI_LINE_COMMENT) {
                CommentType commentType = CommentType.MULTI_LINE_COMMENT;
                if (commentType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "commentTypeOf"));
                }
                return commentType;
            }
            if (type == DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT) {
                CommentType commentType = CommentType.SINGLE_LINE_DOC_COMMENT;
                if (commentType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "commentTypeOf"));
                }
                return commentType;
            }
            if (type == DartTokenTypesSets.MULTI_LINE_DOC_COMMENT) {
                CommentType commentType = CommentType.MULTI_LINE_DOC_COMMENT;
                if (commentType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "commentTypeOf"));
                }
                return commentType;
            }
            if (DartTokenTypesSets.DOC_COMMENT_CONTENTS.contains(type)) {
                CommentType commentType = CommentType.INVALID;
                if (commentType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "commentTypeOf"));
                }
                return commentType;
            }
            CommentType commentType = CommentType.NONE;
            if (commentType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "commentTypeOf"));
            }
            return commentType;
        }

        private static PsiElement getDeclarationParent(PsiElement element) {
            if (CodeMover.isComment(element)) {
                return element;
            }
            PsiElement parent = CodeMover.getHeaderParent(element);
            if (parent != null) {
                return parent;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)element, DartVarDeclarationList.class, (boolean)false);
            if (parent != null && (parent.getParent() instanceof DartFile || parent.getParent() instanceof DartClassMembers)) {
                return parent;
            }
            if (element instanceof LeafPsiElement && (element.getParent() instanceof DartFile || element.getParent() instanceof DartClassMembers)) {
                return element;
            }
            if (element instanceof DartClassMembers) {
                PsiElement last = element.getLastChild();
                if ((last = PsiTreeUtil.skipSiblingsBackward((PsiElement)last, (Class[])new Class[]{LeafPsiElement.class, PsiWhiteSpace.class})) != null) {
                    return last;
                }
            }
            return PsiTreeUtil.getParentOfType((PsiElement)element, DartComponent.class, (boolean)false);
        }

        private static boolean crossesHeaderBoundary(PsiElement base, PsiElement sibling) {
            if (CodeMover.isComment(base) || CodeMover.isComment(sibling)) {
                return false;
            }
            PsiElement baseType = CodeMover.getHeaderParent(base);
            PsiElement sibType = CodeMover.getHeaderParent(sibling);
            if (baseType == null && sibType == null) {
                return false;
            }
            if (baseType == null || sibType == null) {
                return true;
            }
            if (baseType instanceof DartLibraryStatement && sibType instanceof DartLibraryStatement) {
                return false;
            }
            return baseType instanceof DartLibraryStatement || sibType instanceof DartLibraryStatement;
        }

        private static PsiElement getHeaderParent(PsiElement element) {
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{DartUriBasedDirective.class, DartLibraryStatement.class});
        }

        private static boolean isComment(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover", "isComment"));
            }
            IElementType type = element.getNode().getElementType();
            return DartTokenTypesSets.COMMENTS.contains(type) || DartTokenTypesSets.DOC_COMMENT_CONTENTS.contains(type);
        }

        private static boolean isSemicolon(PsiElement element) {
            return element instanceof LeafPsiElement;
        }

        private static PsiElement firstMoveableComponent(PsiElement element) {
            if (element instanceof DartClassMembers) {
                return element.getFirstChild();
            }
            return element;
        }
    }

    private static enum CommentType {
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        SINGLE_LINE_DOC_COMMENT,
        MULTI_LINE_DOC_COMMENT,
        INVALID,
        NONE;

    }
}

