/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.moveCode;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartAssertStatement;
import com.jetbrains.lang.dart.psi.DartBlock;
import com.jetbrains.lang.dart.psi.DartBreakStatement;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassBody;
import com.jetbrains.lang.dart.psi.DartClassDefinition;
import com.jetbrains.lang.dart.psi.DartContinueStatement;
import com.jetbrains.lang.dart.psi.DartDoWhileStatement;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartExpressionList;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartForStatement;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartFunctionExpression;
import com.jetbrains.lang.dart.psi.DartIfStatement;
import com.jetbrains.lang.dart.psi.DartListLiteralExpression;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNamedArgument;
import com.jetbrains.lang.dart.psi.DartPsiCompositeElement;
import com.jetbrains.lang.dart.psi.DartRethrowStatement;
import com.jetbrains.lang.dart.psi.DartReturnStatement;
import com.jetbrains.lang.dart.psi.DartStatements;
import com.jetbrains.lang.dart.psi.DartSwitchStatement;
import com.jetbrains.lang.dart.psi.DartTryStatement;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVisitor;
import com.jetbrains.lang.dart.psi.DartWhileStatement;
import com.jetbrains.lang.dart.psi.DartYieldEachStatement;
import com.jetbrains.lang.dart.psi.DartYieldStatement;
import com.jetbrains.lang.dart.psi.IDartBlock;
import com.jetbrains.lang.dart.util.DartPsiImplUtil;
import com.jetbrains.lang.dart.util.DartRefactoringUtil;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartStatementMover
extends LineMover {
    static final TokenSet NESTED_GUARDS = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.LIST_LITERAL_EXPRESSION, DartTokenTypes.ARGUMENT_LIST, DartTokenTypes.ARGUMENTS});
    private SmartPsiElementPointer statementToSurroundWithCodeBlock;

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "afterMove"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "afterMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "afterMove"));
        }
        super.afterMove(editor, file, info, down);
        this.statementToSurroundWithCodeBlock = null;
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "beforeMove"));
        }
        super.beforeMove(editor, info, down);
        if (this.statementToSurroundWithCodeBlock != null) {
            this.surroundWithCodeBlock(info, down);
        }
    }

    private void surroundWithCodeBlock(@NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "surroundWithCodeBlock"));
        }
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int endOffset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "checkAvailable"));
        }
        if (!(file instanceof DartFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        LineRange range = DartStatementMover.expandLineRangeToCoverPsiElements(info.toMove, editor, file);
        if (range == null) {
            return false;
        }
        info.toMove = range;
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement[] statements = DartRefactoringUtil.findListExpressionInRange(file, startOffset, endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)));
        if (statements.length == 1) {
            info.toMove2 = null;
            return true;
        }
        if (statements.length == 0) {
            statements = DartRefactoringUtil.findStatementsInRange(file, startOffset, endOffset);
        }
        if (statements.length == 0) {
            return false;
        }
        range.firstElement = statements[0];
        range.lastElement = statements[statements.length - 1];
        info.indentTarget = true;
        if (!this.checkMovingInsideOutside(file, editor, info, down)) {
            info.toMove2 = null;
        }
        return true;
    }

    private static LineRange expandLineRangeToCoverPsiElements(LineRange range, Editor editor, PsiFile file) {
        int endLine;
        Document document;
        PsiElement parent;
        Pair elementRange;
        PsiElement statement;
        PsiElement last;
        PsiElement first;
        Pair psiRange = DartStatementMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)range);
        if (psiRange == null) {
            return null;
        }
        if (psiRange.first instanceof DartStatements || psiRange.first instanceof DartExpressionList || psiRange.first instanceof DartArgumentList) {
            first = (PsiElement)psiRange.first;
            last = (PsiElement)psiRange.second;
            if (last != null && (statement = first.getFirstChild()) != null) {
                psiRange = Pair.create((Object)statement, (Object)last);
            }
        } else if (psiRange.first instanceof DartNamedArgument && ((PsiElement)psiRange.first).getParent() == psiRange.second) {
            psiRange = Pair.create((Object)psiRange.first, (Object)psiRange.first);
        }
        if (psiRange.second instanceof DartStatements && PsiTreeUtil.isAncestor((PsiElement)(last = (PsiElement)psiRange.second), (PsiElement)(first = (PsiElement)psiRange.first), (boolean)false) && (statement = last.getLastChild()) != null) {
            psiRange = Pair.create((Object)first, (Object)statement);
        }
        if (DartRefactoringUtil.isComma((PsiElement)psiRange.second)) {
            first = (PsiElement)psiRange.first;
            last = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments((PsiElement)psiRange.second, true);
            if (PsiTreeUtil.isAncestor((PsiElement)last, (PsiElement)first, (boolean)false) && (statement = last.getLastChild()) != null) {
                psiRange = Pair.create((Object)first, (Object)statement);
            }
        }
        if ((elementRange = DartStatementMover.getElementRange((PsiElement)(parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)psiRange.first), (PsiElement)((PsiElement)psiRange.second))), (PsiElement)((PsiElement)psiRange.first), (PsiElement)((PsiElement)psiRange.second))) == null) {
            return null;
        }
        int endOffset = ((PsiElement)elementRange.second).getTextRange().getEndOffset();
        if (endOffset > (document = editor.getDocument()).getTextLength()) {
            return null;
        }
        if (endOffset == document.getTextLength()) {
            endLine = document.getLineCount();
        } else {
            endLine = editor.offsetToLogicalPosition((int)endOffset).line + 1;
            endLine = Math.min(endLine, document.getLineCount());
        }
        int startLine = Math.min(range.startLine, editor.offsetToLogicalPosition((int)((PsiElement)elementRange.first).getTextOffset()).line);
        endLine = Math.max(endLine, range.endLine);
        return new LineRange(startLine, endLine);
    }

    private boolean checkMovingInsideOutside(PsiFile file, Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement parent;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "checkMovingInsideOutside"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtOffset = file.getViewProvider().findElementAt(offset, DartLanguage.INSTANCE);
        if (elementAtOffset == null) {
            return false;
        }
        PsiElement guard = elementAtOffset;
        boolean isExpr = DartStatementMover.isMovingExpr(info.toMove);
        guard = isExpr ? PsiTreeUtil.getParentOfType((PsiElement)guard, (Class[])new Class[]{DartMethodDeclaration.class, DartListLiteralExpression.class, DartArgumentList.class, DartArguments.class, DartFunctionDeclarationWithBodyOrNative.class, DartClass.class, PsiComment.class}) : PsiTreeUtil.getParentOfType((PsiElement)guard, (Class[])new Class[]{DartMethodDeclaration.class, DartFunctionDeclarationWithBodyOrNative.class, DartClass.class, PsiComment.class});
        PsiElement brace = DartStatementMover.soloRightBraceBeingMoved(file, editor);
        if (brace != null) {
            int line = editor.getDocument().getLineNumber(offset);
            LineRange toMove = new LineRange(line, line + 1);
            toMove.firstElement = toMove.lastElement = brace;
            info.toMove = toMove;
        }
        if (!this.calcInsertOffset(file, editor, info.toMove, info, down)) {
            return false;
        }
        int insertOffset = down ? DartStatementMover.getLineStartSafeOffset((Document)editor.getDocument(), (int)info.toMove2.endLine) : editor.getDocument().getLineStartOffset(info.toMove2.startLine);
        PsiElement elementAtInsertOffset = file.getViewProvider().findElementAt(insertOffset, DartLanguage.INSTANCE);
        PsiElement newGuard = isExpr ? PsiTreeUtil.getParentOfType((PsiElement)elementAtInsertOffset, (Class[])new Class[]{DartMethodDeclaration.class, DartListLiteralExpression.class, DartArgumentList.class, DartArguments.class, DartFunctionDeclarationWithBodyOrNative.class, DartClass.class, PsiComment.class}) : PsiTreeUtil.getParentOfType((PsiElement)elementAtInsertOffset, (Class[])new Class[]{DartMethodDeclaration.class, DartFunctionDeclarationWithBodyOrNative.class, DartClass.class, PsiComment.class});
        if (brace != null && PsiTreeUtil.getParentOfType((PsiElement)brace, IDartBlock.class, (boolean)false) != PsiTreeUtil.getParentOfType((PsiElement)elementAtInsertOffset, IDartBlock.class, (boolean)false)) {
            info.indentSource = true;
        }
        if (newGuard == guard && DartStatementMover.isInside(insertOffset, newGuard) == DartStatementMover.isInside(offset, guard)) {
            return true;
        }
        if (newGuard == null || guard == null) {
            return false;
        }
        if (NESTED_GUARDS.contains(newGuard.getNode().getElementType()) && NESTED_GUARDS.contains(guard.getNode().getElementType()) && ((parent = PsiTreeUtil.findCommonParent((PsiElement)guard, (PsiElement)newGuard)) == guard || parent == newGuard)) {
            return DartStatementMover.isInside(insertOffset, newGuard) == DartStatementMover.isInside(offset, guard);
        }
        return false;
    }

    private static PsiElement soloRightBraceBeingMoved(PsiFile file, Editor editor) {
        LineRange range = DartStatementMover.getLineRangeFromSelection((Editor)editor);
        if (range.endLine - range.startLine != 1) {
            return null;
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        String lineText = document.getText().substring(lineStartOffset, document.getLineEndOffset(line));
        if (!lineText.trim().equals("}")) {
            return null;
        }
        return file.findElementAt(lineStartOffset + lineText.indexOf(125));
    }

    private boolean calcInsertOffset(@NotNull PsiFile file, @NotNull Editor editor, @NotNull LineRange range, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        TextRange elementTextRange;
        int offset;
        int startLine;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "calcInsertOffset"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "calcInsertOffset"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "calcInsertOffset"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "calcInsertOffset"));
        }
        int destLine = DartStatementMover.getDestLineForAnon(editor, range, down);
        int n = startLine = down ? range.endLine : range.startLine - 1;
        if (destLine < 0 || startLine < 0) {
            return false;
        }
        boolean firstTime = true;
        boolean isExpr = DartStatementMover.isMovingExpr(info.toMove);
        PsiElement elementStart = null;
        if (isExpr) {
            offset = editor.logicalPositionToOffset(new LogicalPosition(startLine, 0));
            elementStart = DartStatementMover.firstNonWhiteMovableElement(offset, file, true);
            if (elementStart instanceof DartArgumentList) {
                elementStart = elementStart.getFirstChild();
            } else if (DartRefactoringUtil.isRightBracket(elementStart) && info.toMove.firstElement instanceof DartNamedArgument) {
                elementStart = elementStart.getParent().getParent();
            }
            if (elementStart instanceof DartExpression || elementStart instanceof DartNamedArgument) {
                TextRange elementTextRange2 = elementStart.getTextRange();
                LogicalPosition pos = editor.offsetToLogicalPosition(elementTextRange2.getEndOffset());
                int endOffset = editor.logicalPositionToOffset(new LogicalPosition(pos.line + 1, 0));
                PsiElement elementEnd = DartStatementMover.firstNonWhiteMovableElement(endOffset, file, false);
                if (elementEnd instanceof DartArgumentList && elementStart instanceof DartNamedArgument) {
                    if (!DartRefactoringUtil.isComma(elementEnd = elementEnd.getLastChild())) {
                        return false;
                    }
                    info.toMove2 = new LineRange(startLine, pos.line + 1);
                    return true;
                }
                if (elementEnd != null && DartRefactoringUtil.isComma(elementEnd)) {
                    PsiElement elementTail = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(elementEnd, true);
                    if (elementTail instanceof DartExpressionList) {
                        elementTail = elementTail.getLastChild();
                    }
                    if (elementStart == elementTail) {
                        if (down) {
                            info.toMove2 = new LineRange(startLine, pos.line + 1);
                        } else {
                            destLine = pos.line;
                            elementTextRange2 = elementTail.getTextRange();
                            pos = editor.offsetToLogicalPosition(elementTextRange2.getStartOffset());
                            info.toMove2 = new LineRange(pos.line, destLine + 1);
                        }
                        return true;
                    }
                }
            } else if (elementStart != null && DartRefactoringUtil.isRightParen(elementStart)) {
                PsiElement start = elementStart.getParent().getParent();
                elementTextRange = start.getTextRange();
                LogicalPosition pos = editor.offsetToLogicalPosition(elementTextRange.getStartOffset());
                int startOffset = editor.logicalPositionToOffset(new LogicalPosition(pos.line, 0));
                PsiElement startElement = DartStatementMover.firstNonWhiteMovableElement(startOffset, file, true);
                if (startElement == start) {
                    info.toMove2 = new LineRange(pos.line, down ? startLine : startLine + 1);
                    return true;
                }
            }
        }
        do {
            PsiElement elementParent;
            offset = editor.logicalPositionToOffset(new LogicalPosition(destLine, 0));
            PsiElement element = DartStatementMover.firstNonWhiteMovableElement(offset, file, !isExpr || !down);
            if (firstTime && element != null && element.getNode().getElementType() == (down ? DartTokenTypes.RBRACE : DartTokenTypes.LBRACE) && (elementParent = element.getParent()) != null && (DartStatementMover.isStatement(elementParent) || elementParent instanceof DartBlock)) {
                return true;
            }
            if (element instanceof DartStatements) {
                element = element.getFirstChild();
            }
            while (element != null && !(element instanceof PsiFile)) {
                elementTextRange = element.getTextRange();
                if (elementTextRange.isEmpty() || !elementTextRange.grown(-1).shiftRight(1).contains(offset)) {
                    PsiElement elementToSurround = null;
                    boolean found = false;
                    if (isExpr) {
                        if (firstTime && element instanceof DartExpression) {
                            found = true;
                        } else if (DartRefactoringUtil.isComma(element) && UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(element, true) == elementStart) {
                            found = true;
                        } else if (element instanceof DartArgumentList && (element = element.getParent()).getParent() == elementStart) {
                            boolean hasComma = false;
                            for (element = element.getParent().getNextSibling(); element != null; element = element.getNextSibling()) {
                                if (UsefulPsiTreeUtil.isWhitespaceOrComment(element)) {
                                    if (!element.getText().contains("\n")) continue;
                                    ++destLine;
                                    break;
                                }
                                if (!DartRefactoringUtil.isComma(element)) break;
                                hasComma = true;
                            }
                            if (!hasComma) {
                                return false;
                            }
                            found = true;
                        }
                    } else if ((DartStatementMover.isStatement(element) || element instanceof PsiComment) && DartStatementMover.statementCanBePlacedAlong(element)) {
                        found = true;
                        if (!(element.getParent() instanceof IDartBlock)) {
                            elementToSurround = element;
                        }
                    } else if (element.getNode().getElementType() == DartTokenTypes.RBRACE && element.getParent() instanceof IDartBlock && (!DartStatementMover.isStatement(element.getParent().getParent()) || DartStatementMover.statementCanBePlacedAlong(element.getParent().getParent())) || !down && element instanceof DartStatements) {
                        found = true;
                    }
                    if (found) {
                        if (elementToSurround != null) {
                            SmartPointerManager manager = SmartPointerManager.getInstance((Project)elementToSurround.getProject());
                            this.statementToSurroundWithCodeBlock = manager.createSmartPsiElementPointer(elementToSurround);
                        }
                        info.toMove = range;
                        int endLine = destLine;
                        if (startLine > endLine) {
                            int tmp = endLine;
                            endLine = startLine;
                            startLine = tmp;
                        }
                        info.toMove2 = new LineRange(startLine, down ? endLine : endLine + 1);
                        return true;
                    }
                }
                element = element.getParent();
            }
            firstTime = false;
        } while ((destLine += down ? 1 : -1) > 0 && destLine < editor.getDocument().getLineCount());
        return false;
    }

    private static int getDestLineForAnon(Editor editor, LineRange range, boolean down) {
        int destLine;
        int n = destLine = down ? range.endLine + 1 : range.startLine - 1;
        if (!DartStatementMover.isStatement(range.firstElement)) {
            return destLine;
        }
        PsiElement sibling = StatementUpDownMover.firstNonWhiteElement((PsiElement)(down ? range.lastElement.getNextSibling() : range.firstElement.getPrevSibling()), (boolean)down);
        DartFunctionExpression fn = DartStatementMover.findChildOfType(sibling, DartFunctionExpression.class, DartPsiCompositeElement.class);
        if (fn != null && sibling != null && PsiTreeUtil.getParentOfType((PsiElement)fn, DartPsiCompositeElement.class) == sibling) {
            destLine = editor.getDocument().getLineNumber(down ? sibling.getTextRange().getEndOffset() + 1 : sibling.getTextRange().getStartOffset());
        }
        return destLine;
    }

    @Nullable
    private static <T extends PsiElement> T findChildOfType(final @Nullable PsiElement element, final @NotNull Class<T> aClass, final @Nullable Class<? extends PsiElement> stopAt) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "findChildOfType"));
        }
        PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$1", "execute"));
                }
                if (element == each) {
                    return true;
                }
                if (aClass.isInstance(each)) {
                    return this.setFound(each);
                }
                return stopAt == null || !stopAt.isInstance(each);
            }
        };
        PsiTreeUtil.processElements((PsiElement)element, (PsiElementProcessor)processor);
        return (T)processor.getFoundElement();
    }

    private static boolean isInside(int offset, PsiElement guard) {
        DartClassBody body;
        PsiElement lBrace;
        if (guard == null) {
            return false;
        }
        TextRange inside = guard.getTextRange();
        if (guard instanceof DartMethodDeclaration) {
            DartFunctionBody body2 = ((DartMethodDeclaration)guard).getFunctionBody();
            if (body2 != null) {
                inside = body2.getTextRange();
            }
        } else if (guard instanceof DartFunctionDeclarationWithBodyOrNative) {
            DartFunctionBody body3 = ((DartFunctionDeclarationWithBodyOrNative)guard).getFunctionBody();
            if (body3 != null) {
                inside = body3.getTextRange();
            }
        } else if (guard instanceof DartClassDefinition && (lBrace = PsiTreeUtil.getChildOfType((PsiElement)(body = ((DartClassDefinition)guard).getClassBody()), LeafPsiElement.class)) != null && lBrace.getText().equals("{")) {
            PsiElement rBrace = PsiTreeUtil.lastChild((PsiElement)body);
            if ((rBrace = PsiTreeUtil.skipSiblingsBackward((PsiElement)rBrace, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) != null && rBrace.getText().equals("}")) {
                inside = new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset());
            }
        }
        return inside != null && inside.contains(offset);
    }

    private static boolean statementCanBePlacedAlong(PsiElement element) {
        PsiElement body;
        if (element instanceof IDartBlock) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof DartStatements) {
            if ((parent = parent.getParent()) instanceof IDartBlock) {
                if (!DartStatementMover.isStatement(parent.getParent())) {
                    return true;
                }
                parent = parent.getParent();
            } else {
                return false;
            }
        }
        if (parent instanceof DartIfStatement) {
            PsiElement thenBranch = DartPsiImplUtil.getThenBranch((DartIfStatement)parent);
            PsiElement elseBranch = DartPsiImplUtil.getElseBranch((DartIfStatement)parent);
            if (DartStatementMover.isSameStatement(element, thenBranch) || DartStatementMover.isSameStatement(element, elseBranch)) {
                return true;
            }
        }
        if (parent instanceof DartWhileStatement && DartStatementMover.isSameStatement(element, body = DartPsiImplUtil.getWhileBody((DartWhileStatement)parent))) {
            return true;
        }
        if (parent instanceof DartDoWhileStatement && DartStatementMover.isSameStatement(element, body = DartPsiImplUtil.getDoBody((DartDoWhileStatement)parent))) {
            return true;
        }
        return parent instanceof DartForStatement && DartStatementMover.isSameStatement(element, body = DartPsiImplUtil.getForBody((DartForStatement)parent));
    }

    private static boolean isSameStatement(PsiElement element, PsiElement statementOrBlock) {
        if (element == statementOrBlock) {
            return true;
        }
        if (PsiTreeUtil.findCommonParent((PsiElement)statementOrBlock, (PsiElement)element) == statementOrBlock) {
            return true;
        }
        return DartStatementMover.expressionStatementTeminator(statementOrBlock) == element;
    }

    private static boolean isStatement(PsiElement element) {
        final boolean[] result = new boolean[]{false};
        element.accept((PsiElementVisitor)new DartVisitor(){

            @Override
            public void visitAssertStatement(@NotNull DartAssertStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitAssertStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitBreakStatement(@NotNull DartBreakStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitBreakStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitContinueStatement(@NotNull DartContinueStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitContinueStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitDoWhileStatement(@NotNull DartDoWhileStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitDoWhileStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitForStatement(@NotNull DartForStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitForStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitIfStatement(@NotNull DartIfStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitIfStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitRethrowStatement(@NotNull DartRethrowStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitRethrowStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitReturnStatement(@NotNull DartReturnStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitReturnStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitSwitchStatement(@NotNull DartSwitchStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitSwitchStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitTryStatement(@NotNull DartTryStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitTryStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitWhileStatement(@NotNull DartWhileStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitWhileStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitYieldEachStatement(@NotNull DartYieldEachStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitYieldEachStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitYieldStatement(@NotNull DartYieldStatement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitYieldStatement"));
                }
                result[0] = true;
            }

            @Override
            public void visitVarDeclarationList(@NotNull DartVarDeclarationList o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitVarDeclarationList"));
                }
                result[0] = DartStatementMover.expressionStatementTeminator((PsiElement)o) != null;
            }

            @Override
            public void visitExpression(@NotNull DartExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover$2", "visitExpression"));
                }
                result[0] = DartStatementMover.expressionStatementTeminator((PsiElement)o) != null;
            }
        });
        return result[0];
    }

    @Nullable
    private static PsiElement expressionStatementTeminator(PsiElement element) {
        PsiElement token;
        if ((element instanceof DartExpression || element instanceof DartVarDeclarationList) && (token = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class})) != null && token.getNode().getElementType() == DartTokenTypes.SEMICOLON) {
            return token;
        }
        return null;
    }

    @Nullable
    private static PsiElement firstNonWhiteMovableElement(int offset, PsiFile file, boolean lookRight) {
        PsiElement element = DartStatementMover.firstNonWhiteElement((int)offset, (PsiFile)file, (boolean)lookRight);
        if (element == null) {
            return null;
        }
        if (element instanceof DartExpressionList && lookRight) {
            element = element.getFirstChild();
        }
        return element;
    }

    private static boolean isMovingExpr(@NotNull LineRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/lang/dart/ide/moveCode/DartStatementMover", "isMovingExpr"));
        }
        return DartRefactoringUtil.isComma(range.lastElement) && (range.firstElement instanceof DartExpression || range.firstElement instanceof DartNamedArgument);
    }
}

