/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.CommonBundle;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import com.jetbrains.lang.dart.ide.refactoring.InlineMethodDialog;
import com.jetbrains.lang.dart.ide.refactoring.InlineRefactoringContext;
import com.jetbrains.lang.dart.ide.refactoring.ServerInlineLocalRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.ServerInlineMethodRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartInlineHandler
extends InlineActionHandler {
    public boolean canInlineElement(PsiElement element) {
        return false;
    }

    public boolean canInlineElementInEditor(PsiElement element, Editor editor) {
        InlineRefactoringContext context = DartInlineHandler.findContext(editor);
        if (context == null) {
            return false;
        }
        String kind = context.kind;
        return "LOCAL_VARIABLE".equals(kind) || "METHOD".equals(kind) || "FUNCTION".equals(kind) || "GETTER".equals(kind) || "SETTER".equals(kind);
    }

    public void inlineElement(@NotNull Project project, @Nullable Editor editor, PsiElement element) {
        boolean dialogOK;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/DartInlineHandler", "inlineElement"));
        }
        InlineRefactoringContext context = DartInlineHandler.findContext(editor);
        if (context == null) {
            return;
        }
        ServerRefactoring refactoring = "LOCAL_VARIABLE".equals(context.kind) ? new ServerInlineLocalRefactoring(project, context.virtualFile, context.offset, 0) : new ServerInlineMethodRefactoring(project, context.virtualFile, context.offset, 0);
        RefactoringStatus initialConditions = refactoring.checkInitialConditions();
        if (DartInlineHandler.showMessageIfError(editor, initialConditions)) {
            return;
        }
        if (refactoring instanceof ServerInlineMethodRefactoring && !(dialogOK = new InlineMethodDialog(project, element, (ServerInlineMethodRefactoring)refactoring).showAndGet())) {
            return;
        }
        RefactoringStatus finalConditions = refactoring.checkFinalConditions();
        if (DartInlineHandler.showMessageIfError(editor, finalConditions)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/DartInlineHandler", "lambda$inlineElement$0"));
            }
            SourceChange change = refactoring.getChange();
            assert (change != null);
            try {
                AssistUtils.applySourceChange(project, change, false);
            }
            catch (DartSourceEditException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
            }
        });
    }

    public boolean isEnabledForLanguage(Language l) {
        return l == DartLanguage.INSTANCE;
    }

    public boolean isEnabledOnElement(PsiElement element, @Nullable Editor editor) {
        return this.canInlineElementInEditor(element, editor);
    }

    @Nullable
    private static InlineRefactoringContext findContext(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        int offset = editor.getCaretModel().getOffset();
        List<DartServerData.DartNavigationRegion> navigationRegions = DartAnalysisServerService.getInstance(project).getNavigation(virtualFile);
        for (DartServerData.DartNavigationRegion region : navigationRegions) {
            if (region.getOffset() > offset || offset > region.getOffset() + region.getLength()) continue;
            List<DartServerData.DartNavigationTarget> targets = region.getTargets();
            String kind = targets.get(0).getKind();
            return new InlineRefactoringContext(virtualFile, offset, kind);
        }
        return null;
    }

    private static boolean showMessageIfError(@Nullable Editor editor, @Nullable RefactoringStatus status) {
        if (status == null) {
            return true;
        }
        if (status.hasError()) {
            String message = status.getMessage();
            assert (message != null);
            if (editor != null) {
                CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)message, (String)CommonBundle.getErrorTitle(), null);
            }
            return true;
        }
        return false;
    }
}

