/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.ide.findUsages.DartServerFindUsagesHandler;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoringDialog;
import com.jetbrains.lang.dart.ide.refactoring.ServerRenameRefactoring;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DartRenameDialog
extends ServerRefactoringDialog<ServerRenameRefactoring> {
    private final JLabel myNewNamePrefix;
    private NameSuggestionsField myNameSuggestionsField;

    DartRenameDialog(@NotNull Project project, @Nullable Editor editor, @NotNull ServerRenameRefactoring refactoring) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "<init>"));
        }
        if (refactoring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactoring", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "<init>"));
        }
        super(project, editor, refactoring);
        this.myNewNamePrefix = new JLabel("");
        this.setTitle("Rename " + refactoring.getElementKindName());
        this.createNewNameComponent();
        this.init();
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (Comparing.strEqual((String)this.getNewName(), (String)((ServerRenameRefactoring)this.myRefactoring).getOldName())) {
            throw new ConfigurationException(null);
        }
        super.canRun();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        JLabel nameLabel = new JLabel();
        panel.add((Component)nameLabel, gbConstraints);
        nameLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)XmlTagUtilBase.escapeString((String)this.getLabelText(), (boolean)false)));
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myNewNamePrefix, gbConstraints);
        gbConstraints.insets = JBUI.insetsBottom((int)8);
        gbConstraints.gridwidth = 2;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 1.0;
        panel.add((Component)this.myNameSuggestionsField.getComponent(), gbConstraints);
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    private void createNewNameComponent() {
        String[] suggestedNames = this.getSuggestedNames();
        this.myNameSuggestionsField = new NameSuggestionsField(suggestedNames, this.myProject, (FileType)FileTypes.PLAIN_TEXT, this.myEditor){

            protected boolean shouldSelectAll() {
                return DartRenameDialog.this.myEditor == null || DartRenameDialog.this.myEditor.getSettings().isPreselectRename();
            }
        };
        this.myNameSuggestionsField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                DartRenameDialog.this.processNewNameChanged();
            }
        });
    }

    @NotNull
    private String getLabelText() {
        String kindName = ((ServerRenameRefactoring)this.myRefactoring).getElementKindName().toLowerCase(Locale.US);
        String name = ((ServerRenameRefactoring)this.myRefactoring).getOldName().isEmpty() ? kindName : kindName + " " + ((ServerRenameRefactoring)this.myRefactoring).getOldName();
        String string = RefactoringBundle.message((String)"rename.0.and.its.usages.to", (Object[])new Object[]{name});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "getLabelText"));
        }
        return string;
    }

    private String getNewName() {
        return this.myNameSuggestionsField.getEnteredName().trim();
    }

    @NotNull
    private String[] getSuggestedNames() {
        String[] stringArray = new String[]{((ServerRenameRefactoring)this.myRefactoring).getOldName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "getSuggestedNames"));
        }
        return stringArray;
    }

    private void processNewNameChanged() {
        ((ServerRenameRefactoring)this.myRefactoring).setNewName(this.getNewName());
    }

    @Override
    protected boolean hasPreviewButton() {
        return true;
    }

    @Override
    protected boolean isForcePreview() {
        Set<String> potentialEdits = ((ServerRenameRefactoring)this.myRefactoring).getPotentialEdits();
        return !potentialEdits.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode();
    }

    @Override
    protected void previewRefactoring() {
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText(RefactoringBundle.message((String)"usageView.tabText"));
        presentation.setShowCancelButton(true);
        presentation.setTargetsNodeText(RefactoringBundle.message((String)"0.to.be.renamed.to.1.2", (Object[])new Object[]{((ServerRenameRefactoring)this.myRefactoring).getElementKindName(), "", this.getNewName()}));
        presentation.setNonCodeUsagesString(DartBundle.message("usages.in.comments.to.rename", new Object[0]));
        presentation.setCodeUsagesString(DartBundle.message("usages.in.code.to.rename", new Object[0]));
        presentation.setDynamicUsagesString(DartBundle.message("dynamic.usages.to.rename", new Object[0]));
        presentation.setUsageTypeFilteringAvailable(false);
        SmartList usageTargets = new SmartList();
        THashMap usageToEditIdMap = new THashMap();
        this.fillTargetsAndUsageToEditIdMap((List<UsageTarget>)usageTargets, (Map<Usage, String>)usageToEditIdMap);
        UsageTarget[] targets = usageTargets.toArray(new UsageTarget[usageTargets.size()]);
        Set usageSet = usageToEditIdMap.keySet();
        Usage[] usages = usageSet.toArray(new Usage[usageSet.size()]);
        UsageView usageView = UsageViewManager.getInstance((Project)this.myProject).showUsages(targets, usages, presentation);
        SourceChange sourceChange = ((ServerRenameRefactoring)this.myRefactoring).getChange();
        assert (sourceChange != null);
        usageView.addPerformOperationAction(this.createRefactoringRunnable(usageView, (Map<Usage, String>)usageToEditIdMap), sourceChange.getMessage(), DartBundle.message("rename.need.reRun", new Object[0]), RefactoringBundle.message((String)"usageView.doAction"), false);
    }

    private void fillTargetsAndUsageToEditIdMap(@NotNull List<UsageTarget> usageTargets, @NotNull Map<Usage, String> usageToEditIdMap) {
        if (usageTargets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageTargets", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "fillTargetsAndUsageToEditIdMap"));
        }
        if (usageToEditIdMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageToEditIdMap", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "fillTargetsAndUsageToEditIdMap"));
        }
        SourceChange change = ((ServerRenameRefactoring)this.myRefactoring).getChange();
        assert (change != null);
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(this.myProject);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (SourceFileEdit fileEdit : change.getEdits()) {
            PsiFile psiFile;
            VirtualFile file = AssistUtils.findVirtualFile(fileEdit);
            PsiFile psiFile2 = psiFile = file == null ? null : psiManager.findFile(file);
            if (psiFile == null) continue;
            for (SourceEdit sourceEdit : fileEdit.getEdits()) {
                int offset = service.getConvertedOffset(file, sourceEdit.getOffset());
                int length = service.getConvertedOffset(file, sourceEdit.getOffset() + sourceEdit.getLength()) - offset;
                TextRange range = TextRange.create((int)offset, (int)(offset + length));
                boolean potentialUsage = ((ServerRenameRefactoring)this.myRefactoring).getPotentialEdits().contains(sourceEdit.getId());
                PsiElement usageElement = DartServerFindUsagesHandler.getUsagePsiElement(psiFile, range);
                if (usageElement == null) continue;
                if (DartComponentType.typeOf(usageElement) != null) {
                    usageTargets.add((UsageTarget)new PsiElement2UsageTargetAdapter(usageElement));
                    continue;
                }
                UsageInfo usageInfo = DartServerFindUsagesHandler.getUsageInfo(usageElement, range, potentialUsage);
                if (usageInfo == null) continue;
                usageToEditIdMap.put((Usage)new UsageInfo2UsageAdapter(usageInfo), sourceEdit.getId());
            }
        }
    }

    @NotNull
    private Runnable createRefactoringRunnable(@NotNull UsageView usageView, @NotNull Map<Usage, String> usageToEditIdMap) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "createRefactoringRunnable"));
        }
        if (usageToEditIdMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageToEditIdMap", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "createRefactoringRunnable"));
        }
        Runnable runnable = () -> {
            if (usageToEditIdMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageToEditIdMap", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "lambda$createRefactoringRunnable$0"));
            }
            if (usageView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "lambda$createRefactoringRunnable$0"));
            }
            THashSet excludedIds = new THashSet();
            THashSet excludedUsages = new THashSet(usageToEditIdMap.keySet());
            excludedUsages.removeAll(usageView.getUsages());
            excludedUsages.addAll(usageView.getExcludedUsages());
            for (Usage excludedUsage : excludedUsages) {
                excludedIds.add(usageToEditIdMap.get(excludedUsage));
            }
            super.doRefactoring((Set<String>)excludedIds);
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/DartRenameDialog", "createRefactoringRunnable"));
        }
        return runnable;
    }
}

