/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.CommonBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.refactoring.DartRenameDialog;
import com.jetbrains.lang.dart.ide.refactoring.ServerRenameRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import org.jetbrains.annotations.NotNull;

public class DartServerRenameHandler
implements RenameHandler,
TitledHandler {
    public String getActionTitle() {
        return "Dart Rename Refactoring";
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/DartServerRenameHandler", "invoke"));
        }
        DartServerRenameHandler.showRenameDialog(project, editor, context);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/DartServerRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/refactoring/DartServerRenameHandler", "invoke"));
        }
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/lang/dart/ide/refactoring/DartServerRenameHandler", "isAvailableOnDataContext"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return false;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (!DartAnalysisServerService.isLocalAnalyzableFile(file)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement != null) {
            return psiElement.getLanguage() == DartLanguage.INSTANCE && !(psiElement instanceof PsiFile);
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement elementAtOffset = psiFile == null ? null : psiFile.findElementAt(editor.getCaretModel().getOffset());
        return elementAtOffset != null && elementAtOffset.getLanguage() == DartLanguage.INSTANCE;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    private static void showRenameDialog(@NotNull Project project, @NotNull Editor editor, DataContext context) {
        int offset;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/DartServerRenameHandler", "showRenameDialog"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/refactoring/DartServerRenameHandler", "showRenameDialog"));
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (psiFile == null || virtualFile == null) {
            return;
        }
        Caret caret = (Caret)CommonDataKeys.CARET.getData(context);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (caret != null) {
            offset = caret.getOffset();
        } else if (element != null) {
            offset = element.getTextOffset();
        } else {
            return;
        }
        ServerRenameRefactoring refactoring = new ServerRenameRefactoring(project, virtualFile, offset, 0);
        RefactoringStatus initialStatus = refactoring.checkInitialConditions();
        if (initialStatus == null) {
            return;
        }
        if (initialStatus.hasError()) {
            String message = initialStatus.getMessage();
            assert (message != null);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)CommonBundle.getErrorTitle(), null);
            return;
        }
        new DartRenameDialog(project, editor, refactoring).show();
    }
}

