/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.jetbrains.lang.dart.ide.refactoring.ServerInlineMethodRefactoring;

class InlineMethodDialog
extends InlineOptionsDialog {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.method.title");
    private final ServerInlineMethodRefactoring refactoring;

    protected InlineMethodDialog(Project project, PsiElement element, ServerInlineMethodRefactoring refactoring) {
        super(project, true, element);
        this.refactoring = refactoring;
        this.setTitle(REFACTORING_NAME);
        this.myInvokedOnReference = !refactoring.isDeclaration();
        this.init();
    }

    protected void doAction() {
        if (!this.isInlineThisOnly()) {
            this.refactoring.setInlineAll(true);
            this.refactoring.setDeleteSource(true);
        }
        this.close(0);
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    protected String getInlineAllText() {
        return "Inline all references and remove the method";
    }

    protected String getInlineThisText() {
        return "Inline this reference and leave the method";
    }

    protected String getNameLabelText() {
        return "Method " + this.refactoring.getFullName();
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected boolean isInlineThis() {
        return !this.refactoring.isDeclaration();
    }
}

