/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoring;
import org.dartlang.analysis.server.protocol.ExtractLocalVariableFeedback;
import org.dartlang.analysis.server.protocol.ExtractLocalVariableOptions;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.jetbrains.annotations.NotNull;

public class ServerExtractLocalVariableRefactoring
extends ServerRefactoring {
    private final ExtractLocalVariableOptions options;
    private ExtractLocalVariableFeedback feedback;

    public ServerExtractLocalVariableRefactoring(@NotNull Project project, @NotNull VirtualFile file, int offset, int length) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "<init>"));
        }
        super(project, "Extract Local Variable", "EXTRACT_LOCAL_VARIABLE", file, offset, length);
        this.options = new ExtractLocalVariableOptions("name", true);
    }

    @NotNull
    public int[] getCoveringExpressionOffsets() {
        int[] nArray = DartAnalysisServerService.getInstance(this.getProject()).getConvertedOffsets(this.getFile(), this.feedback.getCoveringExpressionOffsets());
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "getCoveringExpressionOffsets"));
        }
        return nArray;
    }

    @NotNull
    public int[] getCoveringExpressionLengths() {
        int[] nArray = DartAnalysisServerService.getInstance(this.getProject()).getConvertedLengths(this.getFile(), this.feedback.getCoveringExpressionOffsets(), this.feedback.getCoveringExpressionLengths());
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "getCoveringExpressionLengths"));
        }
        return nArray;
    }

    @NotNull
    public String[] getNames() {
        String[] stringArray = ArrayUtil.toStringArray(this.feedback.getNames());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public int[] getOccurrencesOffsets() {
        int[] nArray = DartAnalysisServerService.getInstance(this.getProject()).getConvertedOffsets(this.getFile(), this.feedback.getOffsets());
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "getOccurrencesOffsets"));
        }
        return nArray;
    }

    @NotNull
    public int[] getOccurrencesLengths() {
        int[] nArray = DartAnalysisServerService.getInstance(this.getProject()).getConvertedLengths(this.getFile(), this.feedback.getOffsets(), this.feedback.getLengths());
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "getOccurrencesLengths"));
        }
        return nArray;
    }

    @Override
    protected RefactoringOptions getOptions() {
        return this.options;
    }

    public void setExtractAll(boolean extractAll) {
        this.options.setExtractAll(extractAll);
    }

    @Override
    protected void setFeedback(@NotNull RefactoringFeedback _feedback) {
        if (_feedback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_feedback", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "setFeedback"));
        }
        this.feedback = (ExtractLocalVariableFeedback)_feedback;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractLocalVariableRefactoring", "setName"));
        }
        this.options.setName(name);
        this.setOptions(true, null);
    }
}

