/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoring;
import java.util.List;
import org.dartlang.analysis.server.protocol.ExtractMethodFeedback;
import org.dartlang.analysis.server.protocol.ExtractMethodOptions;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;
import org.dartlang.analysis.server.protocol.RefactoringMethodParameter;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.jetbrains.annotations.NotNull;

public class ServerExtractMethodRefactoring
extends ServerRefactoring {
    private final ExtractMethodOptions options;
    private ExtractMethodFeedback feedback;

    public ServerExtractMethodRefactoring(@NotNull Project project, @NotNull VirtualFile file, int offset, int length) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractMethodRefactoring", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractMethodRefactoring", "<init>"));
        }
        super(project, "Extract Method", "EXTRACT_METHOD", file, offset, length);
        this.options = new ExtractMethodOptions("returnType", false, "name", (List<RefactoringMethodParameter>)ImmutableList.of(), false);
    }

    public boolean canExtractGetter() {
        return this.feedback.canCreateGetter();
    }

    @NotNull
    public String[] getNames() {
        String[] stringArray = ArrayUtil.toStringArray(this.feedback.getNames());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractMethodRefactoring", "getNames"));
        }
        return stringArray;
    }

    public int getOccurrences() {
        return this.feedback.getOffsets().length;
    }

    @Override
    protected RefactoringOptions getOptions() {
        return this.options;
    }

    @NotNull
    public List<RefactoringMethodParameter> getParameters() {
        List<RefactoringMethodParameter> list = this.options.getParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractMethodRefactoring", "getParameters"));
        }
        return list;
    }

    @NotNull
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.options.getReturnType());
        sb.append(" ");
        boolean createGetter = this.options.createGetter();
        if (createGetter) {
            sb.append("get ");
        }
        sb.append(this.options.getName());
        if (!createGetter) {
            sb.append("(");
            boolean firstParameter = true;
            for (RefactoringMethodParameter parameter : this.options.getParameters()) {
                if (!firstParameter) {
                    sb.append(", ");
                }
                firstParameter = false;
                sb.append(parameter.getType());
                sb.append(" ");
                sb.append(parameter.getName());
            }
            sb.append(")");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractMethodRefactoring", "getSignature"));
        }
        return string;
    }

    public void setCreateGetter(boolean value) {
        this.options.setCreateGetter(value);
    }

    public void setExtractAll(boolean extractAll) {
        this.options.setExtractAll(extractAll);
    }

    @Override
    protected void setFeedback(@NotNull RefactoringFeedback _feedback) {
        if (_feedback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_feedback", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractMethodRefactoring", "setFeedback"));
        }
        boolean firstFeedback = this.feedback == null;
        this.feedback = (ExtractMethodFeedback)_feedback;
        if (firstFeedback) {
            this.options.setExtractAll(true);
            this.options.setReturnType(this.feedback.getReturnType());
            this.options.setCreateGetter(this.feedback.canCreateGetter());
            this.options.setParameters(this.feedback.getParameters());
        }
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/refactoring/ServerExtractMethodRefactoring", "setName"));
        }
        this.options.setName(name);
        this.setOptions(true, null);
    }
}

