/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoring;
import org.dartlang.analysis.server.protocol.InlineMethodFeedback;
import org.dartlang.analysis.server.protocol.InlineMethodOptions;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.jetbrains.annotations.NotNull;

public class ServerInlineMethodRefactoring
extends ServerRefactoring {
    private final InlineMethodOptions options;
    private String fullName;
    private boolean isDeclaration;

    public ServerInlineMethodRefactoring(@NotNull Project project, @NotNull VirtualFile file, int offset, int length) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/ServerInlineMethodRefactoring", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/refactoring/ServerInlineMethodRefactoring", "<init>"));
        }
        super(project, "Inline Method", "INLINE_METHOD", file, offset, length);
        this.options = new InlineMethodOptions(false, false);
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isDeclaration() {
        return this.isDeclaration;
    }

    public void setDeleteSource(boolean value) {
        this.options.setDeleteSource(value);
        this.setOptions(true, null);
    }

    public void setInlineAll(boolean value) {
        this.options.setInlineAll(value);
        this.setOptions(true, null);
    }

    @Override
    protected RefactoringOptions getOptions() {
        return this.options;
    }

    @Override
    protected void setFeedback(@NotNull RefactoringFeedback _feedback) {
        if (_feedback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_feedback", "com/jetbrains/lang/dart/ide/refactoring/ServerInlineMethodRefactoring", "setFeedback"));
        }
        InlineMethodFeedback feedback = (InlineMethodFeedback)_feedback;
        String className = feedback.getClassName();
        String methodName = feedback.getMethodName();
        this.fullName = className != null ? className + "." + methodName : methodName;
        this.isDeclaration = feedback.isDeclaration();
    }
}

