/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoring;
import org.apache.commons.lang3.text.WordUtils;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.dartlang.analysis.server.protocol.RenameFeedback;
import org.dartlang.analysis.server.protocol.RenameOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerRenameRefactoring
extends ServerRefactoring {
    private RenameOptions options;
    private String elementKindName;
    private String oldName;

    public ServerRenameRefactoring(@NotNull Project project, @NotNull VirtualFile file, int offset, int length) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/ServerRenameRefactoring", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/refactoring/ServerRenameRefactoring", "<init>"));
        }
        super(project, "Rename", "RENAME", file, offset, length);
    }

    @NotNull
    public String getElementKindName() {
        String string = this.elementKindName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerRenameRefactoring", "getElementKindName"));
        }
        return string;
    }

    @NotNull
    public String getOldName() {
        String string = this.oldName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/ServerRenameRefactoring", "getOldName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected RefactoringOptions getOptions() {
        return this.options;
    }

    @Override
    protected void setFeedback(@NotNull RefactoringFeedback _feedback) {
        if (_feedback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_feedback", "com/jetbrains/lang/dart/ide/refactoring/ServerRenameRefactoring", "setFeedback"));
        }
        RenameFeedback feedback = (RenameFeedback)_feedback;
        this.elementKindName = WordUtils.capitalize((String)feedback.getElementKindName());
        this.oldName = feedback.getOldName();
        if (this.options == null) {
            this.options = new RenameOptions(this.oldName);
        }
    }

    public void setNewName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/jetbrains/lang/dart/ide/refactoring/ServerRenameRefactoring", "setNewName"));
        }
        this.options.setNewName(newName);
        this.setOptions(true, null);
    }
}

