/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.extract;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.lang.dart.ide.refactoring.ServerExtractMethodRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoringDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DartServerExtractMethodDialog
extends ServerRefactoringDialog {
    @NotNull
    final ServerExtractMethodRefactoring myRefactoring;
    private JTextField myMethodNameField;
    private JCheckBox myAllCheckBox;
    private JCheckBox myGetterCheckBox;
    private JLabel mySignatureLabel;

    public DartServerExtractMethodDialog(@NotNull Project project, @Nullable Editor editor, @NotNull ServerExtractMethodRefactoring refactoring) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/extract/DartServerExtractMethodDialog", "<init>"));
        }
        if (refactoring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactoring", "com/jetbrains/lang/dart/ide/refactoring/extract/DartServerExtractMethodDialog", "<init>"));
        }
        super(project, editor, refactoring);
        this.myMethodNameField = new JTextField();
        this.myAllCheckBox = new JCheckBox("Extract all occurrences");
        this.myGetterCheckBox = new JCheckBox("Extract getter");
        this.mySignatureLabel = new JLabel();
        this.myRefactoring = refactoring;
        this.setTitle("Extract Method");
        this.init();
        String name = StringUtil.notNullize((String)((String)ArrayUtil.getFirstElement((Object[])refactoring.getNames())), (String)"name");
        this.myRefactoring.setName(name);
        this.myMethodNameField.setText(name);
        this.myMethodNameField.selectAll();
        this.myMethodNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String name = DartServerExtractMethodDialog.this.myMethodNameField.getText();
                DartServerExtractMethodDialog.this.myRefactoring.setName(name);
                DartServerExtractMethodDialog.this.mySignatureLabel.setText(DartServerExtractMethodDialog.this.myRefactoring.getSignature());
            }
        });
        if (this.myRefactoring.getOccurrences() != 1) {
            this.myAllCheckBox.setSelected(true);
            this.myAllCheckBox.setText("Extract all " + this.myRefactoring.getOccurrences() + " occurrences");
            this.myAllCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DartServerExtractMethodDialog.this.myRefactoring.setExtractAll(DartServerExtractMethodDialog.this.myAllCheckBox.isSelected());
                }
            });
        } else {
            this.myAllCheckBox.setEnabled(false);
        }
        if (this.myRefactoring.canExtractGetter()) {
            this.myGetterCheckBox.setSelected(true);
            this.myGetterCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DartServerExtractMethodDialog.this.myRefactoring.setCreateGetter(DartServerExtractMethodDialog.this.myGetterCheckBox.isSelected());
                    DartServerExtractMethodDialog.this.mySignatureLabel.setText(DartServerExtractMethodDialog.this.myRefactoring.getSignature());
                }
            });
        } else {
            this.myGetterCheckBox.setEnabled(false);
        }
        this.mySignatureLabel.setText(this.myRefactoring.getSignature());
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 17;
        JLabel nameLabel = new JLabel();
        panel.add((Component)nameLabel, gbConstraints);
        nameLabel.setText("Method name:");
        gbConstraints.insets = JBUI.insets((int)0, (int)4, (int)4, (int)0);
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myMethodNameField, gbConstraints);
        this.myMethodNameField.setPreferredSize(new Dimension(200, this.myMethodNameField.getPreferredSize().height));
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myGetterCheckBox, gbConstraints);
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myAllCheckBox, gbConstraints);
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 3;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        panel.add((Component)this.mySignatureLabel, gbConstraints);
        return panel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myMethodNameField;
    }
}

