/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.extract;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.refactoring.ServerExtractMethodRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.extract.DartServerExtractMethodDialog;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import org.jetbrains.annotations.NotNull;

public class DartServerExtractMethodHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/extract/DartServerExtractMethodHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/refactoring/extract/DartServerExtractMethodHandler", "invoke"));
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/extract/DartServerExtractMethodHandler", "invoke"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            selectionModel.selectLineAtCaret();
        }
        int offset = selectionModel.getSelectionStart();
        int length = selectionModel.getSelectionEnd() - offset;
        ServerExtractMethodRefactoring refactoring = new ServerExtractMethodRefactoring(project, file.getVirtualFile(), offset, length);
        RefactoringStatus initialStatus = refactoring.checkInitialConditions();
        if (initialStatus == null) {
            return;
        }
        if (initialStatus.hasError()) {
            String title = DartBundle.message("dart.refactoring.extract.method.error", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)initialStatus.getMessage(), (String)title, null);
            return;
        }
        new DartServerExtractMethodDialog(project, editor, refactoring).show();
    }
}

