/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.introduce;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.lang.dart.ide.refactoring.ServerExtractLocalVariableRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.ServerRefactoringDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DartServerExtractLocalVariableDialog
extends ServerRefactoringDialog {
    @NotNull
    final ServerExtractLocalVariableRefactoring myRefactoring;
    private final NameSuggestionsField myVariableNameField;

    public DartServerExtractLocalVariableDialog(@NotNull Project project, @NotNull Editor editor, @NotNull ServerExtractLocalVariableRefactoring refactoring) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartServerExtractLocalVariableDialog", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartServerExtractLocalVariableDialog", "<init>"));
        }
        if (refactoring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactoring", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartServerExtractLocalVariableDialog", "<init>"));
        }
        super(project, editor, refactoring);
        this.myRefactoring = refactoring;
        Object[] names = refactoring.getNames();
        this.myVariableNameField = new NameSuggestionsField((String[])names, project);
        this.setTitle("Extract Local Variable");
        this.init();
        String name = StringUtil.notNullize((String)((String)ArrayUtil.getFirstElement((Object[])names)), (String)"name");
        this.myRefactoring.setName(name);
        this.myVariableNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                String name = DartServerExtractLocalVariableDialog.this.myVariableNameField.getEnteredName();
                DartServerExtractLocalVariableDialog.this.myRefactoring.setName(name);
            }
        });
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 17;
        JLabel nameLabel = new JLabel();
        panel.add((Component)nameLabel, gbConstraints);
        nameLabel.setText("Name:");
        gbConstraints.insets = JBUI.insets((int)0, (int)4, (int)4, (int)0);
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myVariableNameField, gbConstraints);
        this.myVariableNameField.setPreferredSize(new Dimension(300, this.myVariableNameField.getPreferredSize().height));
        return panel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myVariableNameField;
    }
}

