/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.introduce;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.ide.refactoring.introduce.DartIntroduceVariableHandler;
import com.jetbrains.lang.dart.ide.refactoring.introduce.ExtractLocalVariableProcessor;
import com.jetbrains.lang.dart.sdk.DartSdk;
import org.jetbrains.annotations.NotNull;

public class DartServerExtractLocalVariableHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartServerExtractLocalVariableHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartServerExtractLocalVariableHandler", "invoke"));
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/introduce/DartServerExtractLocalVariableHandler", "invoke"));
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null || StringUtil.compareVersionNumbers((String)sdk.getVersion(), (String)"1.14") < 0) {
            new DartIntroduceVariableHandler().invoke(project, editor, file, dataContext);
            return;
        }
        if (editor == null || file == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        new ExtractLocalVariableProcessor(project, editor, file).perform();
    }
}

