/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.introduce;

import com.google.common.collect.Lists;
import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import com.jetbrains.lang.dart.ide.refactoring.ServerExtractLocalVariableRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.introduce.DartServerExtractLocalVariableDialog;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import com.jetbrains.lang.dart.psi.DartExpression;
import java.util.ArrayList;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractLocalVariableProcessor {
    @NotNull
    final Project project;
    @NotNull
    final Editor editor;
    @NotNull
    final PsiFile file;
    ServerExtractLocalVariableRefactoring refactoring;

    ExtractLocalVariableProcessor(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/refactoring/introduce/ExtractLocalVariableProcessor", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/refactoring/introduce/ExtractLocalVariableProcessor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/refactoring/introduce/ExtractLocalVariableProcessor", "<init>"));
        }
        this.project = project;
        this.editor = editor;
        this.file = file;
    }

    public void perform() {
        int[] lengths;
        SelectionModel selectionModel = this.editor.getSelectionModel();
        int offset = selectionModel.getSelectionStart();
        int length = selectionModel.getSelectionEnd() - offset;
        this.createRefactoring(offset, length);
        if (this.refactoring == null) {
            return;
        }
        int[] offsets = this.refactoring.getCoveringExpressionOffsets();
        List<DartExpression> expressions = this.getDartExpressions(offsets, lengths = this.refactoring.getCoveringExpressionLengths());
        if (expressions == null) {
            return;
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.performOnExpression(expressions.get(0));
        } else if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)this.editor, expressions, (Pass)new Pass<DartExpression>(){

                public void pass(DartExpression expression) {
                    ExtractLocalVariableProcessor.this.performOnExpression(expression);
                }
            }, expression -> expression.getText());
        }
    }

    private void createRefactoring(int offset, int length) {
        this.refactoring = new ServerExtractLocalVariableRefactoring(this.project, this.file.getVirtualFile(), offset, length);
        RefactoringStatus initialStatus = this.refactoring.checkInitialConditions();
        if (this.showMessageIfError(initialStatus)) {
            this.refactoring = null;
        }
    }

    @Nullable
    private DartExpression findExpressionWithRange(int offset, int length) {
        return (DartExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)this.file, (int)offset, (int)(offset + length), DartExpression.class);
    }

    @Nullable
    private List<DartExpression> getDartExpressions(int[] offsets, int[] lengths) {
        ArrayList expressions = Lists.newArrayList();
        for (int i = 0; i < offsets.length; ++i) {
            DartExpression expression = this.findExpressionWithRange(offsets[i], lengths[i]);
            if (expression == null) {
                return null;
            }
            expressions.add(expression);
        }
        return expressions;
    }

    private void performInPlace() {
        RefactoringStatus finalConditions;
        String[] names = this.refactoring.getNames();
        if (names.length != 0) {
            this.refactoring.setName(names[0]);
        }
        if (this.showMessageIfError(finalConditions = this.refactoring.checkFinalConditions())) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            SourceChange change = this.refactoring.getChange();
            assert (change != null);
            try {
                AssistUtils.applySourceChange(this.project, change, true);
            }
            catch (DartSourceEditException e) {
                CommonRefactoringUtil.showErrorHint((Project)this.project, (Editor)this.editor, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
            }
        });
    }

    private void performOnElementOccurrences() {
        if (this.editor.getSettings().isVariableInplaceRenameEnabled()) {
            this.performInPlace();
        } else {
            new DartServerExtractLocalVariableDialog(this.project, this.editor, this.refactoring).showAndGet();
        }
    }

    private void performOnExpression(DartExpression expression) {
        int[] occurrencesLengths;
        int offset = expression.getTextOffset();
        int length = expression.getTextLength();
        this.createRefactoring(offset, length);
        if (this.refactoring == null) {
            return;
        }
        int[] occurrencesOffsets = this.refactoring.getOccurrencesOffsets();
        List<DartExpression> occurrences = this.getDartExpressions(occurrencesOffsets, occurrencesLengths = this.refactoring.getOccurrencesLengths());
        if (occurrences == null) {
            return;
        }
        OccurrencesChooser.simpleChooser((Editor)this.editor).showChooser((Object)expression, occurrences, (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                ExtractLocalVariableProcessor.this.refactoring.setExtractAll(replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
                ExtractLocalVariableProcessor.this.performOnElementOccurrences();
            }
        });
    }

    private boolean showMessageIfError(@Nullable RefactoringStatus status) {
        if (status == null) {
            return true;
        }
        if (status.hasError()) {
            String message = status.getMessage();
            assert (message != null);
            CommonRefactoringUtil.showErrorHint((Project)this.project, (Editor)this.editor, (String)message, (String)CommonBundle.getErrorTitle(), null);
            return true;
        }
        return false;
    }
}

