/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.status;

import com.google.common.collect.Lists;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusContext;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusEntry;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusSeverity;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringStatus {
    @NotNull
    private final List<RefactoringStatusEntry> entries = Lists.newArrayList();
    @NotNull
    private RefactoringStatusSeverity severity = RefactoringStatusSeverity.OK;

    public void addEntry(@NotNull RefactoringStatusEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "addEntry"));
        }
        this.entries.add(entry);
        this.severity = RefactoringStatus.max(this.severity, entry.getSeverity());
    }

    public void addError(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "addError"));
        }
        this.addError(msg, null);
    }

    public void addError(@NotNull String msg, @Nullable RefactoringStatusContext context) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "addError"));
        }
        this.addEntry(new RefactoringStatusEntry(RefactoringStatusSeverity.ERROR, msg, context));
    }

    public void addFatalError(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "addFatalError"));
        }
        this.addFatalError(msg, null);
    }

    public void addFatalError(@NotNull String msg, @Nullable RefactoringStatusContext context) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "addFatalError"));
        }
        this.addEntry(new RefactoringStatusEntry(RefactoringStatusSeverity.FATAL, msg, context));
    }

    public void addWarning(String msg) {
        this.addWarning(msg, null);
    }

    public void addWarning(@NotNull String msg, @Nullable RefactoringStatusContext context) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "addWarning"));
        }
        this.addEntry(new RefactoringStatusEntry(RefactoringStatusSeverity.WARNING, msg, context));
    }

    @NotNull
    public RefactoringStatus escalateErrorToFatal() {
        RefactoringStatus result = new RefactoringStatus();
        for (RefactoringStatusEntry entry : this.entries) {
            RefactoringStatusSeverity severity = entry.getSeverity();
            if (severity == RefactoringStatusSeverity.ERROR) {
                severity = RefactoringStatusSeverity.FATAL;
            }
            result.addEntry(new RefactoringStatusEntry(severity, entry.getMessage(), entry.getContext()));
        }
        RefactoringStatus refactoringStatus = result;
        if (refactoringStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "escalateErrorToFatal"));
        }
        return refactoringStatus;
    }

    @NotNull
    public List<RefactoringStatusEntry> getEntries() {
        List<RefactoringStatusEntry> list = this.entries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "getEntries"));
        }
        return list;
    }

    @Nullable
    public RefactoringStatusEntry getEntryWithHighestSeverity() {
        if (this.entries.isEmpty()) {
            return null;
        }
        RefactoringStatusEntry result = this.entries.get(0);
        for (RefactoringStatusEntry entry : this.entries) {
            if (result.getSeverity().ordinal() >= entry.getSeverity().ordinal()) continue;
            result = entry;
        }
        return result;
    }

    @Nullable
    public String getMessage() {
        RefactoringStatusEntry entry = this.getEntryWithHighestSeverity();
        if (entry == null) {
            return null;
        }
        return entry.getMessage();
    }

    @NotNull
    public RefactoringStatusSeverity getSeverity() {
        RefactoringStatusSeverity refactoringStatusSeverity = this.severity;
        if (refactoringStatusSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "getSeverity"));
        }
        return refactoringStatusSeverity;
    }

    public boolean hasError() {
        return this.severity == RefactoringStatusSeverity.FATAL || this.severity == RefactoringStatusSeverity.ERROR;
    }

    public boolean hasFatalError() {
        return this.severity == RefactoringStatusSeverity.FATAL;
    }

    public boolean hasInfo() {
        return this.severity == RefactoringStatusSeverity.FATAL || this.severity == RefactoringStatusSeverity.ERROR || this.severity == RefactoringStatusSeverity.WARNING || this.severity == RefactoringStatusSeverity.INFO;
    }

    public boolean hasWarning() {
        return this.severity == RefactoringStatusSeverity.FATAL || this.severity == RefactoringStatusSeverity.ERROR || this.severity == RefactoringStatusSeverity.WARNING;
    }

    public boolean isOK() {
        return this.severity == RefactoringStatusSeverity.OK;
    }

    public void merge(@Nullable RefactoringStatus other) {
        if (other == null) {
            return;
        }
        this.entries.addAll(other.entries);
        this.severity = RefactoringStatus.max(this.severity, other.getSeverity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.severity.name());
        if (!this.isOK()) {
            sb.append("\n");
            for (RefactoringStatusEntry entry : this.entries) {
                sb.append("\t").append(entry).append("\n");
            }
        }
        sb.append(">");
        return sb.toString();
    }

    @NotNull
    public static RefactoringStatus createErrorStatus(String msg) {
        RefactoringStatus status = new RefactoringStatus();
        status.addError(msg);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "createErrorStatus"));
        }
        return refactoringStatus;
    }

    @NotNull
    public static RefactoringStatus createFatalErrorStatus(String msg) {
        RefactoringStatus status = new RefactoringStatus();
        status.addFatalError(msg);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "createFatalErrorStatus"));
        }
        return refactoringStatus;
    }

    @NotNull
    public static RefactoringStatus createFatalErrorStatus(String msg, RefactoringStatusContext context) {
        RefactoringStatus status = new RefactoringStatus();
        status.addFatalError(msg, context);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "createFatalErrorStatus"));
        }
        return refactoringStatus;
    }

    @NotNull
    public static RefactoringStatus createWarningStatus(String msg) {
        RefactoringStatus status = new RefactoringStatus();
        status.addWarning(msg);
        RefactoringStatus refactoringStatus = status;
        if (refactoringStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "createWarningStatus"));
        }
        return refactoringStatus;
    }

    @NotNull
    private static <T extends Enum<T>> T max(@NotNull T a, @NotNull T b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "max"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "max"));
        }
        if (b.ordinal() > a.ordinal()) {
            T t = b;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "max"));
            }
            return t;
        }
        T t = a;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatus", "max"));
        }
        return t;
    }
}

