/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring.status;

import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusContext;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatusSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringStatusEntry {
    @NotNull
    private final RefactoringStatusSeverity severity;
    @NotNull
    private final String message;
    @Nullable
    private final RefactoringStatusContext context;

    public RefactoringStatusEntry(@NotNull RefactoringStatusSeverity severity, @NotNull String message) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatusEntry", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatusEntry", "<init>"));
        }
        this(severity, message, null);
    }

    public RefactoringStatusEntry(@NotNull RefactoringStatusSeverity severity, @NotNull String message, @Nullable RefactoringStatusContext ctx) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatusEntry", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatusEntry", "<init>"));
        }
        this.severity = severity;
        this.message = message;
        this.context = ctx;
    }

    @Nullable
    public RefactoringStatusContext getContext() {
        return this.context;
    }

    @NotNull
    public String getMessage() {
        String string = this.message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatusEntry", "getMessage"));
        }
        return string;
    }

    @NotNull
    public RefactoringStatusSeverity getSeverity() {
        RefactoringStatusSeverity refactoringStatusSeverity = this.severity;
        if (refactoringStatusSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/refactoring/status/RefactoringStatusEntry", "getSeverity"));
        }
        return refactoringStatusSeverity;
    }

    public boolean isError() {
        return this.severity == RefactoringStatusSeverity.ERROR;
    }

    public boolean isFatalError() {
        return this.severity == RefactoringStatusSeverity.FATAL;
    }

    public boolean isInfo() {
        return this.severity == RefactoringStatusSeverity.INFO;
    }

    public boolean isWarning() {
        return this.severity == RefactoringStatusSeverity.WARNING;
    }

    public String toString() {
        if (this.context != null) {
            return (Object)((Object)this.severity) + ": " + this.message + "; Context: " + this.context;
        }
        return (Object)((Object)this.severity) + ": " + this.message;
    }
}

