/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.runner.base.DartRunConfigurationBase;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunningState;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfiguration;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance((String)DartRunner.class.getName());

    @NotNull
    public String getRunnerId() {
        if ("DartRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/DartRunner", "getRunnerId"));
        }
        return "DartRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/lang/dart/ide/runner/DartRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/lang/dart/ide/runner/DartRunner", "canRun"));
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && (profile instanceof DartCommandLineRunConfiguration || profile instanceof DartTestRunConfiguration || profile instanceof DartRemoteDebugConfiguration);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/lang/dart/ide/runner/DartRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/ide/runner/DartRunner", "doExecute"));
        }
        String executorId = env.getExecutor().getId();
        if (!DefaultDebugExecutor.EXECUTOR_ID.equals(executorId)) {
            LOG.error("Unexpected executor id: " + executorId);
            return null;
        }
        try {
            String dasExecutionContextId;
            RunProfile runConfig = env.getRunProfile();
            if (runConfig instanceof DartRunConfigurationBase && DartAnalysisServerService.getInstance(env.getProject()).serverReadyForRequest(env.getProject())) {
                String path = ((DartRunConfigurationBase)runConfig).getRunnerParameters().getFilePath();
                assert (path != null);
                dasExecutionContextId = DartAnalysisServerService.getInstance(env.getProject()).execution_createContext(path);
            } else {
                dasExecutionContextId = null;
            }
            return this.doExecuteDartDebug(state, env, dasExecutionContextId);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected int getTimeout() {
        return 5000;
    }

    private RunContentDescriptor doExecuteDartDebug(@NotNull RunProfileState state, final @NotNull ExecutionEnvironment env, final @Nullable String dasExecutionContextId) throws RuntimeConfigurationError, ExecutionException {
        int observatoryPort;
        String debuggingHost;
        ExecutionResult executionResult;
        VirtualFile currentWorkingDirectory;
        VirtualFile contextFileOrDir;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/lang/dart/ide/runner/DartRunner", "doExecuteDartDebug"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/ide/runner/DartRunner", "doExecuteDartDebug"));
        }
        DartSdk sdk = DartSdk.getDartSdk(env.getProject());
        assert (sdk != null);
        final RunProfile runConfiguration = env.getRunProfile();
        if (runConfiguration instanceof DartRunConfigurationBase) {
            contextFileOrDir = ((DartRunConfigurationBase)runConfiguration).getRunnerParameters().getDartFileOrDirectory();
            String cwd = ((DartRunConfigurationBase)runConfiguration).getRunnerParameters().computeProcessWorkingDirectory(env.getProject());
            currentWorkingDirectory = LocalFileSystem.getInstance().findFileByPath(cwd);
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
            if (executionResult == null) {
                return null;
            }
            debuggingHost = null;
            observatoryPort = ((DartCommandLineRunningState)state).getObservatoryPort();
        } else if (runConfiguration instanceof DartRemoteDebugConfiguration) {
            String path = ((DartRemoteDebugConfiguration)runConfiguration).getParameters().getDartProjectPath();
            contextFileOrDir = LocalFileSystem.getInstance().findFileByPath(path);
            if (contextFileOrDir == null) {
                throw new RuntimeConfigurationError("Folder not found: " + FileUtil.toSystemDependentName((String)path));
            }
            currentWorkingDirectory = contextFileOrDir;
            executionResult = null;
            debuggingHost = ((DartRemoteDebugConfiguration)runConfiguration).getParameters().getHost();
            observatoryPort = ((DartRemoteDebugConfiguration)runConfiguration).getParameters().getPort();
        } else {
            LOG.error("Unexpected run configuration: " + runConfiguration.getClass().getName());
            return null;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)env.getProject());
        XDebugSession debugSession = debuggerManager.startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/lang/dart/ide/runner/DartRunner$1", "start"));
                }
                DartUrlResolver dartUrlResolver = DartRunner.this.getDartUrlResolver(env.getProject(), contextFileOrDir);
                DartVmServiceDebugProcess dartVmServiceDebugProcess = new DartVmServiceDebugProcess(session, StringUtil.notNullize((String)debuggingHost, (String)"localhost"), observatoryPort, executionResult, dartUrlResolver, dasExecutionContextId, runConfiguration instanceof DartRemoteDebugConfiguration, DartRunner.this.getTimeout(), currentWorkingDirectory);
                if (dartVmServiceDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/DartRunner$1", "start"));
                }
                return dartVmServiceDebugProcess;
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    protected DartUrlResolver getDartUrlResolver(@NotNull Project project, @NotNull VirtualFile contextFileOrDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/DartRunner", "getDartUrlResolver"));
        }
        if (contextFileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFileOrDir", "com/jetbrains/lang/dart/ide/runner/DartRunner", "getDartUrlResolver"));
        }
        return DartUrlResolver.getInstance(project, contextFileOrDir);
    }
}

