/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceStackFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPopFrameAction
extends AnAction
implements DumbAware {
    public DartPopFrameAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(DartBundle.message("dart.pop.frame.action.text", new Object[0]));
        presentation.setDescription(DartBundle.message("dart.pop.frame.action.description", new Object[0]));
        presentation.setIcon(AllIcons.Actions.PopFrame);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/runner/actions/DartPopFrameAction", "actionPerformed"));
        }
        DartVmServiceStackFrame frame = DartPopFrameAction.getStackFrame(e);
        if (frame != null) {
            frame.dropFrame();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/runner/actions/DartPopFrameAction", "update"));
        }
        DartVmServiceStackFrame frame = DartPopFrameAction.getStackFrame(e);
        boolean bl = enabled = frame != null && frame.canDrop();
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabled(enabled);
        } else {
            e.getPresentation().setVisible(enabled);
        }
    }

    @Nullable
    private static DartVmServiceStackFrame getStackFrame(@NotNull AnActionEvent e) {
        XStackFrame frame;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/runner/actions/DartPopFrameAction", "getStackFrame"));
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        XDebugSession session = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        if (session == null) {
            session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        }
        if (session != null && (frame = session.getCurrentStackFrame()) instanceof DartVmServiceStackFrame) {
            return (DartVmServiceStackFrame)frame;
        }
        return null;
    }
}

