/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.base;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.lang.dart.ide.runner.base.DartRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartRunConfigurationBase
extends LocatableConfigurationBase
implements RefactoringListenerProvider,
DartRunConfiguration {
    protected DartRunConfigurationBase(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @NotNull
    public abstract DartCommandLineRunnerParameters getRunnerParameters();

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.getRunnerParameters().check(this.getProject());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.getRunnerParameters(), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.getRunnerParameters(), (Element)element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        VirtualFile file;
        if (!(element instanceof PsiFileSystemItem)) {
            return null;
        }
        String filePath = this.getRunnerParameters().getFilePath();
        VirtualFile virtualFile = file = filePath == null ? null : ((PsiFileSystemItem)element).getVirtualFile();
        if (file == null) {
            return null;
        }
        String affectedPath = file.getPath();
        if (element instanceof PsiFile && filePath.equals(affectedPath)) {
            return new RenameRefactoringListener(affectedPath);
        }
        if (element instanceof PsiDirectory && filePath.startsWith(affectedPath + "/")) {
            return new RenameRefactoringListener(affectedPath);
        }
        return null;
    }

    private class RenameRefactoringListener
    extends UndoRefactoringElementAdapter {
        @NotNull
        private String myAffectedPath;

        private RenameRefactoringListener(String affectedPath) {
            if (affectedPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedPath", "com/jetbrains/lang/dart/ide/runner/base/DartRunConfigurationBase$RenameRefactoringListener", "<init>"));
            }
            this.myAffectedPath = affectedPath;
        }

        private String getNewPathAndUpdateAffectedPath(@NotNull PsiElement newElement) {
            VirtualFile newFile;
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/lang/dart/ide/runner/base/DartRunConfigurationBase$RenameRefactoringListener", "getNewPathAndUpdateAffectedPath"));
            }
            String oldPath = DartRunConfigurationBase.this.getRunnerParameters().getFilePath();
            VirtualFile virtualFile = newFile = newElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)newElement).getVirtualFile() : null;
            if (newFile != null && oldPath != null && oldPath.startsWith(this.myAffectedPath)) {
                String newPath = newFile.getPath() + oldPath.substring(this.myAffectedPath.length());
                this.myAffectedPath = newFile.getPath();
                return newPath;
            }
            return oldPath;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/runner/base/DartRunConfigurationBase$RenameRefactoringListener", "refactored"));
            }
            boolean generatedName = DartRunConfigurationBase.this.getName().equals(DartRunConfigurationBase.this.suggestedName());
            String filePath = DartRunConfigurationBase.this.getRunnerParameters().getFilePath();
            boolean updateWorkingDir = filePath != null && PathUtil.getParentPath((String)filePath).equals(DartRunConfigurationBase.this.getRunnerParameters().getWorkingDirectory());
            String newPath = this.getNewPathAndUpdateAffectedPath(element);
            DartRunConfigurationBase.this.getRunnerParameters().setFilePath(newPath);
            if (updateWorkingDir) {
                DartRunConfigurationBase.this.getRunnerParameters().setWorkingDirectory(PathUtil.getParentPath((String)newPath));
            }
            if (generatedName) {
                DartRunConfigurationBase.this.setGeneratedName();
            }
        }
    }
}

