/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.client;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeDebuggerEngine;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartiumDebuggerEngine
extends ChromeDebuggerEngine {
    private static final Logger LOG = Logger.getInstance(DartiumDebuggerEngine.class);

    @NotNull
    public ChromeDebugProcess createDebugProcess(@NotNull XDebugSession session, @NotNull WebBrowser browser, @NotNull DebuggableFileFinder fileFinder, @Nullable Url initialUrl, @Nullable ExecutionResult executionResult, boolean usePreliminaryPage) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "createDebugProcess"));
        }
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "createDebugProcess"));
        }
        if (fileFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFinder", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "createDebugProcess"));
        }
        ChromeDebugProcess debugProcess = super.createDebugProcess(session, browser, fileFinder, initialUrl, executionResult, usePreliminaryPage);
        debugProcess.setProcessBreakpointConditionsAtIdeSide(true);
        debugProcess.setBreakpointLanguageHint((breakpoint, location) -> {
            String result;
            String string = result = StringUtil.endsWithIgnoreCase((String)(breakpoint == null ? location.getUrl().getPath() : breakpoint.getFileUrl()), (String)".dart") ? "dart" : null;
            if (LOG.isDebugEnabled()) {
                LOG.debug(breakpoint + ", " + location.getUrl() + " " + result);
            }
            return result;
        });
        ChromeDebugProcess chromeDebugProcess = debugProcess;
        if (chromeDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "createDebugProcess"));
        }
        return chromeDebugProcess;
    }

    @Nullable
    public WebBrowser getBrowser() {
        return DartiumUtil.getDartiumBrowser();
    }

    public void checkAvailability(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "checkAvailability"));
        }
        if (DartiumUtil.getDartiumBrowser() == null) {
            throw new RuntimeConfigurationError(DartBundle.message("dartium.not.configured", CommonBundle.settingsActionPath()), () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "lambda$checkAvailability$1"));
                }
                DartConfigurable.openDartSettings(project);
            });
        }
    }

    protected boolean isPreferredEngineForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "isPreferredEngineForFile"));
        }
        return DartiumDebuggerEngine.isHtmlFileWithDartScript(psiFile);
    }

    private static boolean isHtmlFileWithDartScript(@Nullable PsiFile psiFile) {
        if (psiFile == null || !HtmlUtil.isHtmlFile((PsiElement)psiFile)) {
            return false;
        }
        String text = psiFile.getText();
        int i = -1;
        while ((i = text.indexOf("application/dart", i + 1)) != -1) {
            PsiElement element = psiFile.findElementAt(i);
            if (element == null || !(element.getParent() instanceof XmlAttributeValue) || !HtmlUtil.isScriptTag((XmlTag)((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)))) continue;
            return true;
        }
        return false;
    }

    public boolean isBrowserSupported(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/lang/dart/ide/runner/client/DartiumDebuggerEngine", "isBrowserSupported"));
        }
        return browser.equals(DartiumUtil.getDartiumBrowser());
    }
}

