/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.client;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartiumUtil {
    private static final String DART_FLAGS_ENV_VAR = "DART_FLAGS";
    public static final String CHECKED_MODE_OPTION = "--checked";
    private static final String ENABLE_ASYNC_OPTION = "--enable-async";
    private static final UUID DARTIUM_ID = UUID.fromString("BFEE1B69-A97D-4338-8BA4-25170ADCBAA6");
    private static final String DARTIUM_NAME = "Dartium";

    @Nullable
    public static WebBrowser getDartiumBrowser() {
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(DARTIUM_ID.toString());
        if (browser == null) {
            browser = WebBrowserManager.getInstance().findBrowserById(DARTIUM_NAME);
        }
        return browser != null && browser.getFamily() == BrowserFamily.CHROME ? browser : null;
    }

    @Nullable
    public static String getDartiumPathForSdk(@NotNull String sdkHomePath) {
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "getDartiumPathForSdk"));
        }
        File sdkDir = new File(sdkHomePath);
        if (!sdkDir.isDirectory()) {
            return null;
        }
        File dartDir = sdkDir.getParentFile();
        String relativePath = SystemInfo.isMac ? "chromium/Chromium.app" : (SystemInfo.isWindows ? "chromium/chrome.exe" : "chromium/chrome");
        File dartiumPath = new File(dartDir, relativePath);
        return dartiumPath.exists() ? FileUtil.toSystemIndependentName((String)dartiumPath.getPath()) : null;
    }

    @NotNull
    public static WebBrowser ensureDartiumBrowserConfigured(@Nullable String dartiumPath) {
        WebBrowser browser = DartiumUtil.getDartiumBrowser();
        if (browser == null) {
            WebBrowser webBrowser = WebBrowserManager.getInstance().addBrowser(DARTIUM_ID, BrowserFamily.CHROME, DARTIUM_NAME, dartiumPath, true, BrowserFamily.CHROME.createBrowserSpecificSettings());
            if (webBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "ensureDartiumBrowserConfigured"));
            }
            return webBrowser;
        }
        if (!Comparing.equal((String)dartiumPath, (String)browser.getPath())) {
            WebBrowserManager.getInstance().setBrowserPath(browser, dartiumPath, true);
        }
        WebBrowser webBrowser = browser;
        if (webBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "ensureDartiumBrowserConfigured"));
        }
        return webBrowser;
    }

    @Nullable
    public static String getErrorMessageIfWrongDartiumPath(@NotNull String dartiumPath) {
        if (dartiumPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartiumPath", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "getErrorMessageIfWrongDartiumPath"));
        }
        if (dartiumPath.isEmpty()) {
            return null;
        }
        File file = new File(dartiumPath);
        if (SystemInfo.isMac && !file.isDirectory() || !SystemInfo.isMac && !file.isFile()) {
            return DartBundle.message("warning.invalid.dartium.path", new Object[0]);
        }
        return null;
    }

    public static void applyDartiumSettings(@NotNull String dartiumPathFromUI, @NotNull ChromeSettings dartiumSettingsFromUI) {
        String dartiumPathInitial;
        if (dartiumPathFromUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartiumPathFromUI", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "applyDartiumSettings"));
        }
        if (dartiumSettingsFromUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartiumSettingsFromUI", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "applyDartiumSettings"));
        }
        WebBrowser dartiumInitial = DartiumUtil.getDartiumBrowser();
        String string = dartiumPathInitial = dartiumInitial == null ? null : dartiumInitial.getPath();
        if (!dartiumPathFromUI.isEmpty() && new File(dartiumPathFromUI).exists() && !dartiumPathFromUI.equals(dartiumPathInitial)) {
            DartSdkUtil.updateKnownDartiumPaths(dartiumPathInitial, dartiumPathFromUI);
            WebBrowser browser = DartiumUtil.ensureDartiumBrowserConfigured(dartiumPathFromUI);
            if (!dartiumSettingsFromUI.equals((Object)browser.getSpecificSettings())) {
                WebBrowserManager.getInstance().setBrowserSpecificSettings(browser, (BrowserSpecificSettings)dartiumSettingsFromUI);
            }
            return;
        }
        if (dartiumInitial != null && !dartiumSettingsFromUI.equals((Object)dartiumInitial.getSpecificSettings())) {
            WebBrowserManager.getInstance().setBrowserSpecificSettings(dartiumInitial, (BrowserSpecificSettings)dartiumSettingsFromUI);
        }
    }

    public static boolean isCheckedMode(@NotNull Map<String, String> envVars) {
        if (envVars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVars", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "isCheckedMode"));
        }
        return DartiumUtil.hasDartFlag(envVars, CHECKED_MODE_OPTION);
    }

    private static boolean hasDartFlag(Map<String, String> envVars, String dartFlag) {
        String dartFlags = envVars.get(DART_FLAGS_ENV_VAR);
        return dartFlags != null && (dartFlags.trim().equals(dartFlag) || dartFlags.startsWith(dartFlag + " ") || dartFlags.endsWith(" " + dartFlag) || dartFlags.contains(" " + dartFlag + " "));
    }

    public static void setCheckedMode(@NotNull Map<String, String> envVars, boolean checkedMode) {
        if (envVars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVars", "com/jetbrains/lang/dart/ide/runner/client/DartiumUtil", "setCheckedMode"));
        }
        DartiumUtil.setDartFlagState(envVars, CHECKED_MODE_OPTION, checkedMode);
    }

    private static void setDartFlagState(Map<String, String> envVars, String dartFlag, boolean flagState) {
        boolean oldFlagState = DartiumUtil.hasDartFlag(envVars, dartFlag);
        if (oldFlagState == flagState) {
            return;
        }
        String dartFlags = envVars.get(DART_FLAGS_ENV_VAR);
        if (flagState) {
            if (dartFlags == null) {
                envVars.put(DART_FLAGS_ENV_VAR, dartFlag);
            } else {
                envVars.put(DART_FLAGS_ENV_VAR, dartFlags + " " + dartFlag);
            }
        } else {
            String newFlags = dartFlags;
            if (newFlags.trim().equals(dartFlag)) {
                newFlags = "";
            }
            newFlags = StringUtil.trimStart((String)newFlags, (String)(dartFlag + " "));
            int index = (newFlags = StringUtil.trimEnd((String)newFlags, (String)(" " + dartFlag))).indexOf(" " + dartFlag + " ");
            if (index != -1) {
                newFlags = newFlags.substring(0, index) + newFlags.substring(index + dartFlag.length() + 1);
            }
            if (StringUtil.isEmptyOrSpaces((String)newFlags)) {
                envVars.remove(DART_FLAGS_ENV_VAR);
            } else {
                envVars.put(DART_FLAGS_ENV_VAR, newFlags);
            }
        }
    }

    public static void resetDartiumFlags() {
        BrowserSpecificSettings browserSpecificSettings;
        WebBrowser dartium = DartiumUtil.getDartiumBrowser();
        BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = dartium == null ? null : dartium.getSpecificSettings();
        if (!(browserSpecificSettings instanceof ChromeSettings)) {
            return;
        }
        Map envVars = browserSpecificSettings.getEnvironmentVariables();
        DartiumUtil.setDartFlagState(envVars, ENABLE_ASYNC_OPTION, false);
        DartiumUtil.setDartFlagState(envVars, CHECKED_MODE_OPTION, true);
    }
}

