/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.jetbrains.lang.dart.ide.runner.base.DartRunConfigurationBase;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfigurationType;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunningState;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartCommandLineConfigurationEditorForm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCommandLineRunConfiguration
extends DartRunConfigurationBase {
    @NotNull
    private DartCommandLineRunnerParameters myRunnerParameters = new DartCommandLineRunnerParameters();

    public DartCommandLineRunConfiguration(String name, Project project, DartCommandLineRunConfigurationType configurationType) {
        super(project, configurationType.getConfigurationFactories()[0], name);
    }

    @Override
    @NotNull
    public DartCommandLineRunnerParameters getRunnerParameters() {
        DartCommandLineRunnerParameters dartCommandLineRunnerParameters = this.myRunnerParameters;
        if (dartCommandLineRunnerParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunConfiguration", "getRunnerParameters"));
        }
        return dartCommandLineRunnerParameters;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        DartCommandLineConfigurationEditorForm dartCommandLineConfigurationEditorForm = new DartCommandLineConfigurationEditorForm(this.getProject());
        if (dartCommandLineConfigurationEditorForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunConfiguration", "getConfigurationEditor"));
        }
        return dartCommandLineConfigurationEditorForm;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRunConfiguration", "getState"));
        }
        return new DartCommandLineRunningState(env);
    }

    @Nullable
    public String suggestedName() {
        String filePath = this.myRunnerParameters.getFilePath();
        return filePath == null ? null : PathUtil.getFileName((String)filePath);
    }

    public DartCommandLineRunConfiguration clone() {
        DartCommandLineRunConfiguration clone = (DartCommandLineRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }
}

