/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.DartWritingAccessProvider;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfigurationType;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfigurationProducer;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCommandLineRuntimeConfigurationProducer
extends RunConfigurationProducer<DartCommandLineRunConfiguration> {
    public DartCommandLineRuntimeConfigurationProducer() {
        super((ConfigurationType)DartCommandLineRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(@NotNull DartCommandLineRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "setupConfigurationFromContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "setupConfigurationFromContext"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "setupConfigurationFromContext"));
        }
        VirtualFile dartFile = DartCommandLineRuntimeConfigurationProducer.getRunnableDartFileFromContext(context, true);
        if (dartFile == null || DartTestRunConfigurationProducer.isFileInTestDirAndTestPackageExists(context.getProject(), dartFile)) {
            return false;
        }
        configuration.getRunnerParameters().setFilePath(dartFile.getPath());
        configuration.getRunnerParameters().setWorkingDirectory(DartCommandLineRunnerParameters.suggestDartWorkingDir(context.getProject(), dartFile));
        configuration.setGeneratedName();
        sourceElement.set(sourceElement.isNull() ? null : ((PsiElement)sourceElement.get()).getContainingFile());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull DartCommandLineRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "isConfigurationFromContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "isConfigurationFromContext"));
        }
        VirtualFile dartFile = DartCommandLineRuntimeConfigurationProducer.getDartFileFromContext(context);
        return dartFile != null && dartFile.getPath().equals(configuration.getRunnerParameters().getFilePath());
    }

    @Nullable
    public static VirtualFile getRunnableDartFileFromContext(@NotNull ConfigurationContext context, boolean checkBrowserSpecificImports) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "getRunnableDartFileFromContext"));
        }
        PsiElement psiLocation = context.getPsiLocation();
        PsiFile psiFile = psiLocation == null ? null : psiLocation.getContainingFile();
        VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile(psiFile);
        if (!(!(psiFile instanceof DartFile) || virtualFile == null || !ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex().isInContent(virtualFile) || DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(psiFile.getProject(), virtualFile) || DartResolveUtil.getMainFunction(psiFile) == null || checkBrowserSpecificImports && DartCommandLineRuntimeConfigurationProducer.hasImport((DartFile)psiFile, "dart:html", "dart:html_common", "dart:indexed_db", "dart:js", "dart:svg", "dart:web_audio", "dart:web_gl", "dart:web_sql"))) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getDartFileFromContext(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "getDartFileFromContext"));
        }
        PsiElement psiLocation = context.getPsiLocation();
        PsiFile psiFile = psiLocation == null ? null : psiLocation.getContainingFile();
        VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile(psiFile);
        return psiFile instanceof DartFile && virtualFile != null ? virtualFile : null;
    }

    private static boolean hasImport(@NotNull DartFile psiFile, String ... importTexts) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "hasImport"));
        }
        if (importTexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importTexts", "com/jetbrains/lang/dart/ide/runner/server/DartCommandLineRuntimeConfigurationProducer", "hasImport"));
        }
        DartImportStatement[] importStatements = (DartImportStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, DartImportStatement.class);
        if (importStatements == null) {
            return false;
        }
        for (DartImportStatement importStatement : importStatements) {
            if (!ArrayUtil.contains((String)importStatement.getUriString(), (String[])importTexts)) continue;
            return true;
        }
        return false;
    }
}

