/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartConsoleFolding
extends ConsoleFolding {
    private static final String DART_MARKER = SystemInfo.isWindows ? "\\bin\\dart.exe " : "/bin/dart ";
    private static final String TEST_RUNNER_MARKER = "pub.dart.snapshot run test:test -r json ";
    private static final int MIN_FRAME_DISPLAY_COUNT = 8;
    private int myFrameCount = 0;

    public boolean shouldFoldLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/lang/dart/ide/runner/server/DartConsoleFolding", "shouldFoldLine"));
        }
        if (this.isFrameLine(line)) {
            ++this.myFrameCount;
            return this.myFrameCount > 8;
        }
        this.myFrameCount = 0;
        if (line.startsWith("Observatory listening on ")) {
            return true;
        }
        int index = line.indexOf(DART_MARKER);
        if (index < 0) {
            return false;
        }
        String probablySdkPath = line.substring(0, index);
        return DartSdkUtil.isDartSdkHome(probablySdkPath);
    }

    @Nullable
    public String getPlaceholderText(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/lang/dart/ide/runner/server/DartConsoleFolding", "getPlaceholderText"));
        }
        if (lines.size() == 1 && lines.get(0).startsWith("Observatory listening on ")) {
            return " [Observatory: " + lines.get(0).substring("Observatory listening on ".length()) + "]";
        }
        if (lines.size() == 1 && lines.get(0).contains(TEST_RUNNER_MARKER)) {
            return DartConsoleFolding.foldTestRunnerCommand(lines.get(0));
        }
        if (this.isFrameLine(lines.get(0))) {
            return " [" + lines.size() + " more...]";
        }
        String fullText = StringUtil.join(lines, (String)"\n");
        if (!lines.get(0).contains(DART_MARKER) || lines.size() == 2 && !lines.get(1).startsWith("Observatory listening on ") || lines.size() > 2) {
            return fullText;
        }
        String line = lines.get(0);
        int index = line.indexOf(32);
        assert (index > 0 && line.substring(0, index + 1).endsWith(DART_MARKER)) : line;
        while (line.length() > index + 1 && line.charAt(index + 1) == '-') {
            index = line.indexOf(" ", index + 1);
        }
        if (index < 0) {
            return fullText;
        }
        CommandLineTokenizer tok = new CommandLineTokenizer(line.substring(index));
        if (!tok.hasMoreTokens()) {
            return fullText;
        }
        String filePath = tok.nextToken();
        if (!filePath.contains(File.separator)) {
            return fullText;
        }
        StringBuilder b = new StringBuilder();
        b.append("dart ");
        b.append(PathUtil.getFileName((String)filePath));
        while (tok.hasMoreTokens()) {
            b.append(" ").append(tok.nextToken());
        }
        if (lines.size() == 2 && lines.get(1).startsWith("Observatory listening on ")) {
            b.append(" [Observatory: ").append(lines.get(1).substring("Observatory listening on ".length())).append("]");
        }
        return b.toString();
    }

    private boolean isFrameLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/lang/dart/ide/runner/server/DartConsoleFolding", "isFrameLine"));
        }
        if (this.myFrameCount > 0 && line.equals("...")) {
            return true;
        }
        if (this.myFrameCount > 0 && line.startsWith("<async") && line.endsWith(">")) {
            return true;
        }
        if (!line.startsWith("#") || !line.endsWith(")")) {
            return false;
        }
        if (line.length() < "#1234567x (x)".length()) {
            return false;
        }
        if (line.charAt(8) == ' ') {
            return false;
        }
        try {
            Integer.parseInt(line.substring(1, 8).trim());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static String foldTestRunnerCommand(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/lang/dart/ide/runner/server/DartConsoleFolding", "foldTestRunnerCommand"));
        }
        int index = line.indexOf(TEST_RUNNER_MARKER);
        index += TEST_RUNNER_MARKER.length();
        index = line.toLowerCase(Locale.US).indexOf(".dart", index);
        if (index < 0) {
            return line;
        }
        if ((index = FileUtil.toSystemIndependentName((String)line.substring(0, index)).lastIndexOf(47)) < 0) {
            return line;
        }
        return "pub run test " + line.substring(index + 1);
    }
}

