/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugConfigurationType;
import com.jetbrains.lang.dart.ide.runner.server.DartRemoteDebugParameters;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartRemoteDebugConfigurationEditor;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartRemoteDebugConfiguration
extends RunConfigurationBase
implements RunConfigurationWithSuppressedDefaultRunAction {
    @NotNull
    DartRemoteDebugParameters myParameters;

    protected DartRemoteDebugConfiguration(@NotNull Project project, @NotNull DartRemoteDebugConfigurationType configType, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration", "<init>"));
        }
        if (configType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configType", "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration", "<init>"));
        }
        super(project, configType.getConfigurationFactories()[0], name);
        this.myParameters = new DartRemoteDebugParameters();
    }

    @NotNull
    public DartRemoteDebugParameters getParameters() {
        DartRemoteDebugParameters dartRemoteDebugParameters = this.myParameters;
        if (dartRemoteDebugParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration", "getParameters"));
        }
        return dartRemoteDebugParameters;
    }

    public void checkConfiguration() throws RuntimeConfigurationError {
        String path = this.myParameters.getDartProjectPath();
        if (path.isEmpty()) {
            throw new RuntimeConfigurationError("Dart project path is not specified");
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
        if (dir == null || !dir.isDirectory()) {
            throw new RuntimeConfigurationError("Folder not found: " + FileUtil.toSystemDependentName((String)path));
        }
        if (!ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(dir)) {
            throw new RuntimeConfigurationError("Folder is not in project content: " + FileUtil.toSystemDependentName((String)path));
        }
    }

    public DartRemoteDebugConfiguration clone() {
        DartRemoteDebugConfiguration clone = (DartRemoteDebugConfiguration)super.clone();
        clone.myParameters = this.myParameters.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<DartRemoteDebugConfiguration> getConfigurationEditor() {
        DartRemoteDebugConfigurationEditor dartRemoteDebugConfigurationEditor = new DartRemoteDebugConfigurationEditor(this.getProject());
        if (dartRemoteDebugConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration", "getConfigurationEditor"));
        }
        return dartRemoteDebugConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/lang/dart/ide/runner/server/DartRemoteDebugConfiguration", "getState"));
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myParameters, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.myParameters, (Element)element);
    }
}

