/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.jetbrains.lang.dart.DartBundle;
import icons.DartIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.jsonRpc.Client;

public class OpenDartObservatoryUrlAction
extends DumbAwareAction {
    @Nullable
    private String myUrl;
    private final Computable<Boolean> myIsApplicable;

    public OpenDartObservatoryUrlAction(@Nullable String url, @NotNull Computable<Boolean> isApplicable) {
        if (isApplicable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isApplicable", "com/jetbrains/lang/dart/ide/runner/server/OpenDartObservatoryUrlAction", "<init>"));
        }
        super(DartBundle.message("open.observatory.action.text", new Object[0]), DartBundle.message("open.observatory.action.description", new Object[0]), DartIcons.Observatory);
        this.myUrl = url;
        this.myIsApplicable = isApplicable;
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/runner/server/OpenDartObservatoryUrlAction", "setUrl"));
        }
        this.myUrl = url;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/runner/server/OpenDartObservatoryUrlAction", "update"));
        }
        e.getPresentation().setEnabled(this.myUrl != null && (Boolean)this.myIsApplicable.compute() != false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/runner/server/OpenDartObservatoryUrlAction", "actionPerformed"));
        }
        if (this.myUrl != null) {
            OpenDartObservatoryUrlAction.openUrlInChromeFamilyBrowser(this.myUrl);
        }
    }

    public static void openUrlInChromeFamilyBrowser(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/runner/server/OpenDartObservatoryUrlAction", "openUrlInChromeFamilyBrowser"));
        }
        try {
            BrowserConnectionManager connectionManager = BrowserConnectionManager.getInstance();
            Client chromeClient = connectionManager.findClient(client -> {
                WebBrowser browser = connectionManager.getBrowser(client);
                return browser != null && browser.getFamily() == BrowserFamily.CHROME;
            });
            if (chromeClient != null) {
                BrowserConnectionManager.getInstance().openUrl(chromeClient, (CharSequence)url);
            } else {
                OpenDartObservatoryUrlAction.openInAnyChromeFamilyBrowser(url);
            }
        }
        catch (Throwable t) {
            OpenDartObservatoryUrlAction.openInAnyChromeFamilyBrowser(url);
        }
    }

    private static void openInAnyChromeFamilyBrowser(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/runner/server/OpenDartObservatoryUrlAction", "openInAnyChromeFamilyBrowser"));
        }
        List chromeBrowsers = WebBrowserManager.getInstance().getBrowsers(browser -> browser.getFamily() == BrowserFamily.CHROME, true);
        BrowserLauncher.getInstance().browse(url, chromeBrowsers.isEmpty() ? null : (WebBrowser)chromeBrowsers.get(0));
    }
}

