/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserFactory;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.ide.DartWritingAccessProvider;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DartCommandLineConfigurationEditorForm
extends SettingsEditor<DartCommandLineRunConfiguration> {
    private JPanel myMainPanel;
    private JLabel myDartFileLabel;
    private TextFieldWithBrowseButton myFileField;
    private RawCommandLineEditor myVMOptions;
    private JBCheckBox myCheckedModeCheckBox;
    private RawCommandLineEditor myArguments;
    private TextFieldWithBrowseButton myWorkingDirectory;
    private EnvironmentVariablesComponent myEnvironmentVariables;

    public DartCommandLineConfigurationEditorForm(Project project) {
        this.$$$setupUI$$$();
        DartCommandLineConfigurationEditorForm.initDartFileTextWithBrowse(project, this.myFileField);
        this.myWorkingDirectory.addBrowseFolderListener(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myVMOptions.setDialogCaption(DartBundle.message("config.vmoptions.caption", new Object[0]));
        this.myArguments.setDialogCaption(DartBundle.message("config.progargs.caption", new Object[0]));
        this.myDartFileLabel.setPreferredSize(this.myEnvironmentVariables.getLabel().getPreferredSize());
        this.myEnvironmentVariables.setAnchor((JComponent)this.myDartFileLabel);
    }

    public static void initDartFileTextWithBrowse(final @NotNull Project project, final @NotNull TextFieldWithBrowseButton textWithBrowse) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/server/ui/DartCommandLineConfigurationEditorForm", "initDartFileTextWithBrowse"));
        }
        if (textWithBrowse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textWithBrowse", "com/jetbrains/lang/dart/ide/runner/server/ui/DartCommandLineConfigurationEditorForm", "initDartFileTextWithBrowse"));
        }
        textWithBrowse.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile virtualFile;
                String initialPath = FileUtil.toSystemIndependentName((String)textWithBrowse.getText().trim());
                VirtualFile initialFile = initialPath.isEmpty() ? null : LocalFileSystem.getInstance().findFileByPath(initialPath);
                PsiFile initialPsiFile = initialFile == null ? null : PsiManager.getInstance((Project)project).findFile(initialFile);
                TreeFileChooser fileChooser = TreeFileChooserFactory.getInstance((Project)project).createFileChooser(DartBundle.message("choose.dart.main.file", new Object[0]), initialPsiFile, (FileType)DartFileType.INSTANCE, new TreeFileChooser.PsiFileFilter(){

                    public boolean accept(PsiFile file) {
                        return !DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(file);
                    }
                });
                fileChooser.showDialog();
                PsiFile selectedFile = fileChooser.getSelectedFile();
                VirtualFile virtualFile2 = virtualFile = selectedFile == null ? null : selectedFile.getVirtualFile();
                if (virtualFile != null) {
                    String path = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                    textWithBrowse.setText(path);
                }
            }
        });
    }

    protected void resetEditorFrom(@NotNull DartCommandLineRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/server/ui/DartCommandLineConfigurationEditorForm", "resetEditorFrom"));
        }
        DartCommandLineRunnerParameters parameters = configuration.getRunnerParameters();
        this.myFileField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)parameters.getFilePath())));
        this.myArguments.setText(StringUtil.notNullize((String)parameters.getArguments()));
        this.myVMOptions.setText(StringUtil.notNullize((String)parameters.getVMOptions()));
        this.myCheckedModeCheckBox.setSelected(parameters.isCheckedMode());
        this.myWorkingDirectory.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)parameters.getWorkingDirectory())));
        this.myEnvironmentVariables.setEnvs(parameters.getEnvs());
        this.myEnvironmentVariables.setPassParentEnvs(parameters.isIncludeParentEnvs());
    }

    protected void applyEditorTo(@NotNull DartCommandLineRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/server/ui/DartCommandLineConfigurationEditorForm", "applyEditorTo"));
        }
        DartCommandLineRunnerParameters parameters = configuration.getRunnerParameters();
        parameters.setFilePath(StringUtil.nullize((String)FileUtil.toSystemIndependentName((String)this.myFileField.getText().trim()), (boolean)true));
        parameters.setArguments(StringUtil.nullize((String)this.myArguments.getText(), (boolean)true));
        parameters.setVMOptions(StringUtil.nullize((String)this.myVMOptions.getText(), (boolean)true));
        parameters.setCheckedMode(this.myCheckedModeCheckBox.isSelected());
        parameters.setWorkingDirectory(StringUtil.nullize((String)FileUtil.toSystemIndependentName((String)this.myWorkingDirectory.getText().trim()), (boolean)true));
        parameters.setEnvs(this.myEnvironmentVariables.getEnvs());
        parameters.setIncludeParentEnvs(this.myEnvironmentVariables.isPassParentEnvs());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/ui/DartCommandLineConfigurationEditorForm", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        EnvironmentVariablesComponent environmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setFocusable(true);
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myDartFileLabel = jLabel = new JLabel();
        jLabel.setText("Dart file:");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setDisplayedMnemonicIndex(5);
        jLabel.setInheritsPopupMenu(true);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("VM options:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMOptions = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Program arguments:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(9);
        jLabel3.setInheritsPopupMenu(true);
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myArguments = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Working directory:");
        jLabel4.setDisplayedMnemonic('W');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnvironmentVariables = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setText("&Environment variables");
        environmentVariablesComponent.setLabelLocation("West");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myCheckedModeCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Checked mode");
        jBCheckBox.setMnemonic('C');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jBCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel2.setLabelFor((Component)rawCommandLineEditor2);
        jLabel3.setLabelFor((Component)rawCommandLineEditor);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

