/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.lang.dart.ide.runner.DartLineBreakpointType;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.IsolateBreakpointInfo;
import com.jetbrains.lang.dart.ide.runner.server.vmService.VmServiceWrapper;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.dartlang.vm.service.element.Breakpoint;
import org.jetbrains.annotations.NotNull;

public class DartVmServiceBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<XBreakpointProperties>> {
    private final DartVmServiceDebugProcess myDebugProcess;
    private final Set<XLineBreakpoint<XBreakpointProperties>> myXBreakpoints;
    private final Map<String, IsolateBreakpointInfo> myIsolateInfo;
    private final Map<String, XLineBreakpoint<XBreakpointProperties>> myVmBreakpointIdToXBreakpointMap;

    public DartVmServiceBreakpointHandler(@NotNull DartVmServiceDebugProcess debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "<init>"));
        }
        super(DartLineBreakpointType.class);
        this.myXBreakpoints = new THashSet();
        this.myIsolateInfo = new THashMap();
        this.myVmBreakpointIdToXBreakpointMap = new THashMap();
        this.myDebugProcess = debugProcess;
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint) {
        if (xBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "registerBreakpoint"));
        }
        this.myXBreakpoints.add(xBreakpoint);
        VmServiceWrapper vmServiceWrapper = this.myDebugProcess.getVmServiceWrapper();
        if (vmServiceWrapper != null) {
            vmServiceWrapper.addBreakpointForIsolates(xBreakpoint, this.myDebugProcess.getIsolateInfos());
        }
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint, boolean temporary) {
        if (xBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "unregisterBreakpoint"));
        }
        this.myXBreakpoints.remove(xBreakpoint);
        for (IsolateBreakpointInfo info : this.myIsolateInfo.values()) {
            info.unregisterBreakpoint(xBreakpoint);
        }
    }

    public Set<XLineBreakpoint<XBreakpointProperties>> getXBreakpoints() {
        return this.myXBreakpoints;
    }

    public void vmBreakpointAdded(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint, @NotNull String isolateId, @NotNull Breakpoint vmBreakpoint) {
        if (xBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "vmBreakpointAdded"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "vmBreakpointAdded"));
        }
        if (vmBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "vmBreakpointAdded"));
        }
        this.myVmBreakpointIdToXBreakpointMap.put(vmBreakpoint.getId(), xBreakpoint);
        IsolateBreakpointInfo info = this.getIsolateInfo(isolateId);
        info.vmBreakpointAdded(xBreakpoint, vmBreakpoint);
        if (vmBreakpoint.getResolved()) {
            this.breakpointResolved(vmBreakpoint);
        }
    }

    public void temporaryBreakpointAdded(String isolateId, Breakpoint vmBreakpoint) {
        this.getIsolateInfo(isolateId).temporaryVmBreakpointAdded(vmBreakpoint.getId());
    }

    public void removeTemporaryBreakpoints(String isolateId) {
        this.getIsolateInfo(isolateId).removeTemporaryBreakpoints();
    }

    public void removeAllVmBreakpoints(@NotNull String isolateId) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "removeAllVmBreakpoints"));
        }
        Set<String> vmBreakpoints = this.getIsolateInfo(isolateId).removeAllVmBreakpoints();
        for (String vmBreakpointId : vmBreakpoints) {
            this.myVmBreakpointIdToXBreakpointMap.remove(vmBreakpointId);
        }
    }

    private IsolateBreakpointInfo getIsolateInfo(String isolateId) {
        IsolateBreakpointInfo info = this.myIsolateInfo.get(isolateId);
        if (info == null) {
            info = new IsolateBreakpointInfo(isolateId, this.myDebugProcess);
            this.myIsolateInfo.put(isolateId, info);
        }
        return info;
    }

    public void breakpointResolved(@NotNull Breakpoint vmBreakpoint) {
        if (vmBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "breakpointResolved"));
        }
        XLineBreakpoint<XBreakpointProperties> xBreakpoint = this.myVmBreakpointIdToXBreakpointMap.get(vmBreakpoint.getId());
        if (xBreakpoint != null) {
            this.myDebugProcess.getSession().updateBreakpointPresentation(xBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
        }
    }

    public void breakpointFailed(@NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint) {
        if (xBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "breakpointFailed"));
        }
        this.myDebugProcess.getSession().updateBreakpointPresentation(xBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, null);
    }

    public XLineBreakpoint<XBreakpointProperties> getXBreakpoint(@NotNull Breakpoint vmBreakpoint) {
        if (vmBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceBreakpointHandler", "getXBreakpoint"));
        }
        return this.myVmBreakpointIdToXBreakpointMap.get(vmBreakpoint.getId());
    }
}

