/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import com.google.common.base.Charsets;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.runner.actions.DartPopFrameAction;
import com.jetbrains.lang.dart.ide.runner.base.DartDebuggerEditorsProvider;
import com.jetbrains.lang.dart.ide.runner.server.OpenDartObservatoryUrlAction;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceBreakpointHandler;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceListener;
import com.jetbrains.lang.dart.ide.runner.server.vmService.IsolatesInfo;
import com.jetbrains.lang.dart.ide.runner.server.vmService.VmServiceWrapper;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceStackFrame;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceSuspendContext;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceDebugProcess
extends XDebugProcess {
    private static final Logger LOG = Logger.getInstance((String)DartVmServiceDebugProcess.class.getName());
    @Nullable
    private final ExecutionResult myExecutionResult;
    @NotNull
    private final DartUrlResolver myDartUrlResolver;
    @NotNull
    private final String myDebuggingHost;
    private final int myObservatoryPort;
    private boolean myVmConnected;
    @NotNull
    private final XBreakpointHandler[] myBreakpointHandlers;
    private final IsolatesInfo myIsolatesInfo;
    private VmServiceWrapper myVmServiceWrapper;
    @NotNull
    private final Set<String> mySuspendedIsolateIds;
    private String myLatestCurrentIsolateId;
    private final Map<String, LightVirtualFile> myScriptIdToContentMap;
    private final Map<String, TIntObjectHashMap<Pair<Integer, Integer>>> myScriptIdToLinesAndColumnsMap;
    @Nullable
    private final String myDASExecutionContextId;
    private final boolean myRemoteDebug;
    private final int myTimeout;
    @Nullable
    private final VirtualFile myCurrentWorkingDirectory;
    @Nullable
    protected String myRemoteProjectRootUri;
    @NotNull
    private final OpenDartObservatoryUrlAction myOpenObservatoryAction;

    public DartVmServiceDebugProcess(@NotNull XDebugSession session, @NotNull String debuggingHost, int observatoryPort, @Nullable ExecutionResult executionResult, @NotNull DartUrlResolver dartUrlResolver, @Nullable String dasExecutionContextId, boolean remoteDebug, int timeout, @Nullable VirtualFile currentWorkingDirectory) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "<init>"));
        }
        if (debuggingHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggingHost", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "<init>"));
        }
        if (dartUrlResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartUrlResolver", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "<init>"));
        }
        super(session);
        this.myVmConnected = false;
        this.mySuspendedIsolateIds = Collections.synchronizedSet(new THashSet());
        this.myScriptIdToContentMap = new THashMap();
        this.myScriptIdToLinesAndColumnsMap = new THashMap();
        this.myOpenObservatoryAction = new OpenDartObservatoryUrlAction(null, (Computable<Boolean>)((Computable)() -> this.myVmConnected && !this.getSession().isStopped()));
        this.myDebuggingHost = debuggingHost;
        this.myObservatoryPort = observatoryPort;
        this.myExecutionResult = executionResult;
        this.myDartUrlResolver = dartUrlResolver;
        this.myRemoteDebug = remoteDebug;
        this.myTimeout = timeout;
        this.myCurrentWorkingDirectory = currentWorkingDirectory;
        this.myIsolatesInfo = new IsolatesInfo();
        DartVmServiceBreakpointHandler breakpointHandler = new DartVmServiceBreakpointHandler(this);
        this.myBreakpointHandlers = new XBreakpointHandler[]{breakpointHandler};
        this.setLogger();
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                this.stackFrameChanged();
            }

            public void stackFrameChanged() {
                XStackFrame stackFrame = DartVmServiceDebugProcess.this.getSession().getCurrentStackFrame();
                DartVmServiceDebugProcess.this.myLatestCurrentIsolateId = stackFrame instanceof DartVmServiceStackFrame ? ((DartVmServiceStackFrame)stackFrame).getIsolateId() : null;
            }
        });
        this.myDASExecutionContextId = dasExecutionContextId;
        if (remoteDebug) {
            this.scheduleConnect(this.getObservatoryUrl("ws", "/ws"));
        } else {
            this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    String prefix = "Observatory listening on http://";
                    if (event.getText().startsWith("Observatory listening on http://")) {
                        DartVmServiceDebugProcess.this.getProcessHandler().removeProcessListener((ProcessListener)this);
                        String urlBase = event.getText().substring("Observatory listening on http://".length());
                        DartVmServiceDebugProcess.this.scheduleConnect("ws://" + StringUtil.trimTrailing((String)urlBase.trim(), (char)'/') + "/ws");
                        DartVmServiceDebugProcess.this.myOpenObservatoryAction.setUrl("http://" + urlBase);
                    }
                }
            });
        }
        if (remoteDebug) {
            LOG.assertTrue(this.myExecutionResult == null && this.myDASExecutionContextId == null, (Object)(this.myDASExecutionContextId + this.myExecutionResult));
        } else {
            LOG.assertTrue(this.myExecutionResult != null && this.myDASExecutionContextId != null, (Object)(this.myDASExecutionContextId + this.myExecutionResult));
        }
    }

    public VmServiceWrapper getVmServiceWrapper() {
        return this.myVmServiceWrapper;
    }

    public Collection<IsolatesInfo.IsolateInfo> getIsolateInfos() {
        return this.myIsolatesInfo.getIsolateInfos();
    }

    private void setLogger() {
        Logging.setLogger(new org.dartlang.vm.service.logging.Logger(){

            @Override
            public void logError(String message) {
                if (message.contains("\"code\":102,")) {
                    return;
                }
                if (message.contains("\"method\":\"removeBreakpoint\"")) {
                    return;
                }
                DartVmServiceDebugProcess.this.getSession().getConsoleView().print("Error: " + message + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                LOG.error(message);
            }

            @Override
            public void logError(String message, Throwable exception) {
                DartVmServiceDebugProcess.this.getSession().getConsoleView().print("Error: " + message + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                LOG.error(message, exception);
            }

            @Override
            public void logInformation(String message) {
                if (message.length() > 500) {
                    message = message.substring(0, 300) + "..." + message.substring(message.length() - 200);
                }
                LOG.debug(message);
            }

            @Override
            public void logInformation(String message, Throwable exception) {
                LOG.debug(message, exception);
            }
        });
    }

    protected void scheduleConnect(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "scheduleConnect"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "lambda$scheduleConnect$1"));
            }
            long timeout = this.myTimeout;
            long startTime = System.currentTimeMillis();
            try {
                while (true) {
                    try {
                        this.connect(url);
                    }
                    catch (IOException e) {
                        if (System.currentTimeMillis() > startTime + timeout) {
                            throw e;
                        }
                        TimeoutUtil.sleep((long)50L);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                String message = "Failed to connect to the VM observatory service: " + e.toString() + "\n";
                Throwable cause = e.getCause();
                while (cause != null) {
                    message = message + "Caused by: " + cause.toString() + "\n";
                    Throwable cause1 = cause.getCause();
                    if (cause1 == cause) continue;
                    cause = cause1;
                }
                this.getSession().getConsoleView().print(message, ConsoleViewContentType.ERROR_OUTPUT);
                this.getSession().stop();
            }
        });
    }

    private void connect(@NotNull String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "connect"));
        }
        VmService vmService = VmService.connect(url);
        DartVmServiceListener vmServiceListener = new DartVmServiceListener(this, (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0]);
        vmService.addVmServiceListener(vmServiceListener);
        this.myVmServiceWrapper = new VmServiceWrapper(this, vmService, vmServiceListener, this.myIsolatesInfo, (DartVmServiceBreakpointHandler)this.myBreakpointHandlers[0]);
        this.myVmServiceWrapper.handleDebuggerConnected();
        this.myVmConnected = true;
    }

    @Deprecated
    @NotNull
    private String getObservatoryUrl(@NotNull String scheme, @Nullable String path) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getObservatoryUrl"));
        }
        String string = scheme + "://" + this.myDebuggingHost + ":" + this.myObservatoryPort + StringUtil.notNullize((String)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getObservatoryUrl"));
        }
        return string;
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myExecutionResult == null ? super.doGetProcessHandler() : this.myExecutionResult.getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.myExecutionResult == null ? super.createConsole() : this.myExecutionResult.getExecutionConsole();
        if (executionConsole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "createConsole"));
        }
        return executionConsole;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        DartDebuggerEditorsProvider dartDebuggerEditorsProvider = new DartDebuggerEditorsProvider();
        if (dartDebuggerEditorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getEditorsProvider"));
        }
        return dartDebuggerEditorsProvider;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getBreakpointHandlers"));
        }
        return this.myBreakpointHandlers;
    }

    public boolean isRemoteDebug() {
        return this.myRemoteDebug;
    }

    public void guessRemoteProjectRoot(@NotNull ElementList<LibraryRef> libraries) {
        VirtualFile projectRoot;
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "guessRemoteProjectRoot"));
        }
        VirtualFile pubspec = this.myDartUrlResolver.getPubspecYamlFile();
        VirtualFile virtualFile = projectRoot = pubspec != null ? pubspec.getParent() : this.myCurrentWorkingDirectory;
        if (projectRoot == null) {
            return;
        }
        for (LibraryRef library : libraries) {
            String remoteUri = library.getUri();
            if (remoteUri.startsWith("dart:") || remoteUri.startsWith("package:")) continue;
            PsiFile[] localFilesWithSameName = (PsiFile[])ReadAction.compute(() -> {
                String remoteFileName = PathUtil.getFileName((String)remoteUri);
                GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)this.getSession().getProject(), (VirtualFile)projectRoot, (boolean)true);
                return FilenameIndex.getFilesByName((Project)this.getSession().getProject(), (String)remoteFileName, (GlobalSearchScope)scope);
            });
            int howManyFilesMatch = 0;
            for (PsiFile psiFile : localFilesWithSameName) {
                VirtualFile file = DartResolveUtil.getRealVirtualFile(psiFile);
                if (file == null) continue;
                LOG.assertTrue(file.getPath().startsWith(projectRoot.getPath() + "/"), (Object)(file.getPath() + "," + projectRoot.getPath()));
                String relPath = file.getPath().substring(projectRoot.getPath().length());
                if (!remoteUri.endsWith(relPath)) continue;
                ++howManyFilesMatch;
                this.myRemoteProjectRootUri = remoteUri.substring(0, remoteUri.length() - relPath.length());
            }
            if (howManyFilesMatch != true) continue;
            break;
        }
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            DartVmServiceSuspendContext suspendContext = (DartVmServiceSuspendContext)context;
            StepOption stepOption = suspendContext != null && suspendContext.getAtAsyncSuspension() ? StepOption.OverAsyncSuspension : StepOption.Over;
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, stepOption);
        }
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, StepOption.Into);
        }
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, StepOption.Out);
        }
    }

    public void dropFrame(DartVmServiceStackFrame frame) {
        this.myVmServiceWrapper.dropFrame(frame.getIsolateId(), frame.getFrameIndex() + 1);
    }

    public void stop() {
        this.myVmConnected = false;
        if (this.myVmServiceWrapper != null) {
            if (this.myDASExecutionContextId != null) {
                DartAnalysisServerService.getInstance(this.getSession().getProject()).execution_deleteContext(this.myDASExecutionContextId);
            }
            Disposer.dispose((Disposable)this.myVmServiceWrapper);
        }
    }

    public void resume(@Nullable XSuspendContext context) {
        for (String isolateId : new ArrayList<String>(this.mySuspendedIsolateIds)) {
            this.myVmServiceWrapper.resumeIsolate(isolateId, null);
        }
    }

    public void startPausing() {
        for (IsolatesInfo.IsolateInfo info : this.getIsolateInfos()) {
            if (this.mySuspendedIsolateIds.contains(info.getIsolateId())) continue;
            this.myVmServiceWrapper.pauseIsolate(info.getIsolateId());
        }
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "runToPosition"));
        }
        if (this.myLatestCurrentIsolateId != null && this.mySuspendedIsolateIds.contains(this.myLatestCurrentIsolateId)) {
            this.myVmServiceWrapper.addTemporaryBreakpoint(position, this.myLatestCurrentIsolateId);
            this.myVmServiceWrapper.resumeIsolate(this.myLatestCurrentIsolateId, null);
        }
    }

    public void isolateSuspended(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "isolateSuspended"));
        }
        this.mySuspendedIsolateIds.add(isolateRef.getId());
    }

    public boolean isIsolateSuspended(@NotNull String isolateId) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "isIsolateSuspended"));
        }
        return this.mySuspendedIsolateIds.contains(isolateId);
    }

    public boolean isIsolateAlive(@NotNull String isolateId) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "isIsolateAlive"));
        }
        for (IsolatesInfo.IsolateInfo isolateInfo : this.myIsolatesInfo.getIsolateInfos()) {
            if (!isolateId.equals(isolateInfo.getIsolateId())) continue;
            return true;
        }
        return false;
    }

    public void isolateResumed(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "isolateResumed"));
        }
        this.mySuspendedIsolateIds.remove(isolateRef.getId());
    }

    public void isolateExit(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "isolateExit"));
        }
        this.myIsolatesInfo.deleteIsolate(isolateRef);
        this.mySuspendedIsolateIds.remove(isolateRef.getId());
        if (isolateRef.getId().equals(this.myLatestCurrentIsolateId)) {
            this.resume(this.getSession().getSuspendContext());
        }
    }

    public void handleWriteEvent(String base64Data) {
        String message = new String(Base64.getDecoder().decode(base64Data), Charsets.UTF_8);
        this.getSession().getConsoleView().print(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public String getCurrentStateMessage() {
        return this.getSession().isStopped() ? XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]) : (this.myVmConnected ? XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]) : DartBundle.message("debugger.trying.to.connect.vm.at.0", this.getObservatoryUrl("ws", "/ws")));
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftToolbar", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "registerAdditionalActions"));
        }
        if (topToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topToolbar", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "registerAdditionalActions"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "registerAdditionalActions"));
        }
        topToolbar.addSeparator();
        topToolbar.addAction((AnAction)this.myOpenObservatoryAction);
        topToolbar.addAction((AnAction)new DartPopFrameAction());
    }

    @NotNull
    public Collection<String> getUrisForFile(@NotNull VirtualFile file) {
        String uriByServer;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getUrisForFile"));
        }
        HashSet result = new HashSet();
        String uriByIde = this.myDartUrlResolver.getDartUrlForFile(file);
        if (uriByIde.startsWith("dart:")) {
            result.add(uriByIde);
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getUrisForFile"));
            }
            return hashSet;
        }
        if (uriByIde.startsWith("file:")) {
            result.add(DartVmServiceDebugProcess.threeSlashize(uriByIde));
        } else {
            result.add(uriByIde);
            result.add(DartVmServiceDebugProcess.threeSlashize(new File(file.getPath()).toURI().toString()));
        }
        result.add(file.getPath());
        if (this.myDASExecutionContextId != null && (uriByServer = DartAnalysisServerService.getInstance(this.getSession().getProject()).execution_mapUri(this.myDASExecutionContextId, file.getPath(), null)) != null) {
            result.add(uriByServer);
        }
        if (this.myRemoteProjectRootUri != null) {
            VirtualFile pubspec = this.myDartUrlResolver.getPubspecYamlFile();
            if (pubspec != null) {
                String projectPath = pubspec.getParent().getPath();
                String filePath = file.getPath();
                if (filePath.startsWith(projectPath)) {
                    result.add(this.myRemoteProjectRootUri + filePath.substring(projectPath.length()));
                }
            } else if (this.myCurrentWorkingDirectory != null) {
                String projectPath = this.myCurrentWorkingDirectory.getPath();
                String filePath = file.getPath();
                if (filePath.startsWith(projectPath)) {
                    result.add(this.myRemoteProjectRootUri + filePath.substring(projectPath.length()));
                }
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getUrisForFile"));
        }
        return hashSet;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull String isolateId, @NotNull ScriptRef scriptRef, int tokenPos) {
        Pair lineAndColumn;
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getSourcePosition"));
        }
        if (scriptRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "getSourcePosition"));
        }
        VirtualFile file = (VirtualFile)ReadAction.compute(() -> {
            String path;
            if (scriptRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "lambda$getSourcePosition$3"));
            }
            String uri = scriptRef.getUri();
            if (this.myDASExecutionContextId != null && !DartVmServiceDebugProcess.isDartPatchUri(uri) && (path = DartAnalysisServerService.getInstance(this.getSession().getProject()).execution_mapUri(this.myDASExecutionContextId, null, uri)) != null) {
                return LocalFileSystem.getInstance().findFileByPath(path);
            }
            VirtualFile pubspec = this.myDartUrlResolver.getPubspecYamlFile();
            if (this.myRemoteProjectRootUri != null && uri.startsWith(this.myRemoteProjectRootUri) && pubspec != null) {
                String localRootUri = StringUtil.trimEnd((String)this.myDartUrlResolver.getDartUrlForFile(pubspec.getParent()), (char)'/');
                LOG.assertTrue(localRootUri.startsWith("file:"), (Object)localRootUri);
                uri = localRootUri + uri.substring(this.myRemoteProjectRootUri.length());
            }
            return this.myDartUrlResolver.findFileByDartUrl(uri);
        });
        if (file == null) {
            file = (VirtualFile)this.myScriptIdToContentMap.get(scriptRef.getId());
        }
        TIntObjectHashMap<Pair<Integer, Integer>> tokenPosToLineAndColumn = this.myScriptIdToLinesAndColumnsMap.get(scriptRef.getId());
        if (file != null && tokenPosToLineAndColumn != null) {
            Pair lineAndColumn2 = (Pair)tokenPosToLineAndColumn.get(tokenPos);
            if (lineAndColumn2 == null) {
                return XDebuggerUtil.getInstance().createPositionByOffset(file, 0);
            }
            return XDebuggerUtil.getInstance().createPosition(file, ((Integer)lineAndColumn2.first).intValue(), ((Integer)lineAndColumn2.second).intValue());
        }
        Script script = this.myVmServiceWrapper.getScriptSync(isolateId, scriptRef.getId());
        if (script == null) {
            return null;
        }
        if (file == null) {
            file = new LightVirtualFile(PathUtil.getFileName((String)script.getUri()), (FileType)DartFileType.INSTANCE, (CharSequence)script.getSource());
            ((LightVirtualFile)file).setWritable(false);
            this.myScriptIdToContentMap.put(scriptRef.getId(), (LightVirtualFile)file);
        }
        if (tokenPosToLineAndColumn == null) {
            tokenPosToLineAndColumn = DartVmServiceDebugProcess.createTokenPosToLineAndColumnMap(script.getTokenPosTable());
            this.myScriptIdToLinesAndColumnsMap.put(scriptRef.getId(), tokenPosToLineAndColumn);
        }
        if ((lineAndColumn = (Pair)tokenPosToLineAndColumn.get(tokenPos)) == null) {
            return XDebuggerUtil.getInstance().createPositionByOffset(file, 0);
        }
        return XDebuggerUtil.getInstance().createPosition(file, ((Integer)lineAndColumn.first).intValue(), ((Integer)lineAndColumn.second).intValue());
    }

    private static boolean isDartPatchUri(@NotNull String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "isDartPatchUri"));
        }
        return uri.startsWith("dart:_") || uri.startsWith("dart:") && uri.contains("-patch/");
    }

    @NotNull
    private static TIntObjectHashMap<Pair<Integer, Integer>> createTokenPosToLineAndColumnMap(@NotNull List<List<Integer>> tokenPosTable) {
        if (tokenPosTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenPosTable", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "createTokenPosToLineAndColumnMap"));
        }
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (List<Integer> lineAndPairs : tokenPosTable) {
            Iterator<Integer> iterator = lineAndPairs.iterator();
            int line = Math.max(0, iterator.next() - 1);
            while (iterator.hasNext()) {
                int tokenPos = iterator.next();
                int column = Math.max(0, iterator.next() - 1);
                result.put(tokenPos, (Object)Pair.create((Object)line, (Object)column));
            }
        }
        TIntObjectHashMap tIntObjectHashMap = result;
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "createTokenPosToLineAndColumnMap"));
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static String threeSlashize(@NotNull String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "threeSlashize"));
        }
        if (!uri.startsWith("file:")) {
            String string = uri;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "threeSlashize"));
            }
            return string;
        }
        if (uri.startsWith("file:///")) {
            String string = uri;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "threeSlashize"));
            }
            return string;
        }
        if (uri.startsWith("file://")) {
            String string = "file:///" + uri.substring("file://".length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "threeSlashize"));
            }
            return string;
        }
        if (uri.startsWith("file:/")) {
            String string = "file:///" + uri.substring("file:/".length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "threeSlashize"));
            }
            return string;
        }
        if (uri.startsWith("file:")) {
            String string = "file:///" + uri.substring("file:".length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "threeSlashize"));
            }
            return string;
        }
        String string = uri;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceDebugProcess", "threeSlashize"));
        }
        return string;
    }
}

