/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceBreakpointHandler;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceSuspendContext;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceValue;
import org.dartlang.vm.service.VmServiceListener;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.StepOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceListener
implements VmServiceListener {
    private static final Logger LOG = Logger.getInstance((String)DartVmServiceListener.class.getName());
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final DartVmServiceBreakpointHandler myBreakpointHandler;
    @Nullable
    private XSourcePosition myLatestSourcePosition;

    public DartVmServiceListener(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull DartVmServiceBreakpointHandler breakpointHandler) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "<init>"));
        }
        if (breakpointHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointHandler", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "<init>"));
        }
        this.myDebugProcess = debugProcess;
        this.myBreakpointHandler = breakpointHandler;
    }

    @Override
    public void connectionOpened() {
    }

    @Override
    public void received(@NotNull String streamId, @NotNull Event event) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "received"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "received"));
        }
        switch (event.getKind()) {
            case BreakpointAdded: {
                break;
            }
            case BreakpointRemoved: {
                break;
            }
            case BreakpointResolved: {
                this.myBreakpointHandler.breakpointResolved(event.getBreakpoint());
                break;
            }
            case Extension: {
                break;
            }
            case GC: {
                break;
            }
            case Inspect: {
                break;
            }
            case IsolateExit: {
                this.myDebugProcess.isolateExit(event.getIsolate());
                break;
            }
            case IsolateReload: {
                break;
            }
            case IsolateRunnable: {
                break;
            }
            case IsolateStart: {
                break;
            }
            case IsolateUpdate: {
                break;
            }
            case None: {
                break;
            }
            case PauseBreakpoint: 
            case PauseException: 
            case PauseInterrupted: {
                this.myDebugProcess.isolateSuspended(event.getIsolate());
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "lambda$received$0"));
                    }
                    ElementList<Breakpoint> breakpoints = event.getKind() == EventKind.PauseBreakpoint ? event.getPauseBreakpoints() : null;
                    InstanceRef exception = event.getKind() == EventKind.PauseException ? event.getException() : null;
                    this.onIsolatePaused(event.getIsolate(), breakpoints, exception, event.getTopFrame(), event.getAtAsyncSuspension());
                });
                break;
            }
            case PausePostRequest: {
                this.myDebugProcess.getVmServiceWrapper().restoreBreakpointsForIsolate(event.getIsolate().getId(), () -> {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "lambda$received$1"));
                    }
                    this.myDebugProcess.getVmServiceWrapper().resumeIsolate(event.getIsolate().getId(), null);
                });
                break;
            }
            case PauseExit: {
                break;
            }
            case PauseStart: {
                this.myDebugProcess.getVmServiceWrapper().handleIsolate(event.getIsolate(), true);
                break;
            }
            case Resume: {
                this.myDebugProcess.isolateResumed(event.getIsolate());
                break;
            }
            case ServiceExtensionAdded: {
                break;
            }
            case VMUpdate: {
                break;
            }
            case WriteEvent: {
                this.myDebugProcess.handleWriteEvent(event.getBytes());
                break;
            }
        }
    }

    @Override
    public void connectionClosed() {
        if (this.myDebugProcess.isRemoteDebug()) {
            this.myDebugProcess.getSession().stop();
        }
    }

    void onIsolatePaused(@NotNull IsolateRef isolateRef, @Nullable ElementList<Breakpoint> vmBreakpoints, @Nullable InstanceRef exception, @Nullable Frame vmTopFrame, boolean atAsyncSuspension) {
        XSourcePosition sourcePosition;
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "onIsolatePaused"));
        }
        if (vmTopFrame == null) {
            this.myDebugProcess.getSession().positionReached(new XSuspendContext(){});
            return;
        }
        DartVmServiceSuspendContext suspendContext = new DartVmServiceSuspendContext(this.myDebugProcess, isolateRef, vmTopFrame, exception, atAsyncSuspension);
        XStackFrame xTopFrame = suspendContext.getActiveExecutionStack().getTopFrame();
        XSourcePosition xSourcePosition = sourcePosition = xTopFrame == null ? null : xTopFrame.getSourcePosition();
        if (vmBreakpoints == null || vmBreakpoints.isEmpty()) {
            StepOption latestStep = this.myDebugProcess.getVmServiceWrapper().getLatestStep();
            if (latestStep == StepOption.Over && DartVmServiceListener.equalSourcePositions(this.myLatestSourcePosition, sourcePosition)) {
                this.myDebugProcess.getVmServiceWrapper().resumeIsolate(isolateRef.getId(), latestStep);
            } else {
                this.myLatestSourcePosition = sourcePosition;
                this.myDebugProcess.getSession().positionReached((XSuspendContext)suspendContext);
            }
        } else {
            if (vmBreakpoints.size() > 1) {
                LOG.error(vmBreakpoints.size() + " breakpoints hit in one shot.");
            }
            this.myBreakpointHandler.removeTemporaryBreakpoints(isolateRef.getId());
            XLineBreakpoint<XBreakpointProperties> xBreakpoint = this.myBreakpointHandler.getXBreakpoint(vmBreakpoints.get(0));
            if (xBreakpoint == null) {
                this.myLatestSourcePosition = sourcePosition;
                this.myDebugProcess.getSession().positionReached((XSuspendContext)suspendContext);
                return;
            }
            if ("false".equals(this.evaluateExpression(isolateRef.getId(), vmTopFrame, xBreakpoint.getConditionExpression()))) {
                this.myDebugProcess.getVmServiceWrapper().resumeIsolate(isolateRef.getId(), null);
                return;
            }
            this.myLatestSourcePosition = sourcePosition;
            String logExpression = this.evaluateExpression(isolateRef.getId(), vmTopFrame, xBreakpoint.getLogExpressionObject());
            boolean suspend = this.myDebugProcess.getSession().breakpointReached(xBreakpoint, logExpression, (XSuspendContext)suspendContext);
            if (!suspend) {
                this.myDebugProcess.getVmServiceWrapper().resumeIsolate(isolateRef.getId(), null);
            }
        }
    }

    private static boolean equalSourcePositions(@Nullable XSourcePosition position1, @Nullable XSourcePosition position2) {
        return position1 != null && position2 != null && position1.getFile().equals(position2.getFile()) && position1.getLine() == position2.getLine();
    }

    @Nullable
    private String evaluateExpression(@NotNull String isolateId, @Nullable Frame vmTopFrame, @Nullable XExpression xExpression) {
        String evalText;
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "evaluateExpression"));
        }
        String string = evalText = xExpression == null ? null : xExpression.getExpression();
        if (vmTopFrame == null || StringUtil.isEmptyOrSpaces((String)evalText)) {
            return null;
        }
        final Ref evalResult = new Ref();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myDebugProcess.getVmServiceWrapper().evaluateInFrame(isolateId, vmTopFrame, evalText, new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener$2", "evaluated"));
                }
                if (result instanceof DartVmServiceValue) {
                    evalResult.set((Object)DartVmServiceListener.getSimpleStringPresentation(((DartVmServiceValue)result).getInstanceRef()));
                }
                semaphore.up();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener$2", "errorOccurred"));
                }
                evalResult.set((Object)("Failed to evaluate log expression [" + evalText + "]: " + errorMessage));
                semaphore.up();
            }
        });
        semaphore.waitFor(1000L);
        return (String)evalResult.get();
    }

    @NotNull
    private static String getSimpleStringPresentation(@NotNull InstanceRef instanceRef) {
        if (instanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "getSimpleStringPresentation"));
        }
        switch (instanceRef.getKind()) {
            case Null: 
            case Bool: 
            case Double: 
            case Int: 
            case String: 
            case Float32x4: 
            case Float64x2: 
            case Int32x4: 
            case StackTrace: {
                String string = instanceRef.getValueAsString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "getSimpleStringPresentation"));
                }
                return string;
            }
        }
        String string = "Instance of " + instanceRef.getClassRef().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/DartVmServiceListener", "getSimpleStringPresentation"));
        }
        return string;
    }
}

