/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.dartlang.vm.service.element.IsolateRef;
import org.jetbrains.annotations.NotNull;

public class IsolatesInfo {
    private final Map<String, IsolateInfo> myIsolateIdToInfoMap = Collections.synchronizedMap(new THashMap());

    public boolean addIsolate(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolatesInfo", "addIsolate"));
        }
        return this.myIsolateIdToInfoMap.put(isolateRef.getId(), new IsolateInfo(isolateRef.getId(), isolateRef.getName())) == null;
    }

    public void setBreakpointsSet(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolatesInfo", "setBreakpointsSet"));
        }
        IsolateInfo info = this.myIsolateIdToInfoMap.get(isolateRef.getId());
        if (info != null) {
            info.breakpointsSet = true;
        }
    }

    public void setShouldInitialResume(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolatesInfo", "setShouldInitialResume"));
        }
        IsolateInfo info = this.myIsolateIdToInfoMap.get(isolateRef.getId());
        if (info != null) {
            info.shouldInitialResume = true;
        }
    }

    public boolean getShouldInitialResume(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolatesInfo", "getShouldInitialResume"));
        }
        IsolateInfo info = this.myIsolateIdToInfoMap.get(isolateRef.getId());
        if (info != null) {
            return info.breakpointsSet && info.shouldInitialResume;
        }
        return false;
    }

    public void deleteIsolate(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolatesInfo", "deleteIsolate"));
        }
        this.myIsolateIdToInfoMap.remove(isolateRef.getId());
    }

    public Collection<IsolateInfo> getIsolateInfos() {
        return new ArrayList<IsolateInfo>(this.myIsolateIdToInfoMap.values());
    }

    public static class IsolateInfo {
        private final String myIsolateId;
        private final String myIsolateName;
        private boolean breakpointsSet;
        private boolean shouldInitialResume;

        public IsolateInfo(@NotNull String isolateId, @NotNull String isolateName) {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolatesInfo$IsolateInfo", "<init>"));
            }
            if (isolateName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateName", "com/jetbrains/lang/dart/ide/runner/server/vmService/IsolatesInfo$IsolateInfo", "<init>"));
            }
            this.breakpointsSet = false;
            this.shouldInitialResume = false;
            this.myIsolateId = isolateId;
            this.myIsolateName = isolateName;
        }

        public String getIsolateId() {
            return this.myIsolateId;
        }

        public String getIsolateName() {
            return this.myIsolateName;
        }
    }
}

