/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService;

import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceBreakpointHandler;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceListener;
import com.jetbrains.lang.dart.ide.runner.server.vmService.IsolatesInfo;
import com.jetbrains.lang.dart.ide.runner.server.vmService.VmServiceConsumers;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartAsyncMarkerFrame;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceEvaluator;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceStackFrame;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.EvaluateConsumer;
import org.dartlang.vm.service.consumer.EvaluateInFrameConsumer;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.StackConsumer;
import org.dartlang.vm.service.consumer.SuccessConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.Breakpoint;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.ErrorRef;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.ExceptionPauseMode;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.FrameKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.Stack;
import org.dartlang.vm.service.element.StepOption;
import org.dartlang.vm.service.element.Success;
import org.dartlang.vm.service.element.VM;
import org.dartlang.vm.service.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VmServiceWrapper
implements Disposable {
    public static final Logger LOG = Logger.getInstance((String)VmServiceWrapper.class.getName());
    private static final long RESPONSE_WAIT_TIMEOUT = 3000L;
    private final DartVmServiceDebugProcess myDebugProcess;
    private final VmService myVmService;
    private final DartVmServiceListener myVmServiceListener;
    private final IsolatesInfo myIsolatesInfo;
    private final DartVmServiceBreakpointHandler myBreakpointHandler;
    private final Alarm myRequestsScheduler;
    private long myVmServiceReceiverThreadId;
    @Nullable
    private StepOption myLatestStep;

    public VmServiceWrapper(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull VmService vmService, @NotNull DartVmServiceListener vmServiceListener, @NotNull IsolatesInfo isolatesInfo, @NotNull DartVmServiceBreakpointHandler breakpointHandler) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "<init>"));
        }
        if (vmService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmService", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "<init>"));
        }
        if (vmServiceListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmServiceListener", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "<init>"));
        }
        if (isolatesInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolatesInfo", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "<init>"));
        }
        if (breakpointHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointHandler", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "<init>"));
        }
        this.myDebugProcess = debugProcess;
        this.myVmService = vmService;
        this.myVmServiceListener = vmServiceListener;
        this.myIsolatesInfo = isolatesInfo;
        this.myBreakpointHandler = breakpointHandler;
        this.myRequestsScheduler = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public void dispose() {
    }

    private void addRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "addRequest"));
        }
        if (!this.myRequestsScheduler.isDisposed()) {
            this.myRequestsScheduler.addRequest(runnable, 0);
        }
    }

    @Nullable
    public StepOption getLatestStep() {
        return this.myLatestStep;
    }

    private void assertSyncRequestAllowed() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("EDT should not be blocked by waiting for for the answer from the Dart debugger");
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("Waiting for for the answer from the Dart debugger under read action may lead to EDT freeze");
        }
        if (this.myVmServiceReceiverThreadId == Thread.currentThread().getId()) {
            LOG.error("Synchronous requests must not be made in Web Socket listening thread: answer will never be received");
        }
    }

    public void handleDebuggerConnected() {
        this.streamListen("Debug", new VmServiceConsumers.SuccessConsumerWrapper(){

            @Override
            public void received(Success success) {
                VmServiceWrapper.this.myVmServiceReceiverThreadId = Thread.currentThread().getId();
                VmServiceWrapper.this.streamListen("Isolate", new VmServiceConsumers.SuccessConsumerWrapper(){

                    @Override
                    public void received(Success success) {
                        VmServiceWrapper.this.getVm(new VmServiceConsumers.VmConsumerWrapper(){

                            @Override
                            public void received(VM vm) {
                                if (vm.getIsolates().size() == 0) {
                                    Logging.getLogger().logError("No isolates found after VM start: " + vm.getIsolates().size());
                                }
                                for (final IsolateRef isolateRef : vm.getIsolates()) {
                                    VmServiceWrapper.this.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

                                        @Override
                                        public void received(Isolate isolate) {
                                            Event event = isolate.getPauseEvent();
                                            EventKind eventKind = event.getKind();
                                            VmServiceWrapper.this.handleIsolate(isolateRef, eventKind == EventKind.PauseStart);
                                            if (eventKind == EventKind.PauseBreakpoint || eventKind == EventKind.PauseException || eventKind == EventKind.PauseInterrupted) {
                                                VmServiceWrapper.this.myDebugProcess.isolateSuspended(isolateRef);
                                                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                                                    ElementList<Breakpoint> breakpoints = eventKind == EventKind.PauseBreakpoint ? event.getPauseBreakpoints() : null;
                                                    InstanceRef exception = eventKind == EventKind.PauseException ? event.getException() : null;
                                                    VmServiceWrapper.this.myVmServiceListener.onIsolatePaused(isolateRef, breakpoints, exception, event.getTopFrame(), event.getAtAsyncSuspension());
                                                });
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
        if (this.myDebugProcess.isRemoteDebug()) {
            this.streamListen("Stdout", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
            this.streamListen("Stderr", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        }
    }

    private void streamListen(@NotNull String streamId, @NotNull SuccessConsumer consumer) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "streamListen"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "streamListen"));
        }
        this.addRequest(() -> {
            if (streamId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$streamListen$0"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$streamListen$0"));
            }
            this.myVmService.streamListen(streamId, consumer);
        });
    }

    private void getVm(@NotNull VMConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getVm"));
        }
        this.addRequest(() -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getVm$1"));
            }
            this.myVmService.getVM(consumer);
        });
    }

    private void getIsolate(@NotNull String isolateId, @NotNull GetIsolateConsumer consumer) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getIsolate"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getIsolate"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getIsolate$2"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getIsolate$2"));
            }
            this.myVmService.getIsolate(isolateId, consumer);
        });
    }

    public void handleIsolate(final @NotNull IsolateRef isolateRef, boolean isolatePausedStart) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "handleIsolate"));
        }
        boolean newIsolate = this.myIsolatesInfo.addIsolate(isolateRef);
        if (isolatePausedStart) {
            this.myIsolatesInfo.setShouldInitialResume(isolateRef);
        }
        if (newIsolate) {
            this.addRequest(() -> {
                if (isolateRef == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$handleIsolate$3"));
                }
                this.myVmService.setExceptionPauseMode(isolateRef.getId(), ExceptionPauseMode.Unhandled, new VmServiceConsumers.SuccessConsumerWrapper(){

                    @Override
                    public void received(Success response) {
                        VmServiceWrapper.this.setInitialBreakpointsAndResume(isolateRef);
                    }
                });
            });
        } else {
            this.checkInitialResume(isolateRef);
        }
    }

    private void checkInitialResume(IsolateRef isolateRef) {
        if (this.myIsolatesInfo.getShouldInitialResume(isolateRef)) {
            this.resumeIsolate(isolateRef.getId(), null);
        }
    }

    private void setInitialBreakpointsAndResume(final @NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "setInitialBreakpointsAndResume"));
        }
        if (this.myDebugProcess.isRemoteDebug()) {
            if (this.myDebugProcess.myRemoteProjectRootUri == null) {
                this.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

                    @Override
                    public void received(Isolate isolate) {
                        VmServiceWrapper.this.myDebugProcess.guessRemoteProjectRoot(isolate.getLibraries());
                        VmServiceWrapper.this.doSetInitialBreakpointsAndResume(isolateRef);
                    }
                });
            } else {
                this.doSetInitialBreakpointsAndResume(isolateRef);
            }
        } else {
            this.doSetInitialBreakpointsAndResume(isolateRef);
        }
    }

    private void doSetInitialBreakpointsAndResume(@NotNull IsolateRef isolateRef) {
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "doSetInitialBreakpointsAndResume"));
        }
        this.doSetBreakpointsForIsolate(this.myBreakpointHandler.getXBreakpoints(), isolateRef.getId(), () -> {
            if (isolateRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$doSetInitialBreakpointsAndResume$4"));
            }
            this.myIsolatesInfo.setBreakpointsSet(isolateRef);
            this.checkInitialResume(isolateRef);
        });
    }

    private void doSetBreakpointsForIsolate(@NotNull Set<XLineBreakpoint<XBreakpointProperties>> xBreakpoints, final @NotNull String isolateId, final @Nullable Runnable onFinished) {
        if (xBreakpoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoints", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "doSetBreakpointsForIsolate"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "doSetBreakpointsForIsolate"));
        }
        if (xBreakpoints.isEmpty()) {
            if (onFinished != null) {
                onFinished.run();
            }
            return;
        }
        final AtomicInteger counter = new AtomicInteger(xBreakpoints.size());
        for (final XLineBreakpoint<XBreakpointProperties> xBreakpoint : xBreakpoints) {
            this.addBreakpoint(isolateId, xBreakpoint.getSourcePosition(), new VmServiceConsumers.BreakpointConsumerWrapper(){

                @Override
                void sourcePositionNotApplicable() {
                    this.checkDone();
                }

                @Override
                public void received(Breakpoint vmBreakpoint) {
                    VmServiceWrapper.this.myBreakpointHandler.vmBreakpointAdded((XLineBreakpoint<XBreakpointProperties>)xBreakpoint, isolateId, vmBreakpoint);
                    this.checkDone();
                }

                @Override
                public void onError(RPCError error) {
                    VmServiceWrapper.this.myBreakpointHandler.breakpointFailed((XLineBreakpoint<XBreakpointProperties>)xBreakpoint);
                    this.checkDone();
                }

                private void checkDone() {
                    if (counter.decrementAndGet() == 0 && onFinished != null) {
                        onFinished.run();
                    }
                }
            });
        }
    }

    public void addBreakpoint(@NotNull String isolateId, @Nullable XSourcePosition position, @NotNull VmServiceConsumers.BreakpointConsumerWrapper consumer) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "addBreakpoint"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "addBreakpoint"));
        }
        if (position == null || position.getFile().getFileType() != DartFileType.INSTANCE) {
            consumer.sourcePositionNotApplicable();
            return;
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$addBreakpoint$5"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$addBreakpoint$5"));
            }
            int line = position.getLine() + 1;
            for (String uri : this.myDebugProcess.getUrisForFile(position.getFile())) {
                this.myVmService.addBreakpointWithScriptUri(isolateId, uri, line, consumer);
            }
        });
    }

    public void addBreakpointForIsolates(final @NotNull XLineBreakpoint<XBreakpointProperties> xBreakpoint, @NotNull Collection<IsolatesInfo.IsolateInfo> isolateInfos) {
        if (xBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "addBreakpointForIsolates"));
        }
        if (isolateInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateInfos", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "addBreakpointForIsolates"));
        }
        for (final IsolatesInfo.IsolateInfo isolateInfo : isolateInfos) {
            this.addBreakpoint(isolateInfo.getIsolateId(), xBreakpoint.getSourcePosition(), new VmServiceConsumers.BreakpointConsumerWrapper(){

                @Override
                void sourcePositionNotApplicable() {
                }

                @Override
                public void received(Breakpoint vmBreakpoint) {
                    VmServiceWrapper.this.myBreakpointHandler.vmBreakpointAdded((XLineBreakpoint<XBreakpointProperties>)xBreakpoint, isolateInfo.getIsolateId(), vmBreakpoint);
                }

                @Override
                public void onError(RPCError error) {
                }
            });
        }
    }

    public void restoreBreakpointsForIsolate(@NotNull String isolateId, @Nullable Runnable onFinished) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "restoreBreakpointsForIsolate"));
        }
        this.myBreakpointHandler.removeAllVmBreakpoints(isolateId);
        this.doSetBreakpointsForIsolate(this.myBreakpointHandler.getXBreakpoints(), isolateId, onFinished);
    }

    public void addTemporaryBreakpoint(@NotNull XSourcePosition position, final @NotNull String isolateId) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "addTemporaryBreakpoint"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "addTemporaryBreakpoint"));
        }
        this.addBreakpoint(isolateId, position, new VmServiceConsumers.BreakpointConsumerWrapper(){

            @Override
            void sourcePositionNotApplicable() {
            }

            @Override
            public void received(Breakpoint vmBreakpoint) {
                VmServiceWrapper.this.myBreakpointHandler.temporaryBreakpointAdded(isolateId, vmBreakpoint);
            }

            @Override
            public void onError(RPCError error) {
            }
        });
    }

    public void removeBreakpoint(@NotNull String isolateId, @NotNull String vmBreakpointId) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "removeBreakpoint"));
        }
        if (vmBreakpointId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmBreakpointId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "removeBreakpoint"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$removeBreakpoint$6"));
            }
            if (vmBreakpointId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmBreakpointId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$removeBreakpoint$6"));
            }
            this.myVmService.removeBreakpoint(isolateId, vmBreakpointId, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        });
    }

    public void resumeIsolate(@NotNull String isolateId, @Nullable StepOption stepOption) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "resumeIsolate"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$resumeIsolate$7"));
            }
            this.myLatestStep = stepOption;
            this.myVmService.resume(isolateId, stepOption, null, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        });
    }

    public void dropFrame(@NotNull String isolateId, int frameIndex) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "dropFrame"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$dropFrame$8"));
            }
            this.myLatestStep = StepOption.Rewind;
            this.myVmService.resume(isolateId, StepOption.Rewind, frameIndex, new SuccessConsumer(){

                @Override
                public void onError(RPCError error) {
                    VmServiceWrapper.this.myDebugProcess.getSession().getConsoleView().print("Error from drop frame: " + error.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }

                @Override
                public void received(Success response) {
                }
            });
        });
    }

    public void pauseIsolate(@NotNull String isolateId) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "pauseIsolate"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$pauseIsolate$9"));
            }
            this.myVmService.pause(isolateId, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        });
    }

    public void computeStackFrames(final @NotNull String isolateId, final int firstFrameIndex, final @NotNull XExecutionStack.XStackFrameContainer container, final @Nullable InstanceRef exception) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "computeStackFrames"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "computeStackFrames"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$computeStackFrames$10"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$computeStackFrames$10"));
            }
            this.myVmService.getStack(isolateId, new StackConsumer(){

                @Override
                public void received(Stack vmStack) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (isolateId == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper$8", "lambda$received$0"));
                        }
                        if (container == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper$8", "lambda$received$0"));
                        }
                        InstanceRef exceptionToAddToFrame = exception;
                        ElementList<Frame> elementList = vmStack.getAwaiterFrames();
                        if (elementList == null && (elementList = vmStack.getAsyncCausalFrames()) == null) {
                            elementList = vmStack.getFrames();
                        }
                        ArrayList vmFrames = Lists.newArrayList(elementList);
                        ArrayList<XStackFrame> xStackFrames = new ArrayList<XStackFrame>(vmFrames.size());
                        for (Frame vmFrame : vmFrames) {
                            if (vmFrame.getKind() == FrameKind.AsyncSuspensionMarker) {
                                DartAsyncMarkerFrame markerFrame = new DartAsyncMarkerFrame();
                                xStackFrames.add(markerFrame);
                                continue;
                            }
                            DartVmServiceStackFrame stackFrame = new DartVmServiceStackFrame(VmServiceWrapper.this.myDebugProcess, isolateId, vmFrame, vmFrames, exceptionToAddToFrame);
                            stackFrame.setIsDroppableFrame(vmFrame.getKind() == FrameKind.Regular);
                            xStackFrames.add(stackFrame);
                            if (stackFrame.isInDartSdkPatchFile()) continue;
                            exceptionToAddToFrame = null;
                        }
                        container.addStackFrames(firstFrameIndex == 0 ? xStackFrames : xStackFrames.subList(firstFrameIndex, xStackFrames.size()), true);
                    });
                }

                @Override
                public void onError(RPCError error) {
                    container.errorOccurred(error.getMessage());
                }
            });
        });
    }

    @Nullable
    public Script getScriptSync(@NotNull String isolateId, @NotNull String scriptId) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getScriptSync"));
        }
        if (scriptId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getScriptSync"));
        }
        this.assertSyncRequestAllowed();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref resultRef = Ref.create();
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getScriptSync$11"));
            }
            if (scriptId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getScriptSync$11"));
            }
            this.myVmService.getObject(isolateId, scriptId, new GetObjectConsumer(){

                @Override
                public void received(Obj script) {
                    resultRef.set((Object)((Script)script));
                    semaphore.up();
                }

                @Override
                public void received(Sentinel response) {
                    semaphore.up();
                }

                @Override
                public void onError(RPCError error) {
                    semaphore.up();
                }
            });
        });
        semaphore.waitFor(3000L);
        return (Script)resultRef.get();
    }

    public void getObject(@NotNull String isolateId, @NotNull String objectId, @NotNull GetObjectConsumer consumer) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getObject"));
        }
        if (objectId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getObject"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getObject"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getObject$12"));
            }
            if (objectId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getObject$12"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getObject$12"));
            }
            this.myVmService.getObject(isolateId, objectId, consumer);
        });
    }

    public void getCollectionObject(@NotNull String isolateId, @NotNull String objectId, int offset, int count, @NotNull GetObjectConsumer consumer) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getCollectionObject"));
        }
        if (objectId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getCollectionObject"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "getCollectionObject"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getCollectionObject$13"));
            }
            if (objectId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getCollectionObject$13"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$getCollectionObject$13"));
            }
            this.myVmService.getObject(isolateId, objectId, offset, count, consumer);
        });
    }

    public void evaluateInFrame(final @NotNull String isolateId, @NotNull Frame vmFrame, @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInFrame"));
        }
        if (vmFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmFrame", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInFrame"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInFrame"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInFrame"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInFrame$14"));
            }
            if (vmFrame == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmFrame", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInFrame$14"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInFrame$14"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInFrame$14"));
            }
            this.myVmService.evaluateInFrame(isolateId, vmFrame.getIndex(), expression, new EvaluateInFrameConsumer(){

                @Override
                public void received(InstanceRef instanceRef) {
                    callback.evaluated((XValue)new DartVmServiceValue(VmServiceWrapper.this.myDebugProcess, isolateId, "result", instanceRef, null, null, false));
                }

                @Override
                public void received(ErrorRef errorRef) {
                    callback.errorOccurred(DartVmServiceEvaluator.getPresentableError(errorRef.getMessage()));
                }

                @Override
                public void onError(RPCError error) {
                    callback.errorOccurred(error.getMessage());
                }
            });
        });
    }

    public void evaluateInTargetContext(@NotNull String isolateId, @NotNull String targetId, @NotNull String expression, @NotNull EvaluateConsumer consumer) {
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInTargetContext"));
        }
        if (targetId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInTargetContext"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInTargetContext"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "evaluateInTargetContext"));
        }
        this.addRequest(() -> {
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInTargetContext$15"));
            }
            if (targetId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInTargetContext$15"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInTargetContext$15"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/runner/server/vmService/VmServiceWrapper", "lambda$evaluateInTargetContext$15"));
            }
            this.myVmService.evaluate(isolateId, targetId, expression, consumer);
        });
    }
}

