/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService.frame;

import com.google.gson.JsonElement;
import com.intellij.icons.AllIcons;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceValue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.Field;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;

class DartStaticFieldsGroup
extends XValueGroup {
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final String myIsolateId;
    @NotNull
    private final String myClassName;
    @NotNull
    private final SmartList<FieldRef> myFieldRefs;

    public DartStaticFieldsGroup(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull String className, @NotNull SmartList<FieldRef> fieldsRefs) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup", "<init>"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup", "<init>"));
        }
        if (fieldsRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldsRefs", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup", "<init>"));
        }
        super("static");
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myClassName = className;
        this.myFieldRefs = fieldsRefs;
    }

    @NotNull
    public String getSeparator() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup", "getSeparator"));
        }
        return "";
    }

    public String getComment() {
        return " members of " + this.myClassName;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Static;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup", "computeChildren"));
        }
        final AtomicInteger counter = new AtomicInteger(this.myFieldRefs.size());
        final XValueChildrenList list = new XValueChildrenList(this.myFieldRefs.size());
        for (final FieldRef fieldRef : this.myFieldRefs) {
            this.myDebugProcess.getVmServiceWrapper().getObject(this.myIsolateId, fieldRef.getId(), new GetObjectConsumer(){

                @Override
                public void received(Obj field) {
                    final InstanceRef instanceRef = ((Field)field).getStaticValue();
                    if ("@Instance".equals(instanceRef.getType())) {
                        list.add((XNamedValue)new DartVmServiceValue(DartStaticFieldsGroup.this.myDebugProcess, DartStaticFieldsGroup.this.myIsolateId, ((Field)field).getName(), instanceRef, null, fieldRef, false));
                    } else if ("Sentinel".equals(instanceRef.getType())) {
                        list.add(new XNamedValue(((Field)field).getName()){

                            public void computeSourcePosition(@NotNull XNavigatable navigatable) {
                                if (navigatable == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup$1$1", "computeSourcePosition"));
                                }
                                DartVmServiceValue.doComputeSourcePosition(DartStaticFieldsGroup.this.myDebugProcess, navigatable, DartStaticFieldsGroup.this.myIsolateId, fieldRef);
                            }

                            public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                                if (node == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup$1$1", "computePresentation"));
                                }
                                if (place == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartStaticFieldsGroup$1$1", "computePresentation"));
                                }
                                JsonElement valueAsString = instanceRef.getJson().get("valueAsString");
                                String value = valueAsString == null ? "not initialized" : valueAsString.getAsString();
                                node.setPresentation(AllIcons.Nodes.Field, null, value, false);
                            }
                        });
                    }
                    if (counter.decrementAndGet() == 0) {
                        if (list.size() == 0) {
                            node.setErrorMessage("Static fields not initialized yet");
                        } else {
                            node.addChildren(list, true);
                        }
                    }
                }

                @Override
                public void received(Sentinel sentinel) {
                    node.setErrorMessage(sentinel.getValueAsString());
                }

                @Override
                public void onError(RPCError error) {
                    node.setErrorMessage(error.getMessage());
                }
            });
        }
    }
}

