/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService.frame;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartFunctionBody;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartLongTemplateEntry;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.IDartBlock;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dartlang.vm.service.element.Frame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceEvaluator
extends XDebuggerEvaluator {
    private static final Pattern ERROR_PATTERN = Pattern.compile("Error:.* line \\d+ pos \\d+: (.+)");
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final String myIsolateId;
    @NotNull
    private final Frame myFrame;

    public DartVmServiceEvaluator(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull Frame vmFrame) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "<init>"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "<init>"));
        }
        if (vmFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmFrame", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "<init>"));
        }
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myFrame = vmFrame;
    }

    @NotNull
    public static String getPresentableError(@NotNull String rawError) {
        if (rawError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawError", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "getPresentableError"));
        }
        List lines = StringUtil.split((String)StringUtil.convertLineSeparators((String)rawError), (String)"\n");
        if (!lines.isEmpty()) {
            if ((((String)lines.get(0)).equals("Error: Unhandled exception:") || ((String)lines.get(0)).equals("Unhandled exception:")) && lines.size() > 1) {
                String string = (String)lines.get(1);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "getPresentableError"));
                }
                return string;
            }
            Matcher matcher = ERROR_PATTERN.matcher((CharSequence)lines.get(0));
            if (matcher.find()) {
                String string = matcher.group(1);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "getPresentableError"));
                }
                return string;
            }
        }
        if ("Cannot evaluate" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "getPresentableError"));
        }
        return "Cannot evaluate";
    }

    @Nullable
    public static ExpressionInfo getExpressionInfo(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "getExpressionInfo"));
        }
        DartReference reference = null;
        PsiElement element = contextElement;
        do {
            if (!(element instanceof DartReference)) continue;
            reference = (DartReference)element;
        } while ((element = element.getParent()) != null && !(element instanceof DartArgumentList) && !(element instanceof DartLongTemplateEntry) && !(element instanceof DartCallExpression) && !(element instanceof DartFunctionBody) && !(element instanceof IDartBlock));
        if (reference != null) {
            TextRange textRange = reference.getTextRange();
            int endOffset = contextElement.getTextRange().getEndOffset();
            if (textRange.getEndOffset() != endOffset) {
                textRange = new TextRange(textRange.getStartOffset(), endOffset);
            }
            return new ExpressionInfo(textRange);
        }
        PsiElement parent = contextElement.getParent();
        return parent instanceof DartId ? new ExpressionInfo(parent.getTextRange()) : null;
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "evaluate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "evaluate"));
        }
        this.myDebugProcess.getVmServiceWrapper().evaluateInFrame(this.myIsolateId, this.myFrame, expression, callback);
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "getExpressionInfoAtOffset"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceEvaluator", "getExpressionInfoAtOffset"));
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        PsiElement contextElement = psiFile == null ? null : psiFile.findElementAt(offset);
        return contextElement == null ? null : DartVmServiceEvaluator.getExpressionInfo(contextElement);
    }
}

