/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService.frame;

import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceStackFrame;
import java.util.Collections;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.InstanceRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceExecutionStack
extends XExecutionStack {
    private final DartVmServiceDebugProcess myDebugProcess;
    private final String myIsolateId;
    @Nullable
    private final XStackFrame myTopFrame;
    @Nullable
    private final InstanceRef myException;

    public DartVmServiceExecutionStack(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull String isolateName, @Nullable Frame topFrame, @Nullable InstanceRef exception) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceExecutionStack", "<init>"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceExecutionStack", "<init>"));
        }
        if (isolateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateName", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceExecutionStack", "<init>"));
        }
        super(debugProcess.isIsolateSuspended(isolateId) ? DartVmServiceExecutionStack.beautify(isolateName) : DartVmServiceExecutionStack.beautify(isolateName) + " (running)", topFrame != null ? AllIcons.Debugger.ThreadCurrent : (debugProcess.isIsolateSuspended(isolateId) ? AllIcons.Debugger.ThreadAtBreakpoint : AllIcons.Debugger.ThreadRunning));
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myException = exception;
        this.myTopFrame = topFrame == null ? null : new DartVmServiceStackFrame(debugProcess, isolateId, topFrame, null, exception);
    }

    @NotNull
    private static String beautify(@NotNull String isolateName) {
        if (isolateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateName", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceExecutionStack", "beautify"));
        }
        int index = isolateName.indexOf(".dart%22%20as%20test;");
        String string = index > 0 ? isolateName.substring(0, index + ".dart".length()) : isolateName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceExecutionStack", "beautify"));
        }
        return string;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        return this.myTopFrame;
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceExecutionStack", "computeStackFrames"));
        }
        if (this.myDebugProcess.isIsolateSuspended(this.myIsolateId)) {
            this.myDebugProcess.getVmServiceWrapper().computeStackFrames(this.myIsolateId, firstFrameIndex, container, this.myException);
        } else {
            container.addStackFrames(Collections.emptyList(), true);
        }
    }

    public String getIsolateId() {
        return this.myIsolateId;
    }
}

