/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService.frame;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartStaticFieldsGroup;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceEvaluator;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceValue;
import java.util.List;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.BoundVariable;
import org.dartlang.vm.service.element.ClassObj;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.FrameKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceStackFrame
extends XStackFrame {
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final String myIsolateId;
    @NotNull
    private final Frame myVmFrame;
    @Nullable
    private final InstanceRef myException;
    @Nullable
    private final XSourcePosition mySourcePosition;
    @Nullable
    private final List<Frame> myVmFrames;
    private boolean myIsDroppableFrame;

    public DartVmServiceStackFrame(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull Frame vmFrame, @Nullable List<Frame> vmFrames, @Nullable InstanceRef exception) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "<init>"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "<init>"));
        }
        if (vmFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmFrame", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "<init>"));
        }
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myVmFrame = vmFrame;
        this.myVmFrames = vmFrames;
        this.myException = exception;
        this.mySourcePosition = vmFrame.getLocation() == null ? null : debugProcess.getSourcePosition(isolateId, vmFrame.getLocation().getScript(), vmFrame.getLocation().getTokenPos());
    }

    @NotNull
    public String getIsolateId() {
        String string = this.myIsolateId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "getIsolateId"));
        }
        return string;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public int getFrameIndex() {
        return this.myVmFrames == null ? 0 : this.myVmFrames.indexOf(this.myVmFrame);
    }

    public void setIsDroppableFrame(boolean value) {
        this.myIsDroppableFrame = value;
    }

    private boolean isLastFrame() {
        if (this.myVmFrames == null) {
            return true;
        }
        return this.getFrameIndex() == this.myVmFrames.size() - 1;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "customizePresentation"));
        }
        String name = StringUtil.trimEnd((String)this.myVmFrame.getCode().getName(), (String)"=");
        boolean causal = this.myVmFrame.getKind() == FrameKind.AsyncCausal;
        component.append(name, causal ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.mySourcePosition != null) {
            String text = " (" + this.mySourcePosition.getFile().getName() + ":" + (this.mySourcePosition.getLine() + 1) + ")";
            component.append(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    @NotNull
    public Object getEqualityObject() {
        String string = this.myVmFrame.getLocation().getScript().getId() + ":" + this.myVmFrame.getCode().getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "getEqualityObject"));
        }
        return string;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        ElementList<BoundVariable> vars;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "computeChildren"));
        }
        if (this.myException != null) {
            DartVmServiceValue exception = new DartVmServiceValue(this.myDebugProcess, this.myIsolateId, "exception", this.myException, null, null, true);
            node.addChildren(XValueChildrenList.singleton((XNamedValue)exception), false);
        }
        if ((vars = this.myVmFrame.getVars()) == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        BoundVariable thisVar = null;
        for (BoundVariable var : vars) {
            if (!"this".equals(var.getName())) continue;
            thisVar = var;
            break;
        }
        this.addStaticFieldsIfPresentAndThenAllVars(node, thisVar, vars);
    }

    private void addStaticFieldsIfPresentAndThenAllVars(final @NotNull XCompositeNode node, @Nullable BoundVariable thisVar, final @NotNull ElementList<BoundVariable> vars) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "addStaticFieldsIfPresentAndThenAllVars"));
        }
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "addStaticFieldsIfPresentAndThenAllVars"));
        }
        if (thisVar == null) {
            this.addVars(node, vars);
            return;
        }
        this.myDebugProcess.getVmServiceWrapper().getObject(this.myIsolateId, thisVar.getValue().getClassRef().getId(), new GetObjectConsumer(){

            @Override
            public void received(Obj classObj) {
                SmartList staticFields = new SmartList();
                for (FieldRef fieldRef : ((ClassObj)classObj).getFields()) {
                    if (!fieldRef.isStatic()) continue;
                    staticFields.add((Object)fieldRef);
                }
                if (!staticFields.isEmpty()) {
                    XValueChildrenList list = new XValueChildrenList();
                    list.addTopGroup((XValueGroup)new DartStaticFieldsGroup(DartVmServiceStackFrame.this.myDebugProcess, DartVmServiceStackFrame.this.myIsolateId, ((ClassObj)classObj).getName(), (SmartList<FieldRef>)staticFields));
                    node.addChildren(list, false);
                }
                DartVmServiceStackFrame.this.addVars(node, vars);
            }

            @Override
            public void received(Sentinel sentinel) {
                node.setErrorMessage(sentinel.getValueAsString());
            }

            @Override
            public void onError(RPCError error) {
                node.setErrorMessage(error.getMessage());
            }
        });
    }

    private void addVars(@NotNull XCompositeNode node, @NotNull ElementList<BoundVariable> vars) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "addVars"));
        }
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceStackFrame", "addVars"));
        }
        XValueChildrenList childrenList = new XValueChildrenList(vars.size());
        for (BoundVariable var : vars) {
            InstanceRef value = var.getValue();
            if (value == null) continue;
            DartVmServiceValue.LocalVarSourceLocation varLocation = "this".equals(var.getName()) ? null : new DartVmServiceValue.LocalVarSourceLocation(this.myVmFrame.getLocation().getScript(), var.getDeclarationTokenPos());
            childrenList.add((XNamedValue)new DartVmServiceValue(this.myDebugProcess, this.myIsolateId, var.getName(), value, varLocation, null, false));
        }
        node.addChildren(childrenList, true);
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        return new DartVmServiceEvaluator(this.myDebugProcess, this.myIsolateId, this.myVmFrame);
    }

    public boolean isInDartSdkPatchFile() {
        return this.mySourcePosition != null && this.mySourcePosition.getFile() instanceof LightVirtualFile;
    }

    public boolean canDrop() {
        return this.myIsDroppableFrame && !this.isLastFrame();
    }

    public void dropFrame() {
        this.myDebugProcess.dropFrame(this);
    }
}

