/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService.frame;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.IsolatesInfo;
import com.jetbrains.lang.dart.ide.runner.server.vmService.frame.DartVmServiceExecutionStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dartlang.vm.service.element.Frame;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.IsolateRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceSuspendContext
extends XSuspendContext {
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private final DartVmServiceExecutionStack myActiveExecutionStack;
    private List<XExecutionStack> myExecutionStacks;
    private boolean myAtAsyncSuspension;

    public DartVmServiceSuspendContext(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull IsolateRef isolateRef, @NotNull Frame topFrame, @Nullable InstanceRef exception, boolean atAsyncSuspension) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceSuspendContext", "<init>"));
        }
        if (isolateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceSuspendContext", "<init>"));
        }
        if (topFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topFrame", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceSuspendContext", "<init>"));
        }
        this.myDebugProcess = debugProcess;
        this.myActiveExecutionStack = new DartVmServiceExecutionStack(debugProcess, isolateRef.getId(), isolateRef.getName(), topFrame, exception);
        this.myAtAsyncSuspension = atAsyncSuspension;
    }

    @NotNull
    public XExecutionStack getActiveExecutionStack() {
        DartVmServiceExecutionStack dartVmServiceExecutionStack = this.myActiveExecutionStack;
        if (dartVmServiceExecutionStack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceSuspendContext", "getActiveExecutionStack"));
        }
        return dartVmServiceExecutionStack;
    }

    public boolean getAtAsyncSuspension() {
        return this.myAtAsyncSuspension;
    }

    public void computeExecutionStacks(@NotNull XSuspendContext.XExecutionStackContainer container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceSuspendContext", "computeExecutionStacks"));
        }
        if (this.myExecutionStacks == null) {
            Collection<IsolatesInfo.IsolateInfo> isolateInfos = this.myDebugProcess.getIsolateInfos();
            this.myExecutionStacks = new ArrayList<XExecutionStack>(isolateInfos.size());
            for (IsolatesInfo.IsolateInfo isolateInfo : isolateInfos) {
                if (isolateInfo.getIsolateId().equals(this.myActiveExecutionStack.getIsolateId())) {
                    this.myExecutionStacks.add(this.myActiveExecutionStack);
                    continue;
                }
                this.myExecutionStacks.add(new DartVmServiceExecutionStack(this.myDebugProcess, isolateInfo.getIsolateId(), isolateInfo.getIsolateName(), null, null));
            }
        }
        container.addExecutionStack(this.myExecutionStacks, true);
    }
}

