/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.server.vmService.frame;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.lang.dart.ide.runner.server.vmService.DartVmServiceDebugProcess;
import com.jetbrains.lang.dart.ide.runner.server.vmService.VmServiceConsumers;
import javax.swing.Icon;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.BoundField;
import org.dartlang.vm.service.element.ClassObj;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Field;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.InstanceKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.MapAssociation;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.SourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartVmServiceValue
extends XNamedValue {
    private static final LayeredIcon FINAL_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.FinalMark});
    private static final LayeredIcon STATIC_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon STATIC_FINAL_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.StaticMark, AllIcons.Nodes.FinalMark});
    @NotNull
    private final DartVmServiceDebugProcess myDebugProcess;
    @NotNull
    private String myIsolateId;
    @NotNull
    private final InstanceRef myInstanceRef;
    @Nullable
    private final LocalVarSourceLocation myLocalVarSourceLocation;
    @Nullable
    private final FieldRef myFieldRef;
    private final boolean myIsException;
    private Ref<Integer> myCollectionChildrenAlreadyShown;

    public DartVmServiceValue(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull String isolateId, @NotNull String name, @NotNull InstanceRef instanceRef, @Nullable LocalVarSourceLocation localVarSourceLocation, @Nullable FieldRef fieldRef, boolean isException) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "<init>"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "<init>"));
        }
        if (instanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "<init>"));
        }
        super(name);
        this.myCollectionChildrenAlreadyShown = new Ref((Object)0);
        this.myDebugProcess = debugProcess;
        this.myIsolateId = isolateId;
        this.myInstanceRef = instanceRef;
        this.myLocalVarSourceLocation = localVarSourceLocation;
        this.myFieldRef = fieldRef;
        this.myIsException = isException;
    }

    public boolean canNavigateToSource() {
        return this.myLocalVarSourceLocation != null || this.myFieldRef != null;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeSourcePosition"));
        }
        if (this.myLocalVarSourceLocation != null) {
            DartVmServiceValue.reportSourcePosition(this.myDebugProcess, navigatable, this.myIsolateId, this.myLocalVarSourceLocation.myScriptRef, this.myLocalVarSourceLocation.myTokenPos);
        } else if (this.myFieldRef != null) {
            DartVmServiceValue.doComputeSourcePosition(this.myDebugProcess, navigatable, this.myIsolateId, this.myFieldRef);
        } else {
            navigatable.setSourcePosition(null);
        }
    }

    static void doComputeSourcePosition(final @NotNull DartVmServiceDebugProcess debugProcess, final @NotNull XNavigatable navigatable, final @NotNull String isolateId, @NotNull FieldRef fieldRef) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "doComputeSourcePosition"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "doComputeSourcePosition"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "doComputeSourcePosition"));
        }
        if (fieldRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "doComputeSourcePosition"));
        }
        debugProcess.getVmServiceWrapper().getObject(isolateId, fieldRef.getId(), new GetObjectConsumer(){

            @Override
            public void received(Obj field) {
                SourceLocation location = ((Field)field).getLocation();
                DartVmServiceValue.reportSourcePosition(debugProcess, navigatable, isolateId, location == null ? null : location.getScript(), location == null ? -1 : location.getTokenPos());
            }

            @Override
            public void received(Sentinel sentinel) {
                navigatable.setSourcePosition(null);
            }

            @Override
            public void onError(RPCError error) {
                navigatable.setSourcePosition(null);
            }
        });
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public void computeTypeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeTypeSourcePosition"));
        }
        this.myDebugProcess.getVmServiceWrapper().getObject(this.myIsolateId, this.myInstanceRef.getClassRef().getId(), new GetObjectConsumer(){

            @Override
            public void received(Obj classObj) {
                SourceLocation location = ((ClassObj)classObj).getLocation();
                DartVmServiceValue.reportSourcePosition(DartVmServiceValue.this.myDebugProcess, navigatable, DartVmServiceValue.this.myIsolateId, location == null ? null : location.getScript(), location == null ? -1 : location.getTokenPos());
            }

            @Override
            public void received(Sentinel response) {
                navigatable.setSourcePosition(null);
            }

            @Override
            public void onError(RPCError error) {
                navigatable.setSourcePosition(null);
            }
        });
    }

    private static void reportSourcePosition(@NotNull DartVmServiceDebugProcess debugProcess, @NotNull XNavigatable navigatable, @NotNull String isolateId, @Nullable ScriptRef script, int tokenPos) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "reportSourcePosition"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "reportSourcePosition"));
        }
        if (isolateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "reportSourcePosition"));
        }
        if (script == null || tokenPos <= 0) {
            navigatable.setSourcePosition(null);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "lambda$reportSourcePosition$1"));
            }
            if (isolateId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolateId", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "lambda$reportSourcePosition$1"));
            }
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "lambda$reportSourcePosition$1"));
            }
            XSourcePosition sourcePosition = debugProcess.getSourcePosition(isolateId, script, tokenPos);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (navigatable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "lambda$null$0"));
                }
                navigatable.setSourcePosition(sourcePosition);
            });
        });
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computePresentation"));
        }
        if (this.computeVarHavingStringValuePresentation(node)) {
            return;
        }
        if (this.computeRegExpPresentation(node)) {
            return;
        }
        if (this.computeMapPresentation(node)) {
            return;
        }
        if (this.computeListPresentation(node)) {
            return;
        }
        this.computeDefaultPresentation(node);
    }

    private Icon getIcon() {
        if (this.myIsException) {
            return AllIcons.Debugger.Db_exception_breakpoint;
        }
        if (this.myFieldRef != null) {
            if (this.myFieldRef.isStatic() && (this.myFieldRef.isFinal() || this.myFieldRef.isConst())) {
                return STATIC_FINAL_FIELD_ICON;
            }
            if (this.myFieldRef.isStatic()) {
                return STATIC_FIELD_ICON;
            }
            if (this.myFieldRef.isFinal() || this.myFieldRef.isConst()) {
                return FINAL_FIELD_ICON;
            }
            return AllIcons.Nodes.Field;
        }
        InstanceKind kind = this.myInstanceRef.getKind();
        if (kind == InstanceKind.Map || DartVmServiceValue.isListKind(kind)) {
            return AllIcons.Debugger.Db_array;
        }
        if (kind == InstanceKind.Null || kind == InstanceKind.Bool || kind == InstanceKind.Double || kind == InstanceKind.Int || kind == InstanceKind.String) {
            return AllIcons.Debugger.Db_primitive;
        }
        return AllIcons.Debugger.Value;
    }

    private boolean computeVarHavingStringValuePresentation(@NotNull XValueNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeVarHavingStringValuePresentation"));
        }
        switch (this.myInstanceRef.getKind()) {
            case Null: 
            case Bool: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new XKeywordValuePresentation(this.myInstanceRef.getValueAsString()), false);
                break;
            }
            case Double: 
            case Int: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new XNumericValuePresentation(this.myInstanceRef.getValueAsString()), false);
                break;
            }
            case String: {
                String presentableValue = StringUtil.replace((String)this.myInstanceRef.getValueAsString(), (String)"\"", (String)"\\\"");
                node.setPresentation(this.getIcon(), (XValuePresentation)new XStringValuePresentation(presentableValue), false);
                if (!this.myInstanceRef.getValueAsStringIsTruncated()) break;
                this.addFullStringValueEvaluator(node, this.myInstanceRef);
                break;
            }
            case Float32x4: 
            case Float64x2: 
            case Int32x4: 
            case StackTrace: {
                node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator("Click to see stack trace...", this.myInstanceRef.getValueAsString()));
                node.setPresentation(this.getIcon(), this.myInstanceRef.getClassRef().getName(), "", true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void addFullStringValueEvaluator(@NotNull XValueNode node, final @NotNull InstanceRef stringInstanceRef) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addFullStringValueEvaluator"));
        }
        if (stringInstanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringInstanceRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addFullStringValueEvaluator"));
        }
        assert (stringInstanceRef.getKind() == InstanceKind.String) : stringInstanceRef;
        node.setFullValueEvaluator(new XFullValueEvaluator(){

            public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue$3", "startEvaluation"));
                }
                DartVmServiceValue.this.myDebugProcess.getVmServiceWrapper().getObject(DartVmServiceValue.this.myIsolateId, stringInstanceRef.getId(), new GetObjectConsumer(){

                    @Override
                    public void received(Obj instance) {
                        assert (instance instanceof Instance && ((Instance)instance).getKind() == InstanceKind.String) : instance;
                        callback.evaluated(((Instance)instance).getValueAsString());
                    }

                    @Override
                    public void received(Sentinel response) {
                        callback.errorOccurred(response.getValueAsString());
                    }

                    @Override
                    public void onError(RPCError error) {
                        callback.errorOccurred(error.getMessage());
                    }
                });
            }
        });
    }

    private boolean computeRegExpPresentation(@NotNull XValueNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeRegExpPresentation"));
        }
        if (this.myInstanceRef.getKind() == InstanceKind.RegExp) {
            InstanceRef pattern = this.myInstanceRef.getPattern();
            assert (pattern.getKind() == InstanceKind.String) : pattern;
            String patternString = StringUtil.replace((String)pattern.getValueAsString(), (String)"\"", (String)"\\\"");
            node.setPresentation(this.getIcon(), (XValuePresentation)new XStringValuePresentation(patternString){

                @Nullable
                public String getType() {
                    return DartVmServiceValue.this.myInstanceRef.getClassRef().getName();
                }
            }, true);
            if (pattern.getValueAsStringIsTruncated()) {
                this.addFullStringValueEvaluator(node, pattern);
            }
            return true;
        }
        return false;
    }

    private boolean computeMapPresentation(@NotNull XValueNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeMapPresentation"));
        }
        if (this.myInstanceRef.getKind() == InstanceKind.Map) {
            String value = "size = " + this.myInstanceRef.getLength();
            node.setPresentation(this.getIcon(), this.myInstanceRef.getClassRef().getName(), value, this.myInstanceRef.getLength() > 0);
            return true;
        }
        return false;
    }

    private boolean computeListPresentation(@NotNull XValueNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeListPresentation"));
        }
        if (DartVmServiceValue.isListKind(this.myInstanceRef.getKind())) {
            String value = "size = " + this.myInstanceRef.getLength();
            node.setPresentation(this.getIcon(), this.myInstanceRef.getClassRef().getName(), value, this.myInstanceRef.getLength() > 0);
            return true;
        }
        return false;
    }

    private void computeDefaultPresentation(final @NotNull XValueNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeDefaultPresentation"));
        }
        this.myDebugProcess.getVmServiceWrapper().evaluateInTargetContext(this.myIsolateId, this.myInstanceRef.getId(), "toString()", new VmServiceConsumers.EvaluateConsumerWrapper(){

            @Override
            public void received(InstanceRef toStringInstanceRef) {
                if (toStringInstanceRef.getKind() == InstanceKind.String) {
                    String string = toStringInstanceRef.getValueAsString();
                    if (string.equals("Instance of '" + DartVmServiceValue.this.myInstanceRef.getClassRef().getName() + "'")) {
                        this.noGoodResult();
                    } else {
                        node.setPresentation(DartVmServiceValue.this.getIcon(), DartVmServiceValue.this.myInstanceRef.getClassRef().getName(), string, true);
                    }
                } else {
                    this.noGoodResult();
                }
            }

            @Override
            public void noGoodResult() {
                node.setPresentation(DartVmServiceValue.this.getIcon(), DartVmServiceValue.this.myInstanceRef.getClassRef().getName(), "", true);
            }
        });
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeChildren"));
        }
        if (this.myInstanceRef.getKind() == InstanceKind.Null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        if (DartVmServiceValue.isListKind(this.myInstanceRef.getKind()) || this.myInstanceRef.getKind() == InstanceKind.Map) {
            this.computeCollectionChildren(node);
        } else {
            this.myDebugProcess.getVmServiceWrapper().getObject(this.myIsolateId, this.myInstanceRef.getId(), new GetObjectConsumer(){

                @Override
                public void received(Obj instance) {
                    DartVmServiceValue.this.addFields(node, ((Instance)instance).getFields());
                }

                @Override
                public void received(Sentinel sentinel) {
                    node.setErrorMessage(sentinel.getValueAsString());
                }

                @Override
                public void onError(RPCError error) {
                    node.setErrorMessage(error.getMessage());
                }
            });
        }
    }

    private void computeCollectionChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "computeCollectionChildren"));
        }
        final int offset = (Integer)this.myCollectionChildrenAlreadyShown.get();
        final int count = Math.min(this.myInstanceRef.getLength() - offset, 100);
        this.myDebugProcess.getVmServiceWrapper().getCollectionObject(this.myIsolateId, this.myInstanceRef.getId(), offset, count, new GetObjectConsumer(){

            @Override
            public void received(Obj instance) {
                if (DartVmServiceValue.isListKind(DartVmServiceValue.this.myInstanceRef.getKind())) {
                    DartVmServiceValue.this.addListChildren(node, ((Instance)instance).getElements());
                } else if (DartVmServiceValue.this.myInstanceRef.getKind() == InstanceKind.Map) {
                    DartVmServiceValue.this.addMapChildren(node, ((Instance)instance).getAssociations());
                } else assert (false) : DartVmServiceValue.access$500(DartVmServiceValue.this).getKind();
                DartVmServiceValue.this.myCollectionChildrenAlreadyShown.set((Object)((Integer)DartVmServiceValue.this.myCollectionChildrenAlreadyShown.get() + count));
                if (offset + count < DartVmServiceValue.this.myInstanceRef.getLength()) {
                    node.tooManyChildren(DartVmServiceValue.this.myInstanceRef.getLength() - offset - count);
                }
            }

            @Override
            public void received(Sentinel sentinel) {
                node.setErrorMessage(sentinel.getValueAsString());
            }

            @Override
            public void onError(RPCError error) {
                node.setErrorMessage(error.getMessage());
            }
        });
    }

    private void addListChildren(@NotNull XCompositeNode node, @NotNull ElementList<InstanceRef> listElements) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addListChildren"));
        }
        if (listElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listElements", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addListChildren"));
        }
        XValueChildrenList childrenList = new XValueChildrenList(listElements.size());
        int index = (Integer)this.myCollectionChildrenAlreadyShown.get();
        for (InstanceRef listElement : listElements) {
            childrenList.add((XNamedValue)new DartVmServiceValue(this.myDebugProcess, this.myIsolateId, String.valueOf(index++), listElement, null, null, false));
        }
        node.addChildren(childrenList, true);
    }

    private void addMapChildren(@NotNull XCompositeNode node, @NotNull ElementList<MapAssociation> mapAssociations) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addMapChildren"));
        }
        if (mapAssociations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapAssociations", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addMapChildren"));
        }
        XValueChildrenList childrenList = new XValueChildrenList(mapAssociations.size());
        int index = (Integer)this.myCollectionChildrenAlreadyShown.get();
        for (MapAssociation mapAssociation : mapAssociations) {
            final InstanceRef keyInstanceRef = mapAssociation.getKey();
            final InstanceRef valueInstanceRef = mapAssociation.getValue();
            childrenList.add(String.valueOf(index++), new XValue(){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue$8", "computePresentation"));
                    }
                    if (place == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue$8", "computePresentation"));
                    }
                    String value = DartVmServiceValue.getShortPresentableValue(keyInstanceRef) + " -> " + DartVmServiceValue.getShortPresentableValue(valueInstanceRef);
                    node.setPresentation(AllIcons.Debugger.Value, "map entry", value, true);
                }

                public void computeChildren(@NotNull XCompositeNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue$8", "computeChildren"));
                    }
                    DartVmServiceValue key = new DartVmServiceValue(DartVmServiceValue.this.myDebugProcess, DartVmServiceValue.this.myIsolateId, "key", keyInstanceRef, null, null, false);
                    DartVmServiceValue value = new DartVmServiceValue(DartVmServiceValue.this.myDebugProcess, DartVmServiceValue.this.myIsolateId, "value", valueInstanceRef, null, null, false);
                    node.addChildren(XValueChildrenList.singleton((XNamedValue)key), false);
                    node.addChildren(XValueChildrenList.singleton((XNamedValue)value), true);
                }
            });
        }
        node.addChildren(childrenList, true);
    }

    private void addFields(@NotNull XCompositeNode node, @NotNull ElementList<BoundField> fields) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addFields"));
        }
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "addFields"));
        }
        XValueChildrenList childrenList = new XValueChildrenList(fields.size());
        for (BoundField field : fields) {
            InstanceRef value = field.getValue();
            if (value == null) continue;
            childrenList.add((XNamedValue)new DartVmServiceValue(this.myDebugProcess, this.myIsolateId, field.getDecl().getName(), value, null, field.getDecl(), false));
        }
        node.addChildren(childrenList, true);
    }

    @NotNull
    private static String getShortPresentableValue(@NotNull InstanceRef instanceRef) {
        if (instanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "getShortPresentableValue"));
        }
        switch (instanceRef.getKind()) {
            case String: {
                String string = instanceRef.getValueAsString();
                if (string.length() > 103) {
                    string = string.substring(0, 100) + "...";
                }
                String string2 = "\"" + StringUtil.replace((String)string, (String)"\"", (String)"\\\"") + "\"";
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "getShortPresentableValue"));
                }
                return string2;
            }
            case Null: 
            case Bool: 
            case Double: 
            case Int: 
            case Float32x4: 
            case Float64x2: 
            case Int32x4: {
                String string = instanceRef.getValueAsString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "getShortPresentableValue"));
                }
                return string;
            }
        }
        String string = "[" + instanceRef.getClassRef().getName() + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "getShortPresentableValue"));
        }
        return string;
    }

    private static boolean isListKind(@NotNull InstanceKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "isListKind"));
        }
        return kind == InstanceKind.List || kind == InstanceKind.Uint8ClampedList || kind == InstanceKind.Uint8List || kind == InstanceKind.Uint16List || kind == InstanceKind.Uint32List || kind == InstanceKind.Uint64List || kind == InstanceKind.Int8List || kind == InstanceKind.Int16List || kind == InstanceKind.Int32List || kind == InstanceKind.Int64List || kind == InstanceKind.Float32List || kind == InstanceKind.Float64List || kind == InstanceKind.Int32x4List || kind == InstanceKind.Float32x4List || kind == InstanceKind.Float64x2List;
    }

    @NotNull
    public InstanceRef getInstanceRef() {
        InstanceRef instanceRef = this.myInstanceRef;
        if (instanceRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue", "getInstanceRef"));
        }
        return instanceRef;
    }

    static class LocalVarSourceLocation {
        @NotNull
        private final ScriptRef myScriptRef;
        private final int myTokenPos;

        public LocalVarSourceLocation(@NotNull ScriptRef scriptRef, int tokenPos) {
            if (scriptRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptRef", "com/jetbrains/lang/dart/ide/runner/server/vmService/frame/DartVmServiceValue$LocalVarSourceLocation", "<init>"));
            }
            this.myScriptRef = scriptRef;
            this.myTokenPos = tokenPos;
        }
    }
}

