/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunningState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestRerunner
implements RunProfileState {
    private final ExecutionEnvironment environment;
    private final List<AbstractTestProxy> failedTests;

    DartTestRerunner(@NotNull ExecutionEnvironment env, @NotNull List<AbstractTestProxy> tests) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/ide/runner/test/DartTestRerunner", "<init>"));
        }
        if (tests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tests", "com/jetbrains/lang/dart/ide/runner/test/DartTestRerunner", "<init>"));
        }
        this.environment = env;
        this.failedTests = tests;
    }

    ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/lang/dart/ide/runner/test/DartTestRerunner", "execute"));
        }
        DartTestRunningState state = new DartTestRunningState(this.environment);
        DartTestRunnerParameters params = state.getParameters();
        params.setScope(DartTestRunnerParameters.Scope.MULTIPLE_NAMES);
        params.setTestName(this.computeTestNameRegexp());
        return state.execute(executor, runner);
    }

    @NotNull
    Module[] getModulesToCompile() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/test/DartTestRerunner", "getModulesToCompile"));
        }
        return Module.EMPTY_ARRAY;
    }

    private String computeTestNameRegexp() {
        StringBuilder buf = new StringBuilder();
        for (AbstractTestProxy test : this.failedTests) {
            assert (test instanceof SMTestProxy) : test.getClass().getName();
            TestStateInfo.Magnitude magnitude = ((SMTestProxy)test).getMagnitudeInfo();
            if (test.getParent() == null || ((SMTestProxy)test).isSuite() || !test.isLeaf() || magnitude != TestStateInfo.Magnitude.FAILED_INDEX && magnitude != TestStateInfo.Magnitude.ERROR_INDEX && magnitude != TestStateInfo.Magnitude.TERMINATED_INDEX) continue;
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(DartTestRerunner.buildFullTestName(test));
        }
        return buf.toString();
    }

    private static String buildFullTestName(@NotNull AbstractTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/jetbrains/lang/dart/ide/runner/test/DartTestRerunner", "buildFullTestName"));
        }
        StringBuffer fullName = new StringBuffer();
        DartTestRerunner.buildFullTestName(test.getParent(), fullName);
        fullName.append(test.getName());
        return StringUtil.escapeToRegexp((String)fullName.toString());
    }

    private static void buildFullTestName(AbstractTestProxy test, StringBuffer fullName) {
        if (test == null) {
            return;
        }
        DartTestRerunner.buildFullTestName(test.getParent(), fullName);
        String url = test.getLocationUrl();
        if (url == null || url.endsWith(",[]")) {
            return;
        }
        String name = test.getName();
        if (name == null || name.equals("[root]")) {
            return;
        }
        fullName.append(name);
        fullName.append(' ');
    }
}

