/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.base.DartRunConfigurationBase;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunningState;
import com.jetbrains.lang.dart.ide.runner.test.ui.DartTestConfigurationEditorForm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestRunConfiguration
extends DartRunConfigurationBase {
    @NotNull
    private DartTestRunnerParameters myRunnerParameters = new DartTestRunnerParameters();

    protected DartTestRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @NotNull
    public DartTestRunnerParameters getRunnerParameters() {
        DartTestRunnerParameters dartTestRunnerParameters = this.myRunnerParameters;
        if (dartTestRunnerParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfiguration", "getRunnerParameters"));
        }
        return dartTestRunnerParameters;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        DartTestConfigurationEditorForm dartTestConfigurationEditorForm = new DartTestConfigurationEditorForm(this.getProject());
        if (dartTestConfigurationEditorForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfiguration", "getConfigurationEditor"));
        }
        return dartTestConfigurationEditorForm;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfiguration", "getState"));
        }
        return new DartTestRunningState(env);
    }

    @Nullable
    public String suggestedName() {
        String path = this.myRunnerParameters.getFilePath();
        String groupOrTestName = this.myRunnerParameters.getTestName();
        if (path == null) {
            return null;
        }
        String fileOrDirName = PathUtil.getFileName((String)path);
        switch (this.myRunnerParameters.getScope()) {
            case GROUP_OR_TEST_BY_NAME: {
                if (groupOrTestName != null) {
                    return DartBundle.message("test.0.in.1", groupOrTestName, fileOrDirName);
                }
            }
            case FILE: {
                return DartBundle.message("all.tests.in.0", fileOrDirName);
            }
            case FOLDER: {
                String parentPath;
                String parentDirName;
                String dirName = "test".equals(fileOrDirName) ? ((parentDirName = PathUtil.getFileName((String)(parentPath = PathUtil.getParentPath((String)path)))).isEmpty() ? fileOrDirName : parentDirName + "/" + fileOrDirName) : fileOrDirName;
                return DartBundle.message("all.tests.in.0", dirName);
            }
        }
        return null;
    }

    public RunConfiguration clone() {
        DartTestRunConfiguration clone = (DartTestRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }
}

