/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRuntimeConfigurationProducer;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfigurationType;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunnerParameters;
import com.jetbrains.lang.dart.ide.runner.util.TestUtil;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartTestRunConfigurationProducer
extends RunConfigurationProducer<DartTestRunConfiguration> {
    public DartTestRunConfigurationProducer() {
        super((ConfigurationType)DartTestRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(@NotNull DartTestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupConfigurationFromContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupConfigurationFromContext"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupConfigurationFromContext"));
        }
        PsiElement location = context.getPsiLocation();
        boolean ok = location instanceof PsiDirectory ? DartTestRunConfigurationProducer.setupRunnerParametersForFolderIfApplicable(configuration.getProject(), configuration.getRunnerParameters(), ((PsiDirectory)location).getVirtualFile()) : DartTestRunConfigurationProducer.setupRunnerParametersForFileIfApplicable(configuration.getRunnerParameters(), context, sourceElement);
        if (ok) {
            configuration.setGeneratedName();
        }
        return ok;
    }

    public boolean isConfigurationFromContext(@NotNull DartTestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement testElement;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "isConfigurationFromContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "isConfigurationFromContext"));
        }
        DartTestRunnerParameters existingParams = configuration.getRunnerParameters();
        DartTestRunnerParameters paramsFromContext = new DartTestRunnerParameters();
        PsiElement location = context.getPsiLocation();
        if (location instanceof PsiDirectory ? !DartTestRunConfigurationProducer.setupRunnerParametersForFolder(paramsFromContext, ((PsiDirectory)location).getVirtualFile()) : (testElement = TestUtil.findTestElement(location)) == null || !DartTestRunConfigurationProducer.setupRunnerParametersForFile(paramsFromContext, testElement)) {
            return false;
        }
        return Comparing.equal((String)existingParams.getFilePath(), (String)paramsFromContext.getFilePath()) && Comparing.equal((Object)((Object)existingParams.getScope()), (Object)((Object)paramsFromContext.getScope())) && (existingParams.getScope() != DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME || Comparing.equal((String)existingParams.getTestName(), (String)paramsFromContext.getTestName()));
    }

    private static boolean setupRunnerParametersForFolderIfApplicable(@NotNull Project project, @NotNull DartTestRunnerParameters params, @NotNull VirtualFile dir) {
        VirtualFile testDir;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFolderIfApplicable"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFolderIfApplicable"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFolderIfApplicable"));
        }
        DartUrlResolver urlResolver = DartUrlResolver.getInstance(project, dir);
        VirtualFile dartTestLib = urlResolver.findFileByDartUrl("package:test/test.dart");
        if (dartTestLib == null) {
            return false;
        }
        VirtualFile pubspec = urlResolver.getPubspecYamlFile();
        VirtualFile rootDir = pubspec == null ? null : pubspec.getParent();
        VirtualFile virtualFile = testDir = rootDir == null ? null : rootDir.findChild("test");
        if (testDir == null || !testDir.isDirectory()) {
            return false;
        }
        if (!rootDir.equals(dir) && !VfsUtilCore.isAncestor((VirtualFile)testDir, (VirtualFile)dir, (boolean)false)) {
            return false;
        }
        return DartTestRunConfigurationProducer.setupRunnerParametersForFolder(params, dir);
    }

    private static boolean setupRunnerParametersForFolder(@NotNull DartTestRunnerParameters params, @NotNull VirtualFile dir) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFolder"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFolder"));
        }
        if ("test".equals(dir.getName()) && dir.findChild("pubspec.yaml") == null && dir.getParent().findChild("pubspec.yaml") != null) {
            dir = dir.getParent();
        }
        params.setScope(DartTestRunnerParameters.Scope.FOLDER);
        params.setFilePath(dir.getPath());
        return true;
    }

    private static boolean setupRunnerParametersForFileIfApplicable(@NotNull DartTestRunnerParameters params, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFileIfApplicable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFileIfApplicable"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFileIfApplicable"));
        }
        VirtualFile dartFile = DartCommandLineRuntimeConfigurationProducer.getRunnableDartFileFromContext(context, false);
        if (dartFile == null || !DartTestRunConfigurationProducer.isFileInTestDirAndTestPackageExists(context.getProject(), dartFile)) {
            return false;
        }
        PsiElement testElement = TestUtil.findTestElement(context.getPsiLocation());
        if (testElement == null || !DartTestRunConfigurationProducer.setupRunnerParametersForFile(params, testElement)) {
            return false;
        }
        sourceElement.set((Object)testElement);
        return true;
    }

    public static boolean isFileInTestDirAndTestPackageExists(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "isFileInTestDirAndTestPackageExists"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "isFileInTestDirAndTestPackageExists"));
        }
        DartUrlResolver urlResolver = DartUrlResolver.getInstance(project, file);
        VirtualFile dartTestLib = urlResolver.findFileByDartUrl("package:test/test.dart");
        if (dartTestLib == null) {
            return false;
        }
        VirtualFile pubspec = urlResolver.getPubspecYamlFile();
        VirtualFile rootDir = pubspec == null ? null : pubspec.getParent();
        VirtualFile testDir = rootDir == null ? null : rootDir.findChild("test");
        return testDir != null && testDir.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)testDir, (VirtualFile)file, (boolean)true);
    }

    private static boolean setupRunnerParametersForFile(@NotNull DartTestRunnerParameters runnerParams, @NotNull PsiElement psiElement) {
        if (runnerParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerParams", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFile"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunConfigurationProducer", "setupRunnerParametersForFile"));
        }
        if (psiElement instanceof DartCallExpression) {
            String testName = TestUtil.findGroupOrTestName((DartCallExpression)psiElement);
            List<VirtualFile> virtualFiles = DartResolveUtil.findLibrary(psiElement.getContainingFile());
            if (testName == null || virtualFiles.isEmpty()) {
                return false;
            }
            runnerParams.setTestName(testName);
            runnerParams.setScope(DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME);
            VirtualFile dartFile = virtualFiles.iterator().next();
            String dartFilePath = dartFile.getPath();
            runnerParams.setFilePath(dartFilePath);
            return true;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile instanceof DartFile) {
            VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile((PsiFile)((DartFile)psiElement));
            if (virtualFile == null || !DartResolveUtil.isLibraryRoot((PsiFile)((DartFile)psiElement))) {
                return false;
            }
            runnerParams.setTestName(DartResolveUtil.getLibraryName((PsiFile)((DartFile)psiElement)));
            runnerParams.setScope(DartTestRunnerParameters.Scope.FILE);
            String dartFilePath = FileUtil.toSystemIndependentName((String)virtualFile.getPath());
            runnerParams.setFilePath(dartFilePath);
            return true;
        }
        return false;
    }
}

