/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestRunnerParameters
extends DartCommandLineRunnerParameters
implements Cloneable {
    @NotNull
    private Scope myScope = Scope.FILE;
    @Nullable
    private String myTestName = null;
    @Nullable
    private String myTargetName = null;
    @Nullable
    private String myTestRunnerOptions = null;

    @NotNull
    public Scope getScope() {
        Scope scope = this.myScope;
        if (scope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunnerParameters", "getScope"));
        }
        return scope;
    }

    public void setScope(Scope scope) {
        if (scope != null) {
            this.myScope = scope == Scope.GROUP || scope == Scope.METHOD ? Scope.GROUP_OR_TEST_BY_NAME : scope;
        }
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    public void setTestName(@Nullable String name) {
        this.myTestName = name;
    }

    @Nullable
    public String getTargetName() {
        return this.myTargetName;
    }

    public void setTargetName(@Nullable String name) {
        this.myTargetName = name;
    }

    @Nullable
    public String getTestRunnerOptions() {
        return this.myTestRunnerOptions;
    }

    public void setTestRunnerOptions(@Nullable String testRunnerOptions) {
        this.myTestRunnerOptions = testRunnerOptions;
    }

    @Override
    public void check(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/test/DartTestRunnerParameters", "check"));
        }
        super.check(project);
        if (this.myScope == Scope.GROUP_OR_TEST_BY_NAME && StringUtil.isEmpty((String)this.myTestName)) {
            throw new RuntimeConfigurationError("Group or test name is not specified");
        }
    }

    @Override
    protected final DartTestRunnerParameters clone() {
        return (DartTestRunnerParameters)super.clone();
    }

    public static enum Scope {
        FOLDER("All in folder"),
        FILE("All in file"),
        GROUP("Test group"),
        METHOD("Test name"),
        GROUP_OR_TEST_BY_NAME("Group or test by name"),
        MULTIPLE_NAMES("Multiple names");

        private final String myPresentableName;

        private Scope(String name) {
            this.myPresentableName = name;
        }

        public String getPresentableName() {
            return this.myPresentableName;
        }
    }
}

