/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.test.ui;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartCommandLineConfigurationEditorForm;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.test.DartTestRunnerParameters;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DartTestConfigurationEditorForm
extends SettingsEditor<DartTestRunConfiguration> {
    private JPanel myMainPanel;
    private JComboBox myScopeCombo;
    private JLabel myTestFileLabel;
    private TextFieldWithBrowseButton myFileField;
    private JLabel myDirLabel;
    private TextFieldWithBrowseButton myDirField;
    private JLabel myTestNameLabel;
    private JTextField myTestNameField;
    private JLabel myTargetNameLabel;
    private JTextField myTargetNameField;
    private JTextField myTestRunnerOptionsField;
    private EnvironmentVariablesComponent myEnvironmentVariables;

    public DartTestConfigurationEditorForm(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/test/ui/DartTestConfigurationEditorForm", "<init>"));
        }
        this.$$$setupUI$$$();
        DartCommandLineConfigurationEditorForm.initDartFileTextWithBrowse(project, this.myFileField);
        this.myDirField.addBrowseFolderListener(DartBundle.message("choose.dart.directory", new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myDirField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DartTestConfigurationEditorForm.this.onTestDirChanged(project);
            }
        });
        this.myScopeCombo.setModel(new DefaultComboBoxModel<DartTestRunnerParameters.Scope>(new DartTestRunnerParameters.Scope[]{DartTestRunnerParameters.Scope.FOLDER, DartTestRunnerParameters.Scope.FILE, DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME}));
        this.myScopeCombo.setRenderer(new ListCellRendererWrapper<DartTestRunnerParameters.Scope>(){

            public void customize(JList list, DartTestRunnerParameters.Scope value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableName());
            }
        });
        this.myScopeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DartTestConfigurationEditorForm.this.onScopeChanged();
            }
        });
        DocumentAdapter dirListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DartTestConfigurationEditorForm.this.onTestDirChanged(project);
            }
        };
        this.myDirField.getTextField().getDocument().addDocumentListener((DocumentListener)dirListener);
        this.myTestFileLabel.setPreferredSize(this.myEnvironmentVariables.getLabel().getPreferredSize());
        this.myDirLabel.setPreferredSize(this.myEnvironmentVariables.getLabel().getPreferredSize());
        this.myEnvironmentVariables.setAnchor((JComponent)this.myTestFileLabel);
    }

    protected void resetEditorFrom(@NotNull DartTestRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/test/ui/DartTestConfigurationEditorForm", "resetEditorFrom"));
        }
        DartTestRunnerParameters parameters = configuration.getRunnerParameters();
        this.myScopeCombo.setSelectedItem((Object)parameters.getScope());
        String testPath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)parameters.getFilePath()));
        if (parameters.getScope() == DartTestRunnerParameters.Scope.FOLDER) {
            this.myDirField.setText(testPath);
            this.myTargetNameField.setText(parameters.getTargetName());
        } else {
            this.myFileField.setText(testPath);
        }
        this.myTestNameField.setText(parameters.getScope() == DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME ? StringUtil.notNullize((String)parameters.getTestName()) : "");
        this.myTestRunnerOptionsField.setText(parameters.getTestRunnerOptions());
        this.myEnvironmentVariables.setEnvs(parameters.getEnvs());
        this.myEnvironmentVariables.setPassParentEnvs(parameters.isIncludeParentEnvs());
        this.onScopeChanged();
    }

    protected void applyEditorTo(@NotNull DartTestRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/lang/dart/ide/runner/test/ui/DartTestConfigurationEditorForm", "applyEditorTo"));
        }
        DartTestRunnerParameters parameters = configuration.getRunnerParameters();
        DartTestRunnerParameters.Scope scope = (DartTestRunnerParameters.Scope)((Object)this.myScopeCombo.getSelectedItem());
        parameters.setScope(scope);
        TextFieldWithBrowseButton pathSource = scope == DartTestRunnerParameters.Scope.FOLDER ? this.myDirField : this.myFileField;
        parameters.setFilePath(StringUtil.nullize((String)FileUtil.toSystemIndependentName((String)pathSource.getText().trim())));
        parameters.setTestName(scope == DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME ? StringUtil.nullize((String)this.myTestNameField.getText().trim()) : null);
        parameters.setTargetName(scope == DartTestRunnerParameters.Scope.FOLDER ? StringUtil.nullize((String)this.myTargetNameField.getText().trim()) : null);
        parameters.setTestRunnerOptions(StringUtil.nullize((String)this.myTestRunnerOptionsField.getText().trim()));
        parameters.setEnvs(this.myEnvironmentVariables.getEnvs());
        parameters.setIncludeParentEnvs(this.myEnvironmentVariables.isPassParentEnvs());
    }

    private void onScopeChanged() {
        DartTestRunnerParameters.Scope scope = (DartTestRunnerParameters.Scope)((Object)this.myScopeCombo.getSelectedItem());
        this.myTestNameLabel.setVisible(scope == DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME);
        this.myTestNameField.setVisible(scope == DartTestRunnerParameters.Scope.GROUP_OR_TEST_BY_NAME);
        boolean folderMode = scope == DartTestRunnerParameters.Scope.FOLDER;
        boolean projectWithoutPubspec = Registry.is((String)"dart.projects.without.pubspec", (boolean)false);
        this.myFileField.setVisible(!folderMode);
        this.myTestFileLabel.setVisible(!folderMode);
        this.myDirField.setVisible(folderMode);
        this.myDirLabel.setVisible(folderMode);
        this.myTargetNameField.setVisible(folderMode && projectWithoutPubspec);
        this.myTargetNameLabel.setVisible(folderMode && projectWithoutPubspec);
    }

    private void onTestDirChanged(Project project) {
        if (!DartTestConfigurationEditorForm.isDirApplicable(this.myDirField.getText(), project)) {
            this.myDirField.getTextField().setForeground((Color)JBColor.RED);
            String message = DartBundle.message("test.dir.not.in.project", new Object[0]);
            this.myDirField.getTextField().setToolTipText(message);
        } else {
            this.myDirField.getTextField().setForeground(UIUtil.getFieldForegroundColor());
            this.myDirField.getTextField().setToolTipText(null);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/test/ui/DartTestConfigurationEditorForm", "createEditor"));
        }
        return jPanel;
    }

    private static boolean isDirApplicable(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/lang/dart/ide/runner/test/ui/DartTestConfigurationEditorForm", "isDirApplicable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/test/ui/DartTestConfigurationEditorForm", "isDirApplicable"));
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        return file != null && file.isDirectory() && PubspecYamlUtil.findPubspecYamlFile(project, file) != null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JComboBox jComboBox;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JTextField jTextField3;
        JLabel jLabel3;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myTestFileLabel = jLabel4 = new JLabel();
        jLabel4.setText("Test file:");
        jLabel4.setDisplayedMnemonic('F');
        jLabel4.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("Group or test name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(14);
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestNameField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(3, 1, 1, 2, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEnvironmentVariables = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(6, 0, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myScopeCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Test mode:");
        jLabel5.setDisplayedMnemonic('M');
        jLabel5.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myDirLabel = jLabel2 = new JLabel();
        jLabel2.setText("Test folder:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetNameLabel = jLabel = new JLabel();
        jLabel.setText("Target name:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetNameField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Test runner options:");
        jLabel6.setDisplayedMnemonic('R');
        jLabel6.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestRunnerOptionsField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(5, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel3.setLabelFor(jTextField3);
        jLabel5.setLabelFor(jComboBox);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel.setLabelFor(jTextField2);
        jLabel6.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

