/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.runner.util.TestUtil;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTestLocationProvider
implements SMTestLocator,
DumbAware {
    private static final List<Location> NONE = Collections.emptyList();
    private static final Gson GSON = new Gson();
    public static final DartTestLocationProvider INSTANCE = new DartTestLocationProvider();
    public static final Type STRING_LIST_TYPE = new TypeToken<List<String>>(){}.getType();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Location<PsiElement> location;
        PsiFile psiFile;
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
        }
        int commaIdx1 = path.indexOf(44);
        int commaIdx2 = path.indexOf(44, commaIdx1 + 1);
        int commaIdx3 = path.indexOf(44, commaIdx2 + 1);
        if (commaIdx3 < 0) {
            List<Location> list = NONE;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
            }
            return list;
        }
        String filePath = path.substring(0, commaIdx1);
        int line = Integer.parseInt(path.substring(commaIdx1 + 1, commaIdx2));
        int column = Integer.parseInt(path.substring(commaIdx2 + 1, commaIdx3));
        String names = path.substring(commaIdx3 + 1);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        PsiFile psiFile2 = psiFile = file == null ? null : PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof DartFile)) {
            List<Location> list = NONE;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
            }
            return list;
        }
        if (line >= 0 && column >= 0 && (location = DartTestLocationProvider.getLocationByLineAndColumn(psiFile, line, column)) != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<String> nodes = DartTestLocationProvider.pathToNodes(names);
        if (nodes.isEmpty()) {
            List<PsiLocation> list = Collections.singletonList(new PsiLocation((PsiElement)psiFile));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = this.getLocationByGroupAndTestNames(psiFile, nodes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private static Location<PsiElement> getLocationByLineAndColumn(@NotNull PsiFile file, int line, int column) {
        PsiElement parent3;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocationByLineAndColumn"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        int offset = document.getLineStartOffset(line) + column;
        PsiElement element = file.findElementAt(offset);
        PsiElement parent1 = element == null ? null : element.getParent();
        PsiElement parent2 = parent1 instanceof DartId ? parent1.getParent() : null;
        PsiElement psiElement = parent3 = parent2 instanceof DartReferenceExpression ? parent2.getParent() : null;
        if (parent3 instanceof DartCallExpression && (TestUtil.isTest((DartCallExpression)parent3) || TestUtil.isGroup((DartCallExpression)parent3))) {
            return new PsiLocation(parent3);
        }
        return null;
    }

    private static List<String> pathToNodes(String element) {
        return (List)GSON.fromJson(element, STRING_LIST_TYPE);
    }

    @VisibleForTesting
    public List<Location> getLocationForTest(@NotNull PsiFile psiFile, @NotNull String testPath) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocationForTest"));
        }
        if (testPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testPath", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getLocationForTest"));
        }
        return this.getLocationByGroupAndTestNames(psiFile, DartTestLocationProvider.pathToNodes(testPath));
    }

    protected List<Location> getLocationByGroupAndTestNames(PsiFile psiFile, final List<String> nodes) {
        final ArrayList<Location> locations = new ArrayList<Location>();
        if (psiFile instanceof DartFile && !nodes.isEmpty()) {
            PsiElementProcessor<PsiElement> collector = new PsiElementProcessor<PsiElement>(){

                public boolean execute(@NotNull PsiElement element) {
                    DartCallExpression expression;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider$2", "execute"));
                    }
                    if (element instanceof DartCallExpression && (TestUtil.isTest(expression = (DartCallExpression)element) || TestUtil.isGroup(expression)) && ((String)nodes.get(nodes.size() - 1)).equals(DartTestLocationProvider.getTestLabel(expression))) {
                        boolean matches = true;
                        for (int i = nodes.size() - 2; i >= 0 && matches; --i) {
                            if ((expression = this.getGroup(expression)) != null && ((String)nodes.get(i)).equals(DartTestLocationProvider.getTestLabel(expression))) continue;
                            matches = false;
                        }
                        if (matches) {
                            locations.add(new PsiLocation(element));
                            return false;
                        }
                    }
                    return true;
                }

                @Nullable
                private DartCallExpression getGroup(DartCallExpression expression) {
                    return (DartCallExpression)PsiTreeUtil.findFirstParent((PsiElement)expression, (boolean)true, element -> element instanceof DartCallExpression && TestUtil.isGroup((DartCallExpression)element));
                }
            };
            PsiTreeUtil.processElements((PsiElement)psiFile, (PsiElementProcessor)collector);
        }
        return locations;
    }

    @Nullable
    public static String getTestLabel(@NotNull DartCallExpression testCallExpression) {
        if (testCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCallExpression", "com/jetbrains/lang/dart/ide/runner/util/DartTestLocationProvider", "getTestLabel"));
        }
        DartArguments arguments = testCallExpression.getArguments();
        DartArgumentList argumentList = arguments == null ? null : arguments.getArgumentList();
        List<DartExpression> argExpressions = argumentList == null ? null : argumentList.getExpressionList();
        return argExpressions != null && !argExpressions.isEmpty() && argExpressions.get(0) instanceof DartStringLiteralExpression ? StringUtil.unquoteString((String)argExpressions.get(0).getText()) : null;
    }
}

