/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.runner.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestUtil {
    @Nullable
    public static String findGroupOrTestName(@Nullable DartCallExpression expression) {
        DartArgumentList dartArgumentList;
        DartArguments arguments = expression == null ? null : expression.getArguments();
        DartArgumentList dartArgumentList2 = dartArgumentList = arguments == null ? null : arguments.getArgumentList();
        if (dartArgumentList == null || dartArgumentList.getExpressionList().isEmpty()) {
            return null;
        }
        DartExpression dartExpression = dartArgumentList.getExpressionList().get(0);
        String testName = dartExpression == null ? "" : StringUtil.unquoteString((String)dartExpression.getText());
        return testName;
    }

    @Nullable
    public static PsiElement findTestElement(@Nullable PsiElement element) {
        DartCallExpression callExpression = (DartCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, DartCallExpression.class, (boolean)false);
        while (callExpression != null) {
            if (TestUtil.isGroup(callExpression) || TestUtil.isTest(callExpression)) {
                return callExpression;
            }
            callExpression = (DartCallExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpression, DartCallExpression.class, (boolean)true);
        }
        return element != null ? element.getContainingFile() : null;
    }

    public static boolean isTest(@NotNull DartCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/lang/dart/ide/runner/util/TestUtil", "isTest"));
        }
        return TestUtil.checkCalledFunctionName(expression, "test");
    }

    public static boolean isGroup(@NotNull DartCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/lang/dart/ide/runner/util/TestUtil", "isGroup"));
        }
        return TestUtil.checkCalledFunctionName(expression, "group");
    }

    private static boolean checkCalledFunctionName(@NotNull DartCallExpression callExpression, @NotNull String expectedName) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/jetbrains/lang/dart/ide/runner/util/TestUtil", "checkCalledFunctionName"));
        }
        if (expectedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedName", "com/jetbrains/lang/dart/ide/runner/util/TestUtil", "checkCalledFunctionName"));
        }
        return expectedName.equals(callExpression.getExpression().getText());
    }
}

